/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w5pf
 */

package {
  import com.actionscriptbible.Example;
  import flash.events.*;
  import flash.net.URLLoader;
  import flash.net.URLRequest;
  import flash.text.StyleSheet;
  import flash.text.TextField;
  import flash.utils.Timer;

  public class ch26ex1 extends Example {
    protected const STYLESHEET_LOCATION:String =
      "http://actionscriptbible.com/files/example.css";
    protected const BASIC_STYLE:String = 
      "a {text-decoration: underline; color: #0000ff}";
    protected const TIMEOUT:int = 2000;
    protected var timer:Timer;
    protected var loader:URLLoader;
    protected var tf:TextField;
    
    public function ch26ex1() {
      makeTextField();
      loadStyleSheet();
      trace("\n\nLogging ---------------");
    }
    protected function makeTextField():void {
      tf = new TextField();
      tf.width = stage.stageWidth;
      tf.height = stage.stageHeight;
      tf.multiline = true;
      tf.wordWrap = true;
      addChild(tf);
    }
    protected function loadStyleSheet():void {
      loader = new URLLoader();
      loader.addEventListener(IOErrorEvent.IO_ERROR, onLoadError);
      loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR,onLoadError);
      loader.addEventListener(Event.COMPLETE, onLoadSuccess);
      
      loader.load(new URLRequest(STYLESHEET_LOCATION));
      
      timer = new Timer(TIMEOUT, 1);
      timer.addEventListener(TimerEvent.TIMER, onTimeout);
      timer.start();
    }
    protected function onLoadError(event:Event):void {
      removeEventListeners();
      trace("Error loading CSS:", event.type, ". Using basicstyle.");
      setDefaultStyle();
    }
    protected function onLoadSuccess(event:Event):void {
      removeEventListeners();
      try {
        var cssText:String = loader.data;
        var styleSheet:StyleSheet = new StyleSheet();
        styleSheet.parseCSS(cssText);
        setStyle(styleSheet);
        trace("CSS set successfully");
      } catch (error:Error) {
        trace("Error parsing CSS. Using basic style.");
        setDefaultStyle();
      }
    }
    protected function onTimeout(event:TimerEvent):void {
      trace("CSS loading timed out. Using basic style.");
      loader.close();
      removeEventListeners();
      setDefaultStyle();
    }
    protected function removeEventListeners():void {
      timer.stop();
      timer.removeEventListener(TimerEvent.TIMER, onTimeout);
      loader.removeEventListener(IOErrorEvent.IO_ERROR, onLoadError);
      loader.removeEventListener(SecurityErrorEvent.SECURITY_ERROR,onLoadError);
      loader.removeEventListener(Event.COMPLETE, onLoadSuccess);
    }
    protected function setDefaultStyle():void {
      var styleSheet:StyleSheet = new StyleSheet();
      styleSheet.parseCSS(BASIC_STYLE);
      setStyle(styleSheet);
    }
    protected function setStyle(styleSheet:StyleSheet):void {
      tf.styleSheet = styleSheet;
      tf.htmlText = '<p>Welcome to the <span class="title">AS3Bible</span>! ' +
                    'Go <a href="http://actionscriptbible.com/">here</a>.</p>';
    }
  }
}