/**
 * Copyright Albert ( http://wonderfl.net/user/Albert )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w5jL
 */

//http://actionsnippet.com/?s=voxel&searchsubmit=Search

package {
    import flash.display.Sprite;
    import flash.geom.Point;  
    import flash.geom.Vector3D;
    import flash.display.BitmapData;  
    import flash.display.Bitmap;
    
    public class FlashTest extends Sprite {
        // isometric conversion
        private var centerX:Number=stage.stageWidth/2;
        private var centerY:Number=stage.stageHeight/2;
        // 1 to 2 ratio
        // try others 1 / 1.5 etc...
        private var theta:Number = Math.atan(1 / 2);
         
        private var cosX:Number=Math.cos(theta);
        private var sinX:Number=Math.sin(theta);
        private var pnt:Point = new Point();
         
        function iso3D(x:Number, y:Number, z:Number):Point {
            pnt.x = centerX + (x-z) *  cosX;
            pnt.y = centerY -  (x+z) * sinX - y;
            return pnt;
        }
      
        public function FlashTest() {
            var p:Point = iso3D(0,0,0);
             
            graphics.beginFill(0x000000);
            graphics.drawCircle(p.x, p.y, 2);
             
            // x axis positive
            trace("x = red");
            for (var i:int = 1; i<10; i++){
                graphics.beginFill(0xFF0000);
                p = iso3D(i*10, 0, 0);
                graphics.drawCircle(p.x, p.y, 2);
            }
             
            // y axis positive
            trace("y = green");
            for (i= 1; i<10; i++){
                graphics.beginFill(0x00FF00);
                p = iso3D(0, i * 10, 0);
                graphics.drawCircle(p.x, p.y, 2);
            }
             
            // z axis positive
            trace("z = blue");
            for (i= 1; i<10; i++){
                graphics.beginFill(0x0000FF);
                p = iso3D(0, 0, i * 10);
                graphics.drawCircle(p.x, p.y, 2);
            }      
        }
    }
}