/**
 * Copyright psyark ( http://wonderfl.net/user/psyark )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w5HH
 */

/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import caurina.transitions.Tweener;

    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;

    [SWF(width=465,height=465,frameRate=60,backgroundColor=0x000000)]
    public class ProfessionalDepth extends Sprite {
        private var canvas:Model;
        private var layers:Vector.<Layer>;
        private var tmp:BitmapData;
        
        public function ProfessionalDepth() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            // パターン作成
            var pattern1:BitmapData = BitmapPatternBuilder.build([ [1,0,0,0], [0,0,0,0], ], [0x00000000, 0xFFFFFFFF]);
            var pattern2:BitmapData = BitmapPatternBuilder.build([ [0,1,1,0], [0,0,0,0], ], [0x00000000, 0xFFFFFFFF]);
            var pattern3:BitmapData = BitmapPatternBuilder.build([ [0,0,0,0], [1,1,1,1], ], [0x00000000, 0xFFFFFFFF]);
            
            layers = new Vector.<Layer>();
            layers.push(new Layer(pattern1));
            layers.push(new Layer(pattern2));
            layers.push(new Layer(pattern3));
            for each (var layer:Layer in layers) {
                addChild(layer);
            }
            
            tmp = new BitmapData(233, 233, true);
            addEventListener(Event.ENTER_FRAME, enterFrame);
            
            stage.addEventListener(MouseEvent.CLICK, function (event:MouseEvent):void {
                Tweener.removeAllTweens();
                Tweener.addTween(layers[2], { x:+175, time:1, transition:"easeoutquint" });
                Tweener.addTween(layers[1], { x:-175, time:1, transition:"easeoutquint" });
                Tweener.addTween(layers[2], { x:0, time:1, delay:2, transition:"easeinquint" });
                Tweener.addTween(layers[1], { x:0, time:1, delay:2, transition:"easeinquint" });
            });
            
            canvas = new Model();
        }
        
        
        private function enterFrame(event:Event):void {
            canvas.render();
            
            tmp.fillRect(tmp.rect, 0);
            tmp.draw(canvas);
            
            for (var i:int=0; i<layers.length; i++) {
                var layer:Layer = layers[i];
                layer.maskBitmap.fillRect(layer.maskBitmap.rect, 0);
                layer.maskBitmap.threshold(tmp, tmp.rect, new Point(), "==", 1 << i, 0xFFFFFFFF, 1 << i, false);
            }
        }
    }
}

import flash.display.Shape;
import flash.display.Sprite;
import flash.geom.PerspectiveProjection;
import flash.geom.Matrix3D;
import flash.utils.getTimer;
import flash.geom.Utils3D;
import flash.geom.Vector3D;
import flash.display.TriangleCulling;

class Model extends Shape {
    private var texture:BitmapData;
    private var vertices:Vector.<Number>;
    private var indices:Vector.<int>;
    private var uvtData:Vector.<Number>;
    private var projected:Vector.<Number>;
    
    public function Model():void {
        vertices = new Vector.<Number>();
        indices = new Vector.<int>();
        uvtData = new Vector.<Number>();
        projected = new Vector.<Number>();
        
        var hRadius:Number = 100;
        var vRadius:Number = 50;
        var hDiv:int = 32;
        var vDiv:int = 16;
        for (var i:uint=0; i<=hDiv; i++) {
            var s1:Number = Math.PI * 2 * i / hDiv;
            for (var j:uint=0; j<=vDiv; j++) {
                var s2:Number = Math.PI * 2 * j / vDiv;
                var r:Number = Math.cos(s2) * vRadius + hRadius;
                vertices.push(Math.cos(s1) * r, Math.sin(s1) * r, Math.sin(s2) * vRadius);
                uvtData.push(i / hDiv, j / vDiv, 1);
                if (j < vDiv && i < hDiv) {
                    var a:uint =  i      * (vDiv + 1) + j;
                    var b:uint = (i + 1) * (vDiv + 1) + j;
                    indices.push(b, a + 1, a, a + 1, b, b + 1);
                }
            }
        }
        
        texture = new BitmapData(8, 1, false);
        for (var k:int=0; k<texture.width; k++) {
            texture.setPixel(k, 0, k);
        }
    }
        
    public function render():void {
        var pers:PerspectiveProjection = new PerspectiveProjection();
        pers.fieldOfView = 60;
        var mtx:Matrix3D = new Matrix3D();
        mtx.appendRotation(getTimer() * 0.3000 * 0.3, Vector3D.Y_AXIS);
        mtx.appendRotation(getTimer() * 0.0571 * 0.3, Vector3D.X_AXIS);
        mtx.appendTranslation(0, 0, 800);
        mtx.append(pers.toMatrix3D());
        //mtx.appendTranslation(465 / 2, 465 / 2, 0);
        Utils3D.projectVectors(mtx, vertices, projected, uvtData);
        for (var j:int=0; j<projected.length; j++) {
            projected[j] += 116.2;
        }
        
        var minZ:Number = 0.00105263;
        var maxZ:Number = 0.00153847;
        minZ = 0.00110;
        maxZ = 0.00154;
        var r:Number = 1 / (maxZ - minZ);
        for (var i:int=0; i<uvtData.length; i+=3) {
            var z:Number = uvtData[i+2];
            uvtData[i] = (z - minZ) * r;
        }
        
        graphics.clear();
        graphics.beginBitmapFill(texture);
        graphics.drawTriangles(projected, getSortedIndices(indices, uvtData), uvtData, TriangleCulling.POSITIVE);
    }
        
        
    /**
     * Zソートされたインデックスを返す
     */
    private function getSortedIndices(indices:Vector.<int>, uvtData:Vector.<Number>):Vector.<int> {
        var triangles:Array = [];
        for (var i:uint=0; i<indices.length; i+=3) {
            var i1:uint = indices[i+0], i2:uint = indices[i+1], i3:uint = indices[i+2];
            var z:Number = Math.min(uvtData[i1 * 3 + 2], uvtData[i2 * 3 + 2], uvtData[i3 * 3 + 2]);
            if (z > 0) { triangles.push({i1:i1, i2:i2, i3:i3, z:z}); }
        }
        var sortedIndices:Vector.<int> = new Vector.<int>();
        for each (var triangle:Object in triangles.sortOn("z", Array.NUMERIC)) {
            sortedIndices.push(triangle.i1, triangle.i2, triangle.i3);
        }
        return sortedIndices;
    }
}

class Layer extends Sprite {
    private var shape:Shape;
    public var maskBitmap:BitmapData;
    
    public function Layer(pattern:BitmapData):void {
        shape = new Shape();
        shape.graphics.beginBitmapFill(pattern);
        shape.graphics.drawRect(0, 0, 465, 465);
        
        maskBitmap = new BitmapData(233, 233, true, 0);
        
        var bitmap:Bitmap = new Bitmap(maskBitmap);
        bitmap.scaleX = bitmap.scaleY = 2;
        
        shape.mask = bitmap;
        shape.cacheAsBitmap = bitmap.cacheAsBitmap = true;
        
        addChild(shape);
        addChild(bitmap);
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}