/**
 * Copyright ricserje ( http://wonderfl.net/user/ricserje )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w4gu
 */

package
{
    import flash.events.MouseEvent;
 
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.view.BasicView;
    
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
 
    [SWF(width="640", height="480", backgroundColor="#000000", frameRate="60")]
    public class OrbitingCameraExample extends BasicView
    {
        private var isOribiting:Boolean;
        private var cameraPitch:Number = 90;
        private var cameraYaw:Number = 270;
        private var cameraTarget:DisplayObject3D = DisplayObject3D.ZERO;
        private var previousMouseX:Number;
        private var previousMouseY:Number;
 
        private var light:PointLight3D;
 
        public function OrbitingCameraExample()
        {
            light = new PointLight3D();
            var material:FlatShadeMaterial = new FlatShadeMaterial(light, 0xcc0000);
 
            var sphere1:Sphere = new Sphere(material, 300, 10, 10);
            var sphere2:Sphere = new Sphere(material, 100, 10, 10);
            sphere2.x = 300;
            sphere2.y = 300;
            sphere2.z = 700
            var sphere3:Sphere = new Sphere(material, 100, 10, 10);
            sphere3.x = 600;
            sphere3.y = -400;
            sphere3.z = -200;
            var sphere4:Sphere = new Sphere(material, 100, 10, 10);
            sphere4.x = -700;
            sphere3.z = -100;
 
            scene.addChild(sphere1);
            scene.addChild(sphere2);
            scene.addChild(sphere3);
            scene.addChild(sphere4);
 
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, stage_keyDownHandler);
            stage.addEventListener(KeyboardEvent.KEY_UP, stage_keyUpHandler);
 
            startRendering();
        }
 
        private function onMouseDown(event:MouseEvent):void
        {
            isOribiting = true;
            previousMouseX = event.stageX;
            previousMouseY = event.stageY;
        }
 
        private function onMouseUp(event:MouseEvent):void
        {
            isOribiting = false;
        }
 
        private function onMouseMove(event:MouseEvent):void
        {
            var differenceX:Number = event.stageX - previousMouseX;
            var differenceY:Number = event.stageY - previousMouseY;
 
            if(isOribiting)
            {
                cameraPitch += differenceY;
                cameraYaw += differenceX;
 
                cameraPitch %= 360;
                cameraYaw %= 360;
 
                cameraPitch = cameraPitch > 0 ? cameraPitch : 0.0001;
                cameraPitch = cameraPitch < 90 ? cameraPitch : 89.9999;
 
                previousMouseX = event.stageX;
                previousMouseY = event.stageY;
 
                camera.orbit(cameraPitch, cameraYaw, true, cameraTarget);
            }
        }
        
        private function stage_keyDownHandler(event:KeyboardEvent):void
        {
            switch(event.keyCode)
            {
                case Keyboard.LEFT:
                    camera.y+=5;
                    break;
 
                case Keyboard.RIGHT:
                    camera.y -= 5;
                    break;
            }
        }
 
        private function stage_keyUpHandler(event:KeyboardEvent):void
        {
            switch(event.keyCode)
            {
                case Keyboard.UP:
                   camera.focus += 1;
                    break;
 
                case Keyboard.DOWN:
                  camera.focus -= 1;
                    break;
            }
 
        }
    }
}