/**
 * Copyright kamip ( http://wonderfl.net/user/kamip )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w4Cj
 */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import fl.transitions.Tween;
	import fl.motion.easing.*;
	import fl.transitions.easing.*;
	import flash.utils.Timer;
	import flash.events.TimerEvent;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.display.Loader;
	import fl.transitions.TweenEvent;
	/**
	 * ...
	 * @author kamip
	 * よくあるFPSゲームとかのAim練習機
	 * つくりが雑ですいません
	 * 頑張ったら20クリックくらい・・
	 * http://d.hatena.ne.jp/kamip/
	 */
	[SWF(width = "465", height = "465", backgroundColor = "0xdcdcdc", fps = "30")]
	public class Main extends Sprite 
	{
		private var _container:Sprite;
		private var _circle1:Loader;
		private var _circle2:Loader;
		private var _clickCounter:ClickCounter;
		private var _clickCount:int = 0;
		private var _sec:Number = .5;
		private var _tween_array:Array = new Array();
		private var _timeCheck:Timer;
		private var _image1_loaded:Boolean = false;
		private var _image2_loaded:Boolean = false;
		private var _finishFlag:Boolean = false;
		private var _startFlag:Boolean = false;
		private var _timer:CountDownTimer;
		
		public function Main():void 
		{
			init();
		}
		
		private function init(e:Event = null):void 
		{
			
			//コンテナ設置
			_container = new Sprite();
			addChild(_container);
			
			//クリックカウンター
			_clickCounter = new ClickCounter();
			addChild(_clickCounter);
			
			//カウントダウンタイマー
			_timer = new CountDownTimer();
			addChild(_timer);
			
			//画像読み込み
			loadImages();
			
			_container.x = stage.stageWidth / 2;
			_container.y = stage.stageHeight / 2;
			_container.addEventListener(MouseEvent.CLICK, onClickEvent);
			addChild(_container);
			
		}
		private function onClickEvent(e:MouseEvent):void {
			if (_image1_loaded == true && _image2_loaded == true) {
				if (_finishFlag == false && _startFlag == false) {
					_startFlag = true;
					_timer.set_start_time();//ここでtimerスタート！
					stage.addEventListener(Event.ENTER_FRAME, onCheckFinished);
				}
			}
			
			_clickCount += 1;
			_clickCounter._txt.text = "現在のクリック回数" + _clickCount;
			
			var pi:Number = 100;
			var randX:Number = Math.round(Math.random() * (stage.stageWidth - pi * 2)) + pi;
			var randY:Number = Math.round(Math.random() * (stage.stageHeight - pi * 2)) + pi;
			
			//tween
			var tweenA:Tween = new Tween(_circle2, "alpha", None.easeNone, 1, 0, _sec, true);
			tweenA.addEventListener(TweenEvent.MOTION_FINISH, onFinishEvent);
			_tween_array.push(tweenA);
			var tweenX:Tween = new Tween(_container, "x", Quadratic.easeOut, _container.x, randX, _sec, true);
			tweenX.addEventListener(TweenEvent.MOTION_FINISH, onFinishEvent);
			_tween_array.push(tweenX);
			var tweenY:Tween = new Tween(_container, "y", Quadratic.easeOut, _container.y, randY, _sec, true);
			tweenY.addEventListener(TweenEvent.MOTION_FINISH, onFinishEvent);
			_tween_array.push(tweenY);
			var buhi:Buhi = new Buhi();
			buhi.x = mouseX;
			buhi.y = mouseY;
			addChildAt(buhi, 0);
		}
		
		private function onFinishEvent(te:TweenEvent):void {
			var tween:Tween = Tween(te.target);
			var bResult:Boolean = xDispose(tween);   // 配列からTweenを削除
		}
		
		private function xDispose(obj:Tween):Boolean {
			var nLength:int = _tween_array.length;
			for (var i:int = 0; i<nLength; i++) {
				if (_tween_array[i] == obj) {
					_tween_array.splice(i, 1);
					return true;
				}
			}
			return false;
		}
		
		private function onCheckFinished(e:Event):void {
			if (_timer._finished_flg == true) {
				stage.removeEventListener(Event.ENTER_FRAME, onCheckFinished);
				_container.removeEventListener(MouseEvent.CLICK, onClickEvent);
			}
		}
		
		private function loadImages():void {
            var rq:URLRequest = new URLRequest(); 
            rq.url = "http://dmpm.org/images/fere1.png";
            var loader:Loader = new Loader();
            var lc:LoaderContext = new LoaderContext();
            lc.checkPolicyFile = true;
            loader.load(rq, lc); //LoaderContextオブジェクトを第2引数に
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete1);
            //loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onIoError1);
			_circle1 = loader;
			_container.addChild(_circle1);
			
            var rq2:URLRequest = new URLRequest(); 
            rq2.url = "http://dmpm.org/images/fere2.png";
            var loader2:Loader = new Loader();
            var lc2:LoaderContext = new LoaderContext();
            lc2.checkPolicyFile = true;
            loader2.load(rq2, lc2); //LoaderContextオブジェクトを第2引数に
            loader2.contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete2);
            //loader2.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, onIoError2);
			_circle2 = loader2;
			_circle2.alpha = 0;
			_container.addChild(_circle2);
		}
		
		private function onComplete1(e:Event):void {
			_image1_loaded = true;
		}
		
		private function onComplete2(e:Event):void {
			_image2_loaded = true;
		}
		
	}
	
}

import flash.events.Event;
import flash.filters.BlurFilter;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.display.Sprite;
import flash.text.TextFieldAutoSize;

class ClickCounter extends Sprite {
	public var _txt:TextField;
	public function ClickCounter() {
		_txt = new TextField();
		_txt.width = 250;
		_txt.height = 30;
		var tf:TextFormat = new TextFormat();
		tf.color = 0x000000;
		_txt.defaultTextFormat = tf;
		_txt.appendText("clickするとスタート！");
		addChild(_txt);
	}
	
	public function get txt():TextField { return _txt; }
	
	public function set txt(value:TextField):void 
	{
		_txt = value;
	}
}

class CountDownTimer extends Sprite {
	public var timer:TextField;
	public var _limit:Number;
	public var _finished_flg:Boolean;
	private var _set_time:Number;
	
	public function CountDownTimer(limit:Number = 10) {
		_limit = limit;
		_finished_flg = false;
		timer = new TextField();
		var tf:TextFormat = new TextFormat();
		timer.autoSize = TextFieldAutoSize.LEFT;
		timer.selectable = false;
		timer.x = 0;
		timer.y = 20;
		timer.text = "";
		addChild(timer);
	}
	
	public function set_start_time():void {
		_set_time = (new Date).time;
		addEventListener(Event.ENTER_FRAME, play);
	}
	
	public function play(e:Event):void {
		var st:String = String(Math.round((_limit - ((new Date).time - _set_time) / 1000) * 10));
		var len:int = st.length - 1;
		var num:String = st.substr(0, len);
		if ( num == false) {
			num = "0";
		}
		var limit_time:String = num + "." + st.substr(len, 1);
		timer.text = limit_time
		if (Number(limit_time) == 0) {
			_finished_flg = true;
			removeEventListener(Event.ENTER_FRAME, play)
		}
	}
	
	public function get limit():Number { return _limit; }
	
	public function set limit(value:Number):void 
	{
		_limit = value;
	}
}

import flash.display.BitmapData;
import flash.display.Bitmap;
import fl.transitions.Tween;
import fl.transitions.easing.None;
import fl.transitions.TweenEvent;
class Buhi extends Sprite {
	private var paletteArr:Array = new Array();
	private var _bm:Bitmap;
	private var _size:Number = 30;
	private var _tweenArray:Array = new Array();
	public function Buhi() {
		_bm = makeBuhi();
		addChild(_bm);
		var tweenA:Tween = new Tween(_bm, "alpha", None.easeNone, 1, 0, 2, true);
		var tweenX:Tween = new Tween(_bm, "scaleX", None.easeNone, 1, 0, 2, true);
		var tweenY:Tween = new Tween(_bm, "scaleY", None.easeNone, 1, 0, 2, true);
		tweenA.addEventListener(TweenEvent.MOTION_FINISH, onTweenFinished);
		tweenX.addEventListener(TweenEvent.MOTION_FINISH, onTweenFinished);
		tweenY.addEventListener(TweenEvent.MOTION_FINISH, onTweenFinished);
		_tweenArray.push(tweenA);
		_tweenArray.push(tweenX);
		_tweenArray.push(tweenY);
	}
	
	public function makeBuhi():Bitmap {
		paletteArr = [0xcc6600, 0xcc6666, 0xcc6600, 0x663300, 0xffcc00];
		var tf:TextField = new TextField();
		var fmt:TextFormat = new TextFormat();
		fmt.color = paletteArr[Math.floor(Math.random() * 5)];
		fmt.size = _size;
		//tf.x = x;
		//tf.y = y;
		//trace("x:" + x + ", y:" + y);
		tf.defaultTextFormat = fmt;
		tf.text = "ブヒ";
		tf.background = false;
		tf.selectable = false;
		tf.width = tf.textWidth + 10;
		tf.height = tf.textHeight + 10;
		tf.filters = [ new BlurFilter() ];
		var bmd:BitmapData = new BitmapData(tf.width, tf.height, true, 0xFFFFFF);
        bmd.draw(tf);
        return new Bitmap(bmd);
	}
	
	private function onTweenFinished(te:TweenEvent):void {
		var tween:Tween = Tween(te.target);
		xDispose(tween);
	}
	private function xDispose(obj:Tween):Boolean {
		var nLength:int = _tweenArray.length;
		for (var i:int = 0; i<nLength; i++) {
			if (_tweenArray[i] == obj) {
				_tweenArray.splice(i, 1);
				return true;
			}
		}
		return false;
	}
	
}