/**
 * Copyright plus-tic ( http://wonderfl.net/user/plus-tic )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w48N
 */

//wonderfl本、見ながら練習してみた。
package{
    import flash.display.Sprite;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.geom.ColorTransform;
    import flash.display.BitmapDataChannel;
    import flash.filters.BlurFilter;
    import flash.events.Event;
    import flash.events.MouseEvent;
    public class BD extends Sprite{
       
        private var bmpdata:BitmapData;
        private var colortrans:ColorTransform;
        private var filter:BlurFilter;
        private var vectormap:BitmapData;
        private var particles:Array;
        private var particle_num:uint = 25000;
        private var size:Number = 465;
        
        [SWF(width = 465, height=465, backgroundColor = 0, frameRate = 60)]
        public function BD(){
            //
            bmpdata = new BitmapData(size, size, false, 0);
            addChild(new Bitmap(bmpdata));
            //
            colortrans = new ColorTransform(0.95, 0.99, 0.99);
            filter = new BlurFilter(2, 2, 1);
            //
            vectormap = new BitmapData(size, size, false, 0);
            reset();
            //
            addEventListener(Event.ENTER_FRAME,enterframe);
            stage.addEventListener(MouseEvent.CLICK, reset );
        }
        
        private function reset(e:MouseEvent = null):void{
            //
            var randomSeed:int = Math.random()*0xFFFFFF;
            var colors:uint = BitmapDataChannel.RED | BitmapDataChannel.GREEN;
            vectormap.perlinNoise(size/2, size/2, 4, randomSeed, false, true, colors);
            //
            particles = new Array(particle_num);
            for(var i:int = 0; i< particle_num; i++){
                particles[i] = new Particle(Math.random()*size, Math.random()*size);
            }
        }
        
        private function enterframe(e:Event):void{
            //
            bmpdata.applyFilter(bmpdata, bmpdata.rect, bmpdata.rect.topLeft, filter);
            bmpdata.colorTransform(bmpdata.rect, colortrans);
            //
            bmpdata.lock();
            for(var i:int = 0; i < particle_num; i++){
                var p:Particle = particles[i];
                //
                var col:uint = vectormap.getPixel(p.x,p.y);
                p.ax += ((col >> 16 & 0xff) - 128 ) * 0.0005;
                p.ay += ((col >> 8 & 0xff) -128) * 0.0005;
                //
                p.x += p.vx += p.ax;
                p.y += p.vy += p.ay;
                if(p.x >size){p.x -= size;}
                else if(p.x < 0){p.x += size;}
                if(p.y >size){p.y -= size;}
                else if(p.y < 0){p.y += size;}
                //
                bmpdata.setPixel(p.x, p.y, 0xffffff);
                //
                p.ax *= 0.96; 
                p.ay *= 0.96;
                p.vx *= 0.92;
                p.vy *= 0.92;
            }
            bmpdata.unlock();
        }
    }
}

class Particle{
    //位置
    public var x:Number;
    public var y:Number;
    //加速度
    public var ax:Number=0;
    public var ay:Number=0;
    //速度
    public var vx:Number=0;
    public var vy:Number=0;
    function Particle(px:Number, py:Number){
        x = px;
        y = py;
    }
}

