/**
 * Copyright omari ( http://wonderfl.net/user/omari )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w44H
 */

// forked from logicalyze's SiON EventTrigger（同梱サンプルそのまんまの解説用です）
/* SiON EventTrigger同梱サンプルそのまんまです。（解説用です）*/
package {
    import flash.display.*;
    import flash.events.*;
    import org.si.sion.*;
    import org.si.sion.events.*;
    public class EventTrigger extends Sprite {
        // ドライバ・インスタンスを生成
        public var driver:SiONDriver = new SiONDriver();
        // MML data（SiONData型を宣言）
        public var mainMelody:SiONData;
        // コンストラクタ
        function EventTrigger() {
            // トリガー・コマンド (%t)を付加してコンパイルする
            mainMelody = driver.compile("%t0,1,1 t100 l8 [ccggaag4 ffeeddc4 | [ggffeed4]2 ]2");
            // トリガー用のイベントリスナーを設定
            driver.addEventListener(SiONTrackEvent.NOTE_ON_FRAME,  _onNoteOn);
            driver.addEventListener(SiONTrackEvent.NOTE_OFF_FRAME, _onNoteOff);
            addEventListener("enterFrame", _onEnterFrame);
            // 再生
            driver.play(mainMelody);
        }
        // ノート・オン時のアクション
        private function _onNoteOn(e:SiONTrackEvent) : void {
            _createNoteShape(e.note);
        }
        // ノート・オフ時のアクション
        private function _onNoteOff(e:SiONTrackEvent) : void {
        }
        // シェイプを作成
        private function _createNoteShape(noteNumber:int) : Shape {
            var shape:Shape = new Shape();
            shape.graphics.beginFill([0xff8080, 0x80ff80, 0x8080ff, 0xffff80][int(Math.random()*4)]);
            shape.graphics.drawCircle(0, 0, Math.random()*20+10);
            shape.graphics.endFill();
            shape.x = (noteNumber - 60) * 30 + 100;
            shape.y = 400;
            addChild(shape);
            return shape;
        }
        // フレーム毎のアクション
        private function _onEnterFrame(e:Event) : void {
            var imax:int = numChildren;
            for (var i:int=0; i<imax ; i++) {
                var child:DisplayObject = getChildAt(i);
                child.y -= 2;
                child.alpha *= 0.98;
                if (child.y < -30 || child.alpha < 0.1) {
                    //removeChild(child);
                    imax--;
                    i--;
                }
            }
        }
    }
}