/**
 * Copyright ug24k8 ( http://wonderfl.net/user/ug24k8 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w3Pl
 */

// forked from yawakisin's Kaleido Sketch
/*
  なんかきれいになるかも？とおもってやってみたけど思った以上にきれいにならなかった…
  
  ドット打ちだとやっぱりきれいにならないので、リボンに変更してみたらわりとよさ気に？
*/

package {
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import frocessing.core.*;
    import frocessing.color.*;

    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="30")]

    public class KaleidoSketch extends Sprite {

        static private const MARK_SIZE:uint = 12;
        static private const MARK_SPEED:Number = 20;
        static private const MARK_MIN_SPEED:Number = 3;
        static private const BRUSH_MAX_SIZE:uint = 5;
        static private const BRUSH_MIN_SIZE:uint = 2;

        static private var center_:Point = new Point();
        static private const rot_unit_:Number = 2 * Math.PI / MARK_SIZE;

        private var marker_:Vector.<Mark> = new Vector.<Mark>(MARK_SIZE);
        private var select_mark_:Mark = null;
        private var last_select_mark_:Mark = null;
        private var canvas:BitmapData;
        private var canvas_bmp:Bitmap;
        private var colortrans_:ColorTransform;
        private var brush_size_:Number = BRUSH_MIN_SIZE;
        private var ribbon_:Ribbon = new Ribbon();

        // constructor

        public function KaleidoSketch() {
            var i:int;
            center_.x = stage.stageWidth / 2;
            center_.y = stage.stageHeight / 2;
            graphics.beginFill(0x00000);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            
            canvas = new BitmapData(
                            stage.stageWidth,
                            stage.stageHeight,
                            true, 0x00000000);
            colortrans_ = new ColorTransform(
                                0.99999999,
                                0.99999999,
                                0.99999999);

            canvas_bmp = new Bitmap(canvas, "auto", true);
            addChild(canvas_bmp);
            ribbon_.x = center_.x;
            ribbon_.y = center_.y;
            //ribbon_.filters = [new BlurFilter(), new GlowFilter(0xffffff, 0.4, 12, 12)];
//            ribbon_.filters = [new GlowFilter(0xffffff, 0.25, 2, 2)];
//            addChild(ribbon_);

            // マーク作成
            for (i = 0; i < MARK_SIZE; ++i) {
                marker_[i] = new Mark(i, Math.ceil(i * 255 / MARK_SIZE));
                marker_[i].pos = Point.polar(25, rot_unit_ * i).add(center_);

                // 描画登録
                addChild(marker_[i]);
                marker_[i].addEventListener(MouseEvent.MOUSE_DOWN, markMouseDown);
            }

            stage.addEventListener(MouseEvent.MOUSE_UP, stageMouseUp);
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }

        // private

        private function synchronize():void {
            var i:int;
            var geom_pos:Point = select_mark_.pos.subtract(center_);
            var geom_rot:Number = Math.atan2(geom_pos.y, geom_pos.x);
            var geom_len:Number = geom_pos.length;

            // 元の位置からの角度差分(ただし偶数マークは反転値)
            var axis_rot:Number = select_mark_.id * rot_unit_;
            geom_rot -= axis_rot;
            if (select_mark_.id % 2 == 0) geom_rot *= -1;

            // 適用
            var new_rot:Number;
            for (i = 0; i < MARK_SIZE; ++i) {
                new_rot = i * rot_unit_ + ((i % 2)? geom_rot: -geom_rot);
                marker_[i].pos = Point.polar(geom_len, new_rot).add(center_);
            }
        }

        private function markMouseDown(evt:MouseEvent):void {
            if (select_mark_) select_mark_.cancel();
            var target:Mark = evt.target as Mark;
            if (target) {
                target.select();
                select_mark_ = target;
                last_select_mark_ = target;
            }
        }

        private function stageMouseUp(evt:MouseEvent):void {
            if (select_mark_) select_mark_.cancel();
            select_mark_ = null;
        }

        private function onEnterFrame(evt:Event):void {
            var i:int;
            if (select_mark_) {
                var oldPos:Point = marker_[0].pos.clone();
                var pos:Point = select_mark_.pos;
                var target:Point = new Point(stage.mouseX, stage.mouseY);
                target.x = Math.max(target.x, 1);
                target.x = Math.min(target.x, stage.stageWidth - 1);
                target.y = Math.max(target.y, 1);
                target.y = Math.min(target.y, stage.stageHeight - 1);
                var move:Point = target.subtract(pos);
                var brush_size:Number = BRUSH_MIN_SIZE;

                if (move.length > MARK_MIN_SPEED) {
                    if (move.length > MARK_SPEED) {
                        move.normalize(MARK_SPEED);
                    }
                    brush_size += (BRUSH_MAX_SIZE - BRUSH_MIN_SIZE) / (MARK_SPEED - MARK_MIN_SPEED)
                                    * (move.length - MARK_MIN_SPEED);
                }
                select_mark_.pos = pos.add(move);

                synchronize();
                var grad_mat:Matrix = new Matrix();
                if (! marker_[0].pos.equals(oldPos)) {
                    // 動いた！
                    brush_size_ = (brush_size - brush_size_) * 0.3 + brush_size_;
                    ribbon_.add_point(
                                marker_[0].pos.subtract(center_),
                                select_mark_.hue,
                                brush_size_,
                                Math.atan2(oldPos.x - marker_[0].pos.x, oldPos.y - marker_[0].pos.y));
                    var matrix:Matrix = new Matrix()
                    canvas.fillRect(canvas.rect, 0x000000);
                    for (i = 0; i < MARK_SIZE; ++i) {
                        matrix.identity();
                        if (i % 2) matrix.scale( 1, -1);
                        matrix.rotate(i * rot_unit_);
                        matrix.translate(stage.stageWidth / 2, stage.stageHeight / 2);
                        canvas.draw(ribbon_, matrix, null, BlendMode.ADD);
                    }
                    canvas.applyFilter(canvas, canvas.rect, new Point(), new GlowFilter(0xffffff, 0.1, 10, 10));
                }
            }
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
import frocessing.core.*;
import frocessing.display.*;

class Ribbon extends Sprite {

    static private const POINT_SIZE:uint = 180;
    private var point_list_:Array = new Array;
    private var angle_:Number = 0;
    private var color_:Number = 0;
    private var size_:Number = 0;
    private var fg_:F5Graphics2D;
    
    public function Ribbon() {
        fg_ = new F5Graphics2D(graphics);
        fg_.colorMode("hsv", 255, 255, 255);
        fg_.noStroke();
    }
    
    public function draw_ribbon():void {
        var i:int;
        fg_.clear();
        if (point_list_.length >= 4) {
            for (i = 3; i < point_list_.length; ++i) {
                fg_.fill(point_list_[i - 1].hue_, 255, 255, i / point_list_.length);
                fg_.beginShape();
                fg_.curveVertex(point_list_[i - 3].point_up_.x, point_list_[i - 3].point_up_.y);
                fg_.curveVertex(point_list_[i - 2].point_up_.x, point_list_[i - 2].point_up_.y);
                fg_.curveVertex(point_list_[i - 1].point_up_.x, point_list_[i - 1].point_up_.y);
                fg_.curveVertex(point_list_[i - 0].point_up_.x, point_list_[i - 0].point_up_.y);
                fg_.vertex(point_list_[i - 1].point_down_.x, point_list_[i - 1].point_down_.y);
                fg_.curveVertex(point_list_[i - 0].point_down_.x, point_list_[i - 0].point_down_.y);
                fg_.curveVertex(point_list_[i - 1].point_down_.x, point_list_[i - 1].point_down_.y);
                fg_.curveVertex(point_list_[i - 2].point_down_.x, point_list_[i - 2].point_down_.y);
                fg_.curveVertex(point_list_[i - 3].point_down_.x, point_list_[i - 3].point_down_.y);
                fg_.endShape();
            }
        }
    }
    
    public function add_point(point:Point, color:uint, size:Number, angle:Number):void {
        if (point_list_.length == 0) {
            color_ = color;
        }
        else {
            while (point_list_.length >= POINT_SIZE) {
                point_list_.shift();
            }
        }
        
        // 簡易イージング
        angle_ += (angle - angle_) * 0.000002;
        if (color - color_ > 128) color_ += 255;
        color_ += (color - color_) * 0.25;
        size_ += (size - size_) * 0.05;
        
        var offset:Point = Point.polar(size_, angle);
        
        var point_up:Point = point.add(offset);
        var point_down:Point = point.subtract(offset);
        point_list_.push( {point_up_:point_up, point_down_:point_down, hue_:color_} );
        draw_ribbon();
    }
}

class Mark extends Sprite {
    static private const IN_SIZE:uint = 5;
    static private const OUT_SIZE:uint = 8;

    private var color_:uint;
    private var anime_frame_:uint;                    // アニメ用カウンタ
    private var id_:int;
    private var pos_:Point = new Point();
    private var fg_:F5Graphics2D;
    private var hue_:uint;

    // constructor

    public function Mark(id:int, hue:uint) {
        id_ = id;
        hue_ = hue;
        fg_ = new F5Graphics2D(graphics);
        fg_.colorMode("hsv", 255, 255, 255);
        drawCircle(OUT_SIZE);
    }


    // public

    public function get id():int { return id_; }

    public function get pos():Point { return pos_; }

    public function get hue():uint { return hue_; }

    public function set pos(pos:Point):void {
        pos_ = pos;
        x = pos_.x;
        y = pos_.y;
    }

    public function select():void {

        anime_frame_ = 0;
        addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    public function cancel():void {

        removeEventListener(Event.ENTER_FRAME, onEnterFrame);

        drawCircle(OUT_SIZE);
    }


    // private

    private function drawCircle(size:Number):void {
        graphics.clear();
        fg_.strokeWeight(1);

        // 内円
        fg_.noStroke();
        fg_.fill(hue_, 255, 255)
        fg_.circle(0, 0, IN_SIZE);

        // 外円
        fg_.stroke(hue_, 255, 255);
        fg_.noFill();
        fg_.circle(0, 0, size);
    }

    private function onEnterFrame(evt:Event):void {
        ++anime_frame_;
        var size:Number = IN_SIZE + (OUT_SIZE * 1.5 - IN_SIZE) * Math.sin(anime_frame_ * 0.1 % Math.PI);

        drawCircle(size);
    }
}
