/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w3MU
 */

// forked from Kay's Line class for easy drawing, vol.1
/*
 * Line.start(x,y,radian)
 * Line.straight(len[,toAngle])
 * Line.curve(radius,angle[,toAngle])
 * Line.draw([lineStyle value])
 */
package {
    import flash.display.Sprite;
    import flash.events.Event;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var radius:int = 0;
            var max:int = 180;
            var count:int = max;
            var sprite:Sprite = new Sprite();
            sprite.x = stage.stageWidth/2;
            sprite.y = stage.stageHeight/2;
            addChild(sprite);

            addEventListener(Event.ENTER_FRAME, run);

            function run (e:Event):void {
                var spiral:Line = new Line(sprite.graphics);
                sprite.graphics.clear();
                spiral.start(0,0);
                while (radius < count) {
                    radius+=2;
                    spiral.corner(radius,120);
                }
                radius = max - radius;
                spiral.corner(radius,-120,-180);
                while (radius > 0) {
                    radius-=2;
                    spiral.corner(radius,-120);
                }
                spiral.draw(3,0x000000);
                sprite.rotation = count * 120 + count/2;
                sprite.y += 2;
                count-=2;
                if (count < 0) removeEventListener(Event.ENTER_FRAME, run);
            }
        }
    }
}
//package jp.seeda.graphics{
    import flash.display.Graphics;
    import flash.geom.Point;
    import flash.geom.Matrix;
    /*public*/ class Line {

        protected var target:Graphics;
        private var nX:Number;
        private var nY:Number;
        private var nAngle:Number;
        private var nRadian:Number;
        private var points:Vector.<Number>=new Vector.<Number>  ;
        private var commands:Vector.<int>=new Vector.<int>  ;

        public function Line(gTarget:Graphics):void {
            target = gTarget;
        }

        public function draw(thickness:Number=0,
                             color:uint=0,alpha:Number=1,
                             pixelHinting:Boolean=false,
                             scaleMode:String = "normal",
                             caps:String=null,
                             joints:String=null,
                             miterLimit:Number=3):void {
            target.lineStyle(thickness, color, alpha, pixelHinting, scaleMode, caps, joints, miterLimit);
            target.drawPath(commands, points);
        }

        public function start(x:Number=0, y:Number=0, angle:Number=0):void {
            nX=x;
            nY=y;
            nAngle = angle;
            nRadian=angle2radian(nAngle);
            points.push(nX,nY);
            commands.push(1);
        }

        public function straight(length:Number=0, angle:Number=NaN):void {
            if (!isNaN(angle)) nAngle += angle;
            nRadian = angle2radian(nAngle);
            nX +=length*Math.cos(nRadian);
            nY +=length*Math.sin(nRadian);
            points.push(nX,nY);
            commands.push(2);
        }
        
        /*
         * 現在角（nRadian,nAngle）から半径（radius）／角度（angle）で円弧を描くPointを取得
         */
        public function corner(radius:Number=100, toAngle:Number=45, fromAngle:Number=NaN):void {
            if (!isNaN(fromAngle)) nAngle += fromAngle;
            var nFromRadian:Number = angle2radian(nAngle);

            // 相対到達角
            var nToRadian:Number = angle2radian(toAngle);
            nToRadian = getRangeValue(nToRadian, Math.PI*2);
            
            var cp:Array = getArcPoints(radius, nToRadian);
            var matrix:Matrix = new Matrix();
            matrix.translate(-radius,0);
            matrix.rotate(nFromRadian-Math.PI/2);
            matrix.translate(nX, nY);
            var max:int = cp.length-1;
            for (var i:int = 1; i < max; i+=2) {
                var control:Point = matrix.transformPoint(cp[i]);
                var anchor:Point  = matrix.transformPoint(cp[i+1]);
                points.push(control.x, control.y, anchor.x, anchor.y);
                nX = anchor.x;
                nY = anchor.y;
                commands.push(3);
            }
            nAngle += toAngle;
            nRadian = angle2radian(nAngle);
        }

        // コントロール／アンカーポイントをおプロジェクトとして取得
        // Point(0,0), radian:0から取得しておき後にmatrixで移動
        public static function getArcPoints(nRadius:Number, toRadian:Number):Array {
            var points:Array = new Array();
            var vals:Object = getArcValues(nRadius, toRadian);
            for (var i:int = 0; i <= vals.divideNum; i++) {
                // Anchor
                points.push(new Point(nRadius*Math.cos(vals.dividedRadian*i),
                                      nRadius*Math.sin(vals.dividedRadian*i)));
                // Control
                points.push(new Point(vals.distance*Math.cos(vals.dividedRadian*(i+0.5)),
                                      vals.distance*Math.sin(vals.dividedRadian*(i+0.5))));
            }
            return points;
        }
        
        /*
         * 円弧を描くのに必要な材料を配列として返す
         * @return divideNum: 分割数
         * @return dividedRadian: 分割された角度
         * @return distance: 中心点からコントロールポイントまでの距離
         */
        public static function getArcValues(nRadius:Number, nRadian:Number):Object {
            // 分割数を得る（45°未満：1）
            var divideNum:int = 1;
            while (Math.abs(nRadian)/divideNum > Math.PI/4) divideNum++;
            // 分割された角度
            var dividedRadian:Number = nRadian/divideNum;
            // コントロールポイントまでの距離を得る
            var distance:Number = getControlRadius(nRadius,Math.abs(dividedRadian));
            return {divideNum:divideNum, dividedRadian:dividedRadian, distance:distance};
        }
        
        // 角度からコントロールポイントの半径を取得
        public static function getControlRadius(nRadius:Number, nRadian:Number):Number {
            var rHalf:Number = nRadian/2;
            var nHeight:Number = nRadius * Math.atan(rHalf);
            var radius:Number = Math.sqrt(Math.pow(nHeight,2)+Math.pow(nRadius,2));
            return radius;
        }

        // 数値を+-limitの範囲に収束
        public function getRangeValue(num:Number, limit:Number):Number {
            while(num >  limit) num -= limit*2;
            while(num < -limit) num += limit*2;
            return num;
        }
        
        // angleをradianに変換
        private function angle2radian(angle:Number=0):Number {
            var radian:Number= angle * (Math.PI / 180);
            return radian;
        }
    }
//}