/**
 * Copyright heru.z0r ( http://wonderfl.net/user/heru.z0r )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w2xg
 */

// forked from bradsedito's PowerUP
package
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    
    public class Main extends Sprite
    {
        private var bullets:Array;
        private var targets:Array;
        
        private var num_bullets:Number = 7;
        private var radius:Number = 10;
        private var min_radius:Number = 0;
        private var tail:Number = 5;
        private var max_speed:Number = 10;
        private var min_speed:Number = 5;
        
        private var chaos:Number = 0;
        private var min_fix:Number = max_speed + min_speed + radius + 1;
 
        public function Main()
        {
            bullets = new Array();
            targets = new Array();
            
            while(num_bullets--)
            {
                var bullet:Array = new Array();
                var tmp_radius:Number = radius;
                var tmp_tail:Number = tail;
                var tmp_reduce:Number = (radius-min_radius)/tail;
                while(tmp_tail--)
                {
                    var fragments:Bullet = new Bullet(tmp_radius,tmp_tail/tail);
                    addChild(fragments);
                    bullet.push(fragments);
                    fragments.filters = [new BlurFilter(3,3,1)];
                    tmp_radius -= tmp_reduce;
                }
                bullets.push(bullet);
                
                var target:Array = new Array();
                target['x'] = stage.stageWidth/2;
                target['y'] = stage.stageHeight/2;
                target['dx'] = 0;
                target['dy'] = 0;
                target['center'] = true;
                target['speed'] = Math.random()*max_speed+min_speed;
                targets.push(target);
            } 
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
        }
 
        private function onEnterFrame(event:Event):void
        {
            var bullet:Array;
            var target:Array;
            var angle:Number;
            var dx:Number;
            var dy:Number;
            var rx:Number;
            var ry:Number;
            var n:Number; // I like to use i,n,r as my number vars
            
            for (var i:int = 0; i < bullets.length; i++)
            {
                bullet = bullets[i];
                target = targets[i];
                
                rx = target['x'] + (Math.random()*(chaos*2)-chaos);
                ry = target['y'] + (Math.random()*(chaos*2)-chaos);
                    
                angle = Math.atan2(bullet[0].y - ry, bullet[0].x - rx);
                target['dx'] -= target['speed'] * Math.cos( angle );
                target['dy'] -= target['speed'] * Math.sin( angle );
     
                for (n = bullet.length - 1; n >= 1; n--)
                {
                    bullet[n].x = bullet[n - 1].x;
                    bullet[n].y = bullet[n - 1].y;
                }
                
                bullet[0].x = target['dx'];
                bullet[0].y = target['dy'];
                
                
                target['dx'] *= 0.99;
                target['dy'] *= 0.99;
                
                if((bullet[0]['x'] < target.x + min_fix && bullet[0].x > target['x'] - min_fix) &&
                   (bullet[0]['y'] < target.y + min_fix && bullet[0].y > target['y'] - min_fix))
                {
                   if(target['center'] == true)
                    {     
                        target['x'] = stage.stageWidth/2;
                        target['y'] = stage.stageHeight/2;
                        target['center'] = false;
                    } else {
                        target['x'] = Math.random()*stage.stageWidth;
                        target['y'] = Math.random()*stage.stageHeight;
                        target['center'] = true;
                    }
                    target['speed'] = Math.random()*max_speed+min_speed;
                }      
            }
        }
    }
}
 
import flash.display.Sprite;
 
class Bullet extends Sprite
{
    public function Bullet(size:int,op:Number)
    {
        graphics.beginFill(0x0,op);
        graphics.drawCircle(0, 0, size);
        graphics.endFill();
    }
}
