/**
 * Copyright rtsan ( http://wonderfl.net/user/rtsan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w2rk
 */

package {
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
 	import flash.events.MouseEvent;
	import flash.utils.*;
	[SWF(width = "465", height= "465")]
	public class Squares extends Sprite {
		var Rects:Array = new Array();
		var TurnD:Array = new Array();
		var i:int,j:int;
		public function DrawMatrix():void {
			var SqColor:int = 0x000000;
 			for ( var y:int = 0 ; y<15 ; y++ ) {
				Rects[y] = new Array();
				TurnD[y] = new Array();
 				for ( var x:int = 0 ; x<15 ; x++ ) {
					Rects[y][x] = new Sprite();
					Rects[y][x].x = x * 31+16;
					Rects[y][x].y = y * 31+16;
					//Rects[y][x].graphics.beginFill(SqColor);
					Rects[y][x].graphics.lineStyle(1, SqColor, 0.8, true);
					Rects[y][x].graphics.drawRect(-16, -16, 30, 30);
					addChild(Rects[y][x]);
					SqColor = Math.random() * 0xffffff;
					TurnD[y][x] = 5;
				} 
			} 
		} 
		public function Rotate(e:Event):void {
			for ( i=0 ; i<15 ; i++ ) {
 				for ( j=0 ; j<15 ; j++ ) {
 					Rects[i][j].rotation += TurnD[i][j];
				} 
			}
		}
		public function onKeyDown(e:KeyboardEvent):void {
 			switch (e.keyCode) {
 				case 13:
					StopAll();
					break;
				case 32:
					ToggleAll();
					break;
			} 
		} 
		public function ToggleAll():void {
 			for ( i=0 ; i<15 ; i++ ) {
 				for ( j=0 ; j<15 ; j++) {
 					TurnD[i][j] *= -1;
				} 
			} 
		} 
		public function StopAll():void {
 			for ( i=0 ; i<15 ; i++ ) {
 				for ( j=0 ; j<15 ; j++) {
					if (TurnD[i][j] == 0)
						TurnD[i][j] = 5;
					else
 						TurnD[i][j] *= 0;
				} 
			} 
		} 
		public function ToggleOne(e:MouseEvent):void {
 			var TurnX:int,TurnY:int;
			TurnX = e.stageX / 31;
			TurnY = e.stageY / 31;
			TurnD[TurnY][TurnX] *= -1;
		} 
		public function Squares():void {
 			DrawMatrix();
			addEventListener(Event.ENTER_FRAME, Rotate);
			stage.addEventListener(KeyboardEvent.KEY_DOWN,onKeyDown);
			stage.addEventListener(MouseEvent.CLICK,ToggleOne);
		} 
	}
}
