/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w2lP
 */

// forked from Leewelo's Analog clock (transparent frame for dark backgrounds)
// forked from Leewelo's clock trial
package {
    import flash.text.*;
    import flash.geom.Rectangle
    import flash.display.Shape;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;
    import flash.filters.DropShadowFilter;
    [SWF(frameRate="1")]
    public class Aclock extends Sprite {
        private var square:Number = 500 //canvas size
        private var r:Number = square/2*0.8;
        private var cx:int = int(square/2);
        private var cy:Number = int(square/2);
        private var txth:Number = 32;
        private var fontsize:Number = 28;
        private var canvas:MovieClip = new MovieClip();
        private var fg:MovieClip = new MovieClip();
        private var dayNames:Array = new Array("AKIJII", "AKIJII");
        private var TB1:TextField = new TextField();
        private var TB2:TextField = new TextField();
        private var TB3:TextField = new TextField();
        private var rr:MovieClip = new MovieClip();          
                                 
        public function Aclock() {
            //graphics.lineStyle(2, 0x888888);
            //graphics.beginFill(0xFFFFFF,,0);
            //graphics.drawCircle(square/2,square/2,square/2*0.8);
            //graphics.endFill();
            //graphics.beginFill(0x000000,1);
            //graphics.lineStyle(1, 0x000000);
            //graphics.drawRect(0, 0,square,square);
            //graphics.endFill();
            
            rr.filters = [new DropShadowFilter()];   // droping shadow to enable visibility on white/transparent bg
            rr.graphics.beginFill(0xFFFFFF,0);
            rr.graphics.lineStyle(2, 0xFFFFFF);
            rr.graphics.drawRoundRect(square*1/5-2, (square-txth)/2+2,fontsize*3+4, txth, txth*4/5, txth-1);
            rr.graphics.endFill();
            rr.graphics.beginFill(0xFFFFFF,0);
            rr.graphics.lineStyle(2, 0xFFFFFF);
            rr.graphics.drawRoundRect(square*0.65-2, (square-txth)/2+2,fontsize*2+4, txth, txth*4/5, txth-1);
            rr.graphics.endFill();
            addChild(rr);
            
            var TxtFormat:TextFormat = new TextFormat('Arial');
            TxtFormat.size = fontsize;
            TxtFormat.bold=true;
            TxtFormat.align = TextFormatAlign.CENTER;
            //
            
            TB1.filters = [new DropShadowFilter()];// droping shadow to enable visibility on white/transparent bg
            TB2.filters = [new DropShadowFilter()];// droping shadow to enable visibility on white/transparent bg
            TB3.filters = [new DropShadowFilter()];// droping shadow to enable visibility on white/transparent bg
            
            TB1.defaultTextFormat = TxtFormat;
            TB1.width = fontsize*3;
            TB1.height = txth;
            TB1.x = square*1/5;
            TB1.y = (square-txth)/2;
            TB1.border = false;
            //TB1.borderColor = 0x000000;
            TB1.background = false;
            TB1.textColor = 0xFFFFFF
            TB1.type = TextFieldType.DYNAMIC;
            TB1.text = "00/00";
            //
            TB2.defaultTextFormat = TxtFormat;
            TB2.width = fontsize*2;
            TB2.height = txth;
            TB2.x = square*0.65;
            TB2.y = (square-txth)/2;
            TB2.border = false;
            //TB2.borderColor = 0x000000;
            TB2.background = false;
            TB2.textColor = 0xFFFFFF
            TB2.type = TextFieldType.DYNAMIC;
            TB2.text = "24";
            //
            TB3.defaultTextFormat = TxtFormat;
            TB3.width = square;
            TB3.height = txth;
            TB3.x = 0;
            TB3.y = square*3/4-txth;
            TB3.border = false;
            //TB3.borderColor = 0x000000;
            TB3.background = false;
            TB3.textColor = 0xFFFFFF
            TB3.type = TextFieldType.DYNAMIC;
            TB3.text = "AKIJII";
            fg.graphics.clear();
            addChild(TB1);
            addChild(TB2);
            //TB3.filters = [new DropShadowFilter()];
            addChild(TB3);

            for (var i:int = 0; i < 12; ++i) {
                var t:Number = i / 6 * Math.PI;
                graphics.beginFill(0x000000);
                if (i % 3 === 0) {
                    graphics.lineStyle(3,0xFFFFFF),
                    graphics.drawCircle(cx + r*Math.cos(t), cy + r*Math.sin(t), 8);
                }
                else {
                    graphics.lineStyle(2,0xFFFFFF),
                    graphics.drawCircle(cx + r*Math.cos(t), cy + r*Math.sin(t), 5);
                }
                graphics.endFill();
            }
            fg.filters = [new DropShadowFilter()];
            addChild(fg);
            addEventListener(Event.ENTER_FRAME, repaint);
        }

        private function repaint(e:Event):void {
            var d:Date = new Date();
            var sd:String =  (d.date<=9?"0":"") + d.date + "/" + (d.month<9?"0":"") + (d.month+1);
            var AMPM:String = d.hours<12?"AM":"PM";
            var h:Number = (d.hours + d.minutes/60-3) / 6 * Math.PI;
            var m:Number = (d.minutes + d.seconds/60-15) / 30 * Math.PI;
            var s:Number = (d.seconds-15) / 30 * Math.PI;

            if (TB1.text!=sd) {TB1.text = sd;}
            if (TB2.text!=AMPM) {TB2.text = AMPM;}
            if (TB3.text!=dayNames[d.getDay()]) {TB3.text = dayNames[d.getDay()];}
            fg.graphics.clear();
            for each (var o:Object in [{w:8, c:0xFFFFFF, x:(r*0.6)*Math.cos(h), y:(r*0.6)*Math.sin(h)},
                                       {w:6, c:0xFFFFFF, x:(r*0.8)*Math.cos(m), y:(r*0.8)*Math.sin(m)},
                                       {w:2, c:0xFF0000, x:(r*0.9)*Math.cos(s), y:(r*0.9)*Math.sin(s)},
                                       {w:4, c:0xFF0000, x:-(r*0.1)*Math.cos(s), y:-(r*0.1)*Math.sin(s)}]) {
                fg.graphics.lineStyle(o.w, o.c);
                fg.graphics.moveTo(cx, cy);
                fg.graphics.lineTo(cx + o.x, cy + o.y);
                fg.graphics.beginFill(o.c,1);
                fg.graphics.drawCircle(square/2, square/2, int(3 + o.w / 4));
                fg.graphics.endFill();
            }
        }
    }
}