/**
 * Copyright iong ( http://wonderfl.net/user/iong )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w25m
 */

// forked from iong's flash on 2009-8-10
package
{
    // onClick Action
    // odd count=angel, even count=devil

    import flash.display.Sprite;
    import flash.display.BlendMode;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Point;
    import flash.geom.ColorTransform;
    import flash.utils.setInterval;
    import flash.utils.clearInterval;
    import flash.filters.BlurFilter;

    import flash.display.Stage;
    import flash.display.StageScaleMode;

    import flash.events.Event;
    import flash.events.MouseEvent;

    [swf(width="465", height="465", backgroundColor="#ffffff")]

    public class As005 extends Sprite
    {
        private var cv:BitmapData;
        private var cPMain:Sprite;
        private var cPBg:Sprite;

        // 背景設定
        private var aryBg:Array = new Array();
        private var iBgW:uint   = 31;
        private var iBgH:uint   = 31;
        private var SICl:uint   = 0;

        private var iEff:uint   = 0;
        private var iEffMax:uint= 40;
        private var iEffCnt:uint= 2;
        private var swBM:String = BlendMode.DARKEN;
        private var flgSW:Boolean = false;

        public function As005():void
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.frameRate = 30;

            init();
            act();
        }

        private function init():void
        {
            cv    = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0xffffff);
            cPBg  = new Sprite();
            cPBg.cacheAsBitmap= true;
            initBg();

            addChild(cPBg);
            addChild(new Bitmap(cv));
        }

        private function act():void
        {
            SICl= setInterval(changeBg, 10);
            stage.addEventListener(MouseEvent.CLICK, onClick);
            stage.addEventListener(Event.ENTER_FRAME, drawStage);
        }

        private function onClick(e:Event):void
        {
            flgSW = !flgSW;
            var tmpP:Sprite = new pMain(flgSW);
            tmpP.x          = mouseX;
            tmpP.y          = mouseY;
            tmpP.scaleX     = 0;
            tmpP.scaleY     = 0;
            addChild(tmpP);
            tmpP.addEventListener(Event.ENTER_FRAME, actMain);
            //cPBg.addEventListener(Event.ENTER_FRAME, actBg);
        }

        private function drawStage(e:Event):void
        {
            cv.draw(cPBg, null, null, swBM);
            cv.applyFilter(cv, cv.rect, new Point(), new BlurFilter(iEff, iEff));
            if(iEff>0) iEff -= iEffCnt;
        }

        // ==================================================

        // メイン
        private function actMain(e:Event):void
        {
            e.target.scaleX += (e.target.scaleX==0) ? (50+Math.round(Math.random()*200))/100: 1.5;
            e.target.scaleY  = e.target.scaleX;
            e.target.removeEventListener(Event.ENTER_FRAME, actMain);
            e.target.addEventListener(Event.ENTER_FRAME, actMainFO);
        }
        private function actMainFO(e:Event):void
        {
            e.target.scaleX += (0-e.target.scaleX)*.2;
            e.target.scaleY += (0-e.target.scaleY)*.2;
            if(Math.abs(0-e.target.scaleX)<=0.1){
                e.target.removeEventListener(Event.ENTER_FRAME, actMainFO);
                e.target.scaleX=0;
                e.target.scaleY=0;
                e.target.parent.resetBg(e.target);
            }
        }

        private function removePiece(mc:Sprite):void
        {
            removeChild(mc);
            mc= null;
        }

        // ==================================================

        // 背景配置
        private function initBg():void
        {
            var tmpLI:uint = Math.ceil(stage.stageWidth/iBgW);
            var tmpLC:uint = Math.ceil(stage.stageHeight/iBgH);
            for(var i:uint=0; i<=tmpLI; i++){
                aryBg[i]= new Array();
                for(var cc:uint=0; cc<=tmpLC; cc++){
                    var tmc:Sprite = new pBg(iBgW, iBgH, retC());
                    tmc.name     = "bg"+i+"_"+cc;
                    tmc.x        = i *iBgW;
                    tmc.y        = cc*iBgH;
                    aryBg[i][cc] = new Object();
                    aryBg[i][cc] = {
                         mc:tmc
                        ,cmax: Math.abs(tmpLI/2-i) + Math.abs(tmpLC/2-cc)
                        ,cnt: 0
                        ,flgfo: false
                        ,cl: new Array(0,0,0)
                        ,ecnt: 0
                    };
                    cPBg.addChild(tmc);
                }
            }
        }

        // 背景動作
        private function actBg(e:Event):void
        {
            for(var i:uint=0; i<aryBg.length; i++){
                for(var cc:uint=0; cc<aryBg[i].length; cc++){
                    var tmc:Sprite     = aryBg[i][cc].mc;
                    aryBg[i][cc].flgfo = false;
                    tmc.addEventListener(Event.ENTER_FRAME, actBgPiece);
                }
            }
            cPBg.removeEventListener(Event.ENTER_FRAME, actBg);
        }
        private function actBgPiece(e:Event):void
        {
            var tp:Array = e.target.name.split("_");
            var i:uint   = uint(tp[0].substr(2));
            var cc:uint  = uint(tp[1]);
            if(aryBg[i][cc].cnt<aryBg[i][cc].cmax){
                aryBg[i][cc].cnt++;

            }else{
                var tR:Number = e.target.transform.colorTransform.redOffset + aryBg[i][cc].ecnt;
                var tG:Number = e.target.transform.colorTransform.greenOffset + aryBg[i][cc].ecnt;
                var tB:Number = e.target.transform.colorTransform.blueOffset + aryBg[i][cc].ecnt;
                e.target.transform.colorTransform = new ColorTransform(1, 1, 1, 1, tR, tG, tB, 0);
                aryBg[i][cc].ecnt = (aryBg[i][cc].flgfo)
                     ? Math.min(255, aryBg[i][cc].ecnt+25)
                     : Math.max(0, aryBg[i][cc].ecnt-25);
                if(aryBg[i][cc].ecnt==0) aryBg[i][cc].flgfo= true;
                if(aryBg[i][cc].ecnt==255){
                    aryBg[i][cc].cnt   = 0;
                    e.target.removeEventListener(Event.ENTER_FRAME, actBgPiece);
                }
            }
        }
        // 色変更
        private function changeBg():void
        {
            for(var i:uint=0; i<=5; i++){
                var tmpI:uint = Math.round(Math.random()*(aryBg.length-1));
                var tmpC:uint = Math.round(Math.random()*(aryBg[0].length-1));
    
                var target:Sprite = aryBg[tmpI][tmpC].mc;
                aryBg[tmpI][tmpC].cl= retCOffset();
    
                var seekerBg:Sprite = new Sprite();
                seekerBg.name       = "sk"+tmpI+"_"+tmpC;
                seekerBg.addEventListener(Event.ENTER_FRAME, changeBgColor);
            }
        }

        private function changeBgColor(e:Event):void
        {
            var tmpName:Array = e.target.name.substr(2).split("_");
            var tmpI:uint     = int(tmpName[0]);
            var tmpC:uint     = int(tmpName[1]);
            var tmc:Sprite    = aryBg[tmpI][tmpC].mc;

            var rOffset:Number = Math.round((tmc.transform.colorTransform.redOffset  +aryBg[tmpI][tmpC].cl[0])/2);
            var gOffset:Number = Math.round((tmc.transform.colorTransform.greenOffset+aryBg[tmpI][tmpC].cl[1])/2);
            var bOffset:Number = Math.round((tmc.transform.colorTransform.blueOffset +aryBg[tmpI][tmpC].cl[2])/2);
            tmc.transform.colorTransform = new ColorTransform(1, 1, 1, 1, rOffset, gOffset, bOffset, 0);

            if(Math.abs(rOffset-aryBg[tmpI][tmpC].cl[0])<=1 && Math.abs(gOffset-aryBg[tmpI][tmpC].cl[1])<=1 && Math.abs(bOffset-aryBg[tmpI][tmpC].cl[2])<=1){
                e.target.removeEventListener(Event.ENTER_FRAME, changeBgColor);
            }
        }

        // 背景の動作を再設定
        private function resetBg(mc:Sprite):void
        {
             iEff= iEffMax;
             clearInterval(SICl);
             if(swBM==BlendMode.DARKEN){
                 swBM = BlendMode.LIGHTEN;
                 SICl= setInterval(changeBg, 200);
             }else{
                 swBM = BlendMode.DARKEN;
                 SICl= setInterval(changeBg, 20);
             }

             var tmpI:uint = 0;
             var tmpK:uint = 0;
             // 中心取得
             for(var i:int=0; i<aryBg.length; i++){
                 for(var k:int=0; k<aryBg[i].length; k++){
                     if(mc.hitTestObject(aryBg[i][k].mc)){
                         tmpI= i;
                         tmpK= k;
                         break;
                     }
                 }
             }
             for(i=0; i<aryBg.length; i++){
                 for(k=0; k<aryBg[i].length; k++){
                     aryBg[i][k].cmax = Math.abs(tmpI-i) + Math.abs(tmpK-k);
                 }
             }

             removePiece(mc);
             cPBg.addEventListener(Event.ENTER_FRAME, actBg);
        }

        // ==================================================

        private function retC():Number
        {
            var coR:String= (100+Math.round(Math.random()*155)).toString(16);
            var coG:String= (100+Math.round(Math.random()*155)).toString(16);
            var coB:String= (100+Math.round(Math.random()*155)).toString(16);
            return parseInt("0x"+coR+coG+coB, 16)
        }
        private function retCOffset():Array
        {
            var ofR:int = -50+Math.round(Math.random()*100);
            var ofG:int = -50+Math.round(Math.random()*100);
            var ofB:int = -50+Math.round(Math.random()*100);
            var retVal:Array = new Array(ofR, ofG, ofB);
            return retVal;
        }
    }
}

import flash.display.Sprite;

// メイン
class pMain extends Sprite
{
    public function pMain(flg:Boolean):void
    {
        var cl:Number = (flg) ? 0xff0000: 0x000000;
        graphics.beginFill(cl, 1);
        graphics.moveTo(0, -26);
        graphics.curveTo(0,-50, -25,-50);
        graphics.curveTo(-60,-50, -60,-12);
        graphics.curveTo(-60,22, 0,50);
        graphics.lineTo(0,50);
        graphics.curveTo(60,22, 60,-12);
        graphics.curveTo(60,-50, 25,-50);
        graphics.curveTo(0,-50, 0,-26);
        graphics.endFill();
    }
}

// 背景
class pBg extends Sprite
{
    public function pBg(iBgW:uint, iBgH:uint, iC:Number):void
    {
        graphics.beginFill(iC, 1);
        graphics.drawCircle(0, 0, iBgW/2);
        graphics.endFill();
    }
}
