/**
 * Copyright h_kamizono ( http://wonderfl.net/user/h_kamizono )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w22l
 */

// forked from h_kamizono's test
package {
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.utils.Timer;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.events.KeyboardEvent;
    import flash.filters.BlurFilter;
    import flash.filters.BitmapFilterQuality;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import flash.net.URLLoaderDataFormat;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    public class MetaBall extends MovieClip {
        private var dotsSp:Sprite = new Sprite();
        private var bokehBmp:Bitmap;
        private var metaBallBmp:Bitmap;
        private var bokehBmpData:BitmapData;
        private var metaBallBmpData:BitmapData;
        
        private var baseSp:Sprite = new Sprite();
        private var maskSp:Sprite = new Sprite();
        
        private var titleSp:Sprite = new Sprite();
        private var layerView:Sprite = new Sprite();
        private var monitorWidth:Number = 300;
        private var monitorHeight:Number = 400;
        
        private const DOTS_MODE:Number = 0;
        private const BOKEH_MODE:Number = 1;
        private const METABALL_MODE:Number = 2;
        private var curViewMode:Number = METABALL_MODE;
        
        private var metaBlur:BlurFilter = 
            new BlurFilter(50, 50, BitmapFilterQuality.HIGH);
        
        private var obj:Array = new Array();
        private var pt:Array = new Array();
        private var loc:Array = new Array();
        private var titleTf:Array = new Array();
        
        private var preNum:Number = 0;
        private var curNum:Number = 0;
        private var changedTime:uint = new Date().getTime();
        
        private var curArrayNum:Number = 0;
        private var numArray:Array = new Array();
        
        public function MetaBall() {
            // write as3 code here..
            graphics.lineStyle(0, 0, 0);
            graphics.beginFill(0xDDDDCC);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            dotsSp.graphics.lineStyle(0, 0, 0);
            dotsSp.graphics.beginFill(0xFFFFFF);
            dotsSp.graphics.drawRect(0, 0, monitorWidth, monitorHeight);
            dotsSp.graphics.endFill();
            dotsSp.alpha = 0;
            dotsSp.x = stage.stageWidth/2 - monitorWidth/2;
            dotsSp.y = stage.stageHeight/2 - monitorHeight/2 - 30;
            
            bokehBmpData = new BitmapData(
                monitorWidth, monitorHeight, false, 0xFFFFFF);
            bokehBmp = new Bitmap(bokehBmpData);
            bokehBmp.alpha = 0;
            bokehBmp.x = stage.stageWidth/2 - monitorWidth/2;
            bokehBmp.y = stage.stageHeight/2 - monitorHeight/2 - 30;
            
            metaBallBmpData = new BitmapData(
                monitorWidth, monitorHeight, false, 0xFFFFFF);
            metaBallBmp = new Bitmap(metaBallBmpData);
            metaBallBmp.filters = 
                [new BlurFilter(10, 10, BitmapFilterQuality.HIGH)];
            metaBallBmp.x = stage.stageWidth/2 - monitorWidth/2;
            metaBallBmp.y = stage.stageHeight/2 - monitorHeight/2 - 30;
            
            layerView.x = stage.stageWidth/2;
            layerView.y = stage.stageHeight/2;
            
            var w:Number = 150;
            titleSp.x = stage.stageWidth/2 - w/2;
            titleSp.y = stage.stageHeight/2 + monitorHeight/2 - 10;
            titleSp.graphics.clear();
            titleSp.graphics.lineStyle(1, 0x999933);
            titleSp.graphics.beginFill(0xFFFFFF);
            titleSp.graphics.drawRect(0, 0, w, 20);
            titleSp.graphics.endFill();
            
            maskSp.graphics.clear();
            maskSp.graphics.lineStyle(0, 0, 0);
            maskSp.graphics.beginFill(0xFF0000);
            maskSp.graphics.drawRect(stage.stageWidth/2 - monitorWidth/2,
                stage.stageHeight/2 - monitorHeight/2 - 30,
                monitorWidth, monitorHeight);
            maskSp.graphics.endFill();
            baseSp.mask = maskSp;
            
            baseSp.addChild(metaBallBmp);
            baseSp.addChild(bokehBmp);
            baseSp.addChild(dotsSp);
            addChild(maskSp);
            addChild(baseSp);
            addChild(layerView);
            addChild(titleSp);
            
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKDown);
            
            var xmlLoader:URLLoader = new URLLoader();
            xmlLoader.dataFormat = URLLoaderDataFormat.TEXT;
            xmlLoader.addEventListener(Event.COMPLETE, onXMLLoaded);
            xmlLoader.load(new URLRequest("keijo.xml"));
        }
        
        private function onXMLLoaded(event:Event) :void {
            try {
                var theXML:XML = new XML(event.target.data);
                for (var i:Number = 0; i < Number(theXML.@pointNum); ++i) {
                    pt.push(new PhysicalPoint(
                        monitorWidth/2, monitorHeight/2));
                    obj[obj.length - 1].graphics.lineStyle(0, 0, 0);
                    obj[obj.length - 1].graphics.beginFill(0x111111);
                    obj[obj.length - 1].graphics.drawCircle(0, 0, 30);
                    obj[obj.length - 1].graphics.endFill();
                    dotsSp.addChild(obj[obj.length-1]);
                }
                var tfm:TextFormat = new TextFormat(
                    "Hiragino Mincho ProN W6", 14);
                tfm.align = TextFormatAlign.CENTER;
                
                for each (var shape:XML in theXML.shape) {
                    loc.push(new Array());
                    for each (var kpt:XML in shape.pt) {
                        loc[loc.length - 1].push(new Point(
                            Number(kpt.@x), Number(kpt.@y)));
                    }
                    titleTf.push(new TextField());
                    titleTf[titleTf.length - 1].text = "[" + shape.@name + "]";
                    titleTf[titleTf.length - 1].embedFonts = true;
                    titleTf[titleTf.length - 1].setTextFormat(tfm);
                    titleTf[titleTf.length - 1].x = titleSp.x;
                    titleTf[titleTf.length - 1].y = titleSp.y;
                    titleTf[titleTf.length - 1].width = titleSp.width;
                    titleTf[titleTf.length - 1].height = titleSp.height;
                    titleTf[titleTf.length - 1].alpha = 0;
                    addChild(titleTf[titleTf.length - 1]);
                    
                }
                shuffle();
                
                changePic(null);
                
                var changePicTimer:Timer = new Timer(33);
                changePicTimer.addEventListener(
                    TimerEvent.TIMER, changePic);
                changePicTimer.start();
                
                var timer:Timer = new Timer(33);
                timer.addEventListener(TimerEvent.TIMER, loop);
                timer.start();
                
            } catch (err:TypeError) {
                trace(err);
            }
        }
        
        private function changePic(event:Event) :void {
            preNum = curNum;
            curNum = numArray[curArrayNum++];
            changedTime = new Date().getTime();
            if (curArrayNum == loc.length) {
                shuffle();
                curArrayNum = 0;
            }
        }
        
        private function shuffle() :void {
            numArray = new Array();
            for (var i:Number = 0; i < loc.length; ++i) {
                numArray.push(i);
            }
            for (var j:Number = 0; j < 30; ++j) {
                var a0:Number = Math.min(
                    int(Math.random()*loc.length), loc.length - 1);
                var a1:Number = Math.min(
                    int(Math.random()*loc.length), loc.length - 1);
                var temp:Number = numArray[a0];
                numArray[a0] = numArray[a1];
                numArray[a1] = temp;
            }
        }
        
        private function loop(event:TimerEvent) :void {
            switch (curViewMode) {
                case DOTS_MODE:
                  dotsSp.filters = null;
                  dotsSp.alpha = Math.min(dotsSp.alpha+0.1, 1);
                  bokehBmp.alpha = Math.max(bokehBmp.alpha-0.1, 0);
                  metaBallBmp.alpha = Math.max(metaBallBmp.alpha-0.1, 0);
                  break;
                case BOKEH_MODE:
                  dotsSp.filters = [metaBlur];
                  dotsSp.alpha = Math.min(dotsSp.alpha+0.1, 1);
                  bokehBmp.alpha = Math.max(bokehBmp.alpha-0.1, 0);
                  metaBallBmp.alpha = Math.min(metaBallBmp.alpha+0.1, 1);
                  break;
                case METABALL_MODE:
                  dotsSp.filters = [metaBlur];
                  dotsSp.alpha = Math.max(dotsSp.alpha-0.1, 0);
                  bokehBmp.alpha = Math.max(bokehBmp.alpha-0.1, 0);
                  metaBallBmp.alpha = Math.min(metaBallBmp.alpha+0.1, 1);
                  break;
            }
            layerDraw();
            
            var intervalTime:Number = 700;
            var now:uint = new Date().getTime() - changedTime;
            
            for (var j:Number = 0; j < pt.length; ++j) {
                if (now < j * intervalTime) {
                    pt[j].setKasokudo((loc[preNum][j].x - pt[j].x)*8,
                                      (loc[preNum][j].y - pt[j].y)*8);
                } else {
                    pt[j].setKasokudo((loc[curNum][j].x - pt[j].x)*8,
                                      (loc[curNum][j].y - pt[j].y)*8);
                }
                obj[j].x = pt[j].x;
                obj[j].y = pt[j].y;
            }
            bokehBmpData.draw(dotsSp);
            
            metaBallBmpData.fillRect(
                new Rectangle(0, 0, bokehBmpData.width,
                              bokehBmpData.height), 0xFFFFFF);
            var sourceRect:Rectangle = new Rectangle(
                0, 0, metaBallBmpData.width, metaBallBmpData.height);
            var destPt:Point = new Point(0, 0);
            var threshold:uint = 0x00999999;
            var color:uint = 0x0000FF00;
            var maskColor:uint = 0x00FFFFFF;
            metaBallBmpData.threshold(bokehBmpData, sourceRect,
                destPt, "<", threshold, color, maskColor, false);
            
            for (var i:Number = 0 ; i < titleTf.length; ++i) {
                if (i == curNum && now > pt.length*intervalTime) {
                    titleTf[i].alpha += (1 - titleTf[i].alpha)/10;
                } else {
                    titleTf[i].alpha += (0 - titleTf[i].alpha)/10;
                }
            }
        }
        
        private function onKDown(event:KeyboardEvent) :void {
            if (event.keyCode == 32) {
                curViewMode = ++curViewMode % 3;
            }
        }
        
        private function layerDraw() :void {
            layerView.graphics.clear();
            
            for (var i:Number = 0; i < 3; ++i) {
                var w:Number = 20;
                var h1:Number = 10;
                var h2:Number = 9;
                var interval:Number = 5;
                layerView.graphics.moveTo(-w, 0 - interval*i);
                if (curViewMode == i) {
                    layerView.graphics.lineStyle(1, 0x000000, 0.7);
                    layerView.graphics.beginFill(0xAA0000, 0.7);
                } else {
                    layerView.graphics.lineStyle(1, 0x000000, 0.3);
                    layerView.graphics.beginFill(0x000000, 0.3);
                }
                layerView.graphics.lineTo(0, -h2 - interval*i);
                layerView.graphics.lineTo(w, 0 - interval*i);
                layerView.graphics.lineTo(0, h1 - interval*i);
                layerView.graphics.lineTo(-w, 0 - interval*i);
                layerView.graphics.endFill();
            }

        }
        
    }
}

import flash.geom.Point;
import flash.events.TimerEvent;
import flash.utils.Timer;

class PhysicalPoint extends Point {
    public var vx:Number, vy:Number;
    public var ax:Number, ay:Number;
    public var b:Number;
    public var sakkiTime:Number;
    public var timer:Timer;
    
    public var preX:Number, preY:Number;
    
    public var kb:Number;
    public var angle:Number;
    public var preAngle:Number;
    public var kakusokudo:Number;
    public var kakukasokudo:Number;
    
    public var limitter:Number = 0.3;
    
    function PhysicalPoint(xx: Number = 0, yy:Number = 0, an:Number = 0) {
        x = xx; y = yy;
        preX = xx; preY = yy;
        b = 1;
        vx = 0; vy = 0;
        ax = 0; ay = 0;
        
        angle = an;
        preAngle = an;
        kb = 1;
        kakusokudo = 0;
        kakukasokudo = 0;
        
        sakkiTime = new Date().getTime();
        timer = new Timer(33);
        timer.addEventListener(TimerEvent.TIMER, loop);
        timer.start();
        
    }
    
    public function loop(event:TimerEvent) :void {
        var nowTime:Number = new Date().getTime();
        var t:Number = (nowTime - sakkiTime)/1000;
        
        if (t > limitter) t = limitter;
        
        preX = x;
        preY = y;
        
        x += vx*t + 0.5*ax*t*t;
        y += vy*t + 0.5*ay*t*t;
        
        vx += ax*t; vy += ay*t;
        vx *= b;    vy *= b;
        ax = 0;     ay = 0;
        preAngle = angle;
        angle += kakusokudo * t + 0.5*kakukasokudo*t*t;
        kakusokudo += kakusokudo*t;
        
        kakusokudo *= kb;
        kakukasokudo = 0;
        sakkiTime = nowTime;
    }
    
    public function setKasokudo(aax:Number = 0, aay:Number = 0) :void {
        ax += aax;
        ay += aay;
    }
    
    public function setKasokudoByPolar(r:Number=0, dire:Number = 0) :void {
        ax += r*Math.cos(dire);
        ay += r*Math.sin(dire);
    }
    
    public function setKakuKasokudo(aan:Number = 0) :void {
        kakukasokudo += aan;
    }
    
    public function setKakuKasokudo2(dire:Number, val:Number) :void {
        var aan:Number = val * Math.sin(dire - angle);
        setKakuKasokudo(aan);
    }

}

