/**
 * Copyright sazzzzz ( http://wonderfl.net/user/sazzzzz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w1tw
 */

package {
    import flash.events.Event;
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.media.Camera;
    import flash.media.Video;
    import flash.text.TextField;
    import com.bit101.components.Label;
    import com.bit101.components.InputText;
    import com.bit101.components.CheckBox;
    import com.bit101.components.PushButton;
    
     [SWF(width = "465", height = "465", frameRate = "30", backgroundColor = "#000000")]
   
    public class Main extends Sprite {
        
        private static const $PROP_NAMES:Array = [
            "width", "height", "activityLevel", "bandwidth", "currentFPS", "fps", "index", "keyFrameInterval", "loopback", "motionLevel", "motionTimeout", "muted", "name", "quality"
        ];
        
        public var infoText:TextField;
        public var infoButton:PushButton;
        
        public var widthText:InputText;
        public var heightText:InputText;
        public var fpsText:InputText;
        public var keyFrameIntervalLabel:Label;
        public var modeLabel:Label;
        public var qualityLabel:Label;
        public var favorAreaCheck:CheckBox;
        public var bandwidthText:InputText;
        public var qualityText:InputText;
        public var keyFrameIntervalText:InputText;
        public var setKeyFrameIntervalButton:PushButton;
        public var setModeButton:PushButton;
        public var setQualityButton:PushButton;

        
        private var $camera:Camera;
        private var $video:Video;
        
        public function Main() {
            // write as3 code here..
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            $camera = Camera.getCamera();
            $video = new Video($camera.width, $camera.height);
            $video.attachCamera($camera);
            
            
            $initGuis();
            
            addChild($video);
            addChild(infoText);
            
            $initCompos();
           
            $camera.setMode(1600,1200,30);
            
            $updateInfo();
        }
        
        private function atInfo(e:Event):void{
            infoText.text = $formatCameraInfo($camera, $PROP_NAMES);
        }


        private function atSetKeyFrameInterval(e:Event):void{
            $camera.setKeyFrameInterval(parseInt(keyFrameIntervalText.text));
        }
        
        private function atSetMode(e:Event):void{
            $camera.setMode(parseInt(widthText.text), parseInt(heightText.text), parseFloat(fpsText.text), favorAreaCheck.selected);
        }
        
        private function atSetQuality(e:Event):void{
            $camera.setQuality(parseInt(bandwidthText.text), parseInt(qualityText.text));
        }

        
        private function $updateInfo():void{
            infoText.text = $formatCameraInfo($camera, $PROP_NAMES);
            
            keyFrameIntervalText.text = "" + $camera.keyFrameInterval;
            
            widthText.text = "" + $camera.width;
            heightText.text = "" + $camera.height;
            fpsText.text = "" + $camera.fps;
            
            bandwidthText.text = "" + $camera.bandwidth;
            qualityText.text = "" + $camera.quality;
        }


        
        private function $formatCameraInfo(cam:Camera, names:Array):String{
            var res:String = "";
            names.forEach(function(item:String, index:int, arr:Array):void{
                res += $formatProp(cam, item);
            });
            return res;
        }
        
        private function $formatProp(cam:Camera,propName:String):String{
            return propName + ":\t" + cam[propName] + "\r";
        }

        private function $initGuis ():void{
            infoText = new TextField();
            infoText.x = 0;
            infoText.y = 0;
            infoText.width = stage.stageWidth;
            infoText.height = stage.stageHeight;
        }

        private function $initCompos ():void{
            
            infoButton = new PushButton(this, 10, 350, "info", atInfo);
            
            keyFrameIntervalLabel = new Label(this, 10, 380, "setKeyFrameInterval:");
            keyFrameIntervalText = new InputText(this, 110, 380, "InputText");
            keyFrameIntervalText.width = 30;
            keyFrameIntervalText.height = 20;
            setKeyFrameIntervalButton = new PushButton(this, 150, 380, "set", atSetKeyFrameInterval);
            setKeyFrameIntervalButton.width = 30;
            
            
            modeLabel = new Label(this, 10, 410, "setMode:");
            
            widthText = new InputText(this, 60, 410, "InputText");
            widthText.width = 40;
            widthText.height = 20;
            widthText.restrict = "0-9";

            heightText = new InputText(this, 110, 410, "InputText");
            heightText.width = 40;
            heightText.height = 20;

            fpsText = new InputText(this, 160, 410, "InputText");
            fpsText.width = 20;
            fpsText.height = 20;

            favorAreaCheck = new CheckBox(this, 190, 410, "favorArea");
            favorAreaCheck.selected = true;

            setModeButton = new PushButton(this, 250, 410, "set", atSetMode);
            setModeButton.width = 30;


            qualityLabel = new Label(this, 10, 440, "setQuality:");

            bandwidthText = new InputText(this, 60, 440, "InputText");
            bandwidthText.width = 60;
            bandwidthText.height = 20;

            qualityText = new InputText(this, 130, 440, "InputText");
            qualityText.width = 30;
            qualityText.height = 20;

            setQualityButton = new PushButton(this, 170, 440, "set", atSetQuality);
            setQualityButton.width = 30;

        }

        
    }
}