/**
 * Copyright sacrifs ( http://wonderfl.net/user/sacrifs )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w1Bb
 */

// forked from clockmaker's カスタムクラスのプロパティーを再帰的に列挙する方法
//
// prototypeに定義を追加したらfor..inで出力できました。
// ・・・が理由はよくわかっていません。
//
// 
//
/* ======================================
   カスタムクラスのプロパティーを列挙する方法
   Object型だと型指定できないのでカスタムクラスを
   作りたいときはよくあると思います。

   ただ、カスタムクラスはfor inで走査できず不便。
   カスタムクラスにtoObject()というメソッドを
   追加してプロパティーを列挙できるようにしました。

   他にも良い方法がありましたら教えてー
 ====================================== */
package
{
    import com.bit101.components.Label;
    import com.bit101.components.Text;
    import flash.display.Sprite;
    import jp.nium.utils.ObjectUtil;

    [SWF(backgroundColor=0xCCCCCC)]
    public class Main extends Sprite
    {
        public function Main()
        {
            // 県
            var pref_1:Pref = new Pref();
            pref_1.name = "TOKYO";
            pref_1.id = 13;

            var pref_2:Pref = new Pref();
            pref_2.name = "OSAKA";
            pref_2.id = 27;

            // 人
            var person_1:Persion = new Persion();
            person_1.name = "YASU";
            person_1.age = 27;
            person_1.pref = pref_1;

            var person_2:Persion = new Persion();
            person_2.name = "NOBU";
            person_2.age = 29;
            person_2.pref = pref_2;

            // 格納
            var arr:Array = [ person_1, person_2 ];

            // 出力パターン1 (for inで出力)
            // カスタムクラスのプロパティーは列挙されない
            new Label(this, 10, 50, "for..in");
            new Text(this, 10, 70, ObjectUtil.toString(arr));
            
            /*

            // 出力パターン2 (toObjectという自作メソッドを利用)
            // カスタムクラスのプロパティーを列挙できる
            var out:Array = [];
            for (var i:int = 0; i < arr.length; i++)
            {
                //out[ i ] = arr[ i ].toObject();
                out[ i ] = arr[ i ].toString();
            }
            new Label(this, 10, 190, "for..in with toObject()");
            new Text(this, 10, 210, ObjectUtil.toString(out));

            // 復元処理
            var resume:Object = {};
            for (var j:int = 0; j < out.length; j++)
            {
                resume[ j ] = new Persion(out[ j ]);
            }
            trace(resume); // Flex Builderとかのデバッグでチェックすると型指定が復元できてるのがわかるよ
            */

            // タイトル
            var l:Label = new Label(this, 10, 10, "FOR IN PROPERTY OF CUSTOM CLASS");
            l.scaleX = l.scaleY = 2;
        }
    }
}

// 都道府県
class Pref
{
    public function Pref(initObject:Object = null)
    {
        prototype.id = prototype.name = '';
        if (initObject)
        {
            this.id = initObject.id;
            this.name = initObject.name;
        }
    }

    public var id:int; //JISコード
    public var name:String; //都道府県名
}

// 人
class Persion
{
    public function Persion(initObject:Object = null)
    {
        prototype.age = prototype.name = prototype.pref = '';
        if (initObject)
        {
            this.age = initObject.age;
            this.name = initObject.name;
            this.pref = new Pref(initObject.pref);
        }
    }

    public var age:int; // 年齢
    public var name:String; // 人名
    public var pref:Pref; // 所属する都道府県
}

