/**
 * Copyright simultechnology ( http://wonderfl.net/user/simultechnology )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/w0xz
 */

package
{
	import caurina.transitions.Tweener;
	
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.events.TimerEvent;
	import flash.net.URLRequest;
	import flash.text.TextField;
	import flash.text.TextFormat;
	import flash.utils.Timer;
	
	import org.osmf.events.TimeEvent;
	
	public class Slide extends Sprite
	{		
		
		private var _loaderArray:Array = [];
		// 大きな画像が表示されているかどうか判断するフラグ
		private var _firstBigImage:Boolean = true;
		
		public function Slide()
		{
			
			var fileArray :Array = [
				"http://assets.wonderfl.net/images/related_images/1/1a/1a5f/1a5fa317745149cb7a4fb20d8f5593bc9aeb5e2e",
				"http://assets.wonderfl.net/images/related_images/e/e5/e550/e5509302c81d9064979e289ba286696f34e9e1c1",
				"http://assets.wonderfl.net/images/related_images/6/60/60d3/60d3f46dc94b87ba74bf53195dd919eb8116cef8",
				"http://assets.wonderfl.net/images/related_images/2/29/29c8/29c8d0dabd90d8cdeb36ed899e1101010248155d",
				"http://assets.wonderfl.net/images/related_images/e/e4/e480/e4803c60aa7e420a6afb623952942b7bb086fe1d",
				"http://assets.wonderfl.net/images/related_images/8/8b/8b80/8b80f9e765712bb5fab44c090a6d12c7f0315998",
				"http://assets.wonderfl.net/images/related_images/0/06/0624/062427867706c983494c12173b7ee8e4c5a4b092",
				"http://assets.wonderfl.net/images/related_images/d/d3/d30d/d30d9a89bde55caa8f8825f9ab9bba38f282d7f1",
				"http://assets.wonderfl.net/images/related_images/4/4e/4ee1/4ee1e0a96b441c783787d3d87d50fe291e5db067",
				"http://assets.wonderfl.net/images/related_images/2/25/2567/2567f6d388b36502ced8d97b43c894dfd25772a4"
			];
			
			//　画像のwidthは283
			var imageScale:Number = 465 / 5 / 283;
			
			var n:int = fileArray.length;
			var sp:Image;
			for (var i:int = 0; i < n; i++) {
				if (i < 5) {
					// 画像1枚目～5枚目は下に表示
					sp = new Image(fileArray[i], i * 283 * imageScale, 350, imageScale, imageScale, 0.4, i);
				}
				else {
					// 画像6枚目～10枚目は下に表示
					sp = new Image(fileArray[i], (i - 5) * 283 * imageScale, 85, imageScale, imageScale, 0.4, i);
				}
				_loaderArray.push(sp);
				addChild(addAlphaListener(sp, 0.4));
				sp.addEventListener(MouseEvent.CLICK, showBigImage);
				sp.addEventListener(MouseEvent.CLICK, addSlide);
			}
			
			// 文字列フォーマットの指定
			var tm:TextFormat = new TextFormat();
			tm.color = 0x000000;
			tm.size = 14;
			// 文字列の作成
			var tf:TextField = new TextField();
			tf.defaultTextFormat = tm;
			tf.alpha = 0.8;
			tf.width = 400;
			tf.text = "数字をどれかクリックすると、時間が表示されます";
			tf.x = 0;
			tf.y = 430;
			this.stage.addChildAt(tf, 0);
			
		}
		
		private function addSlide(e:MouseEvent):void {
			var dx:int;
			var dy:int;
			var destination:int;
			// クリックされたオブジェクトのIDを取得
			var id:Number = e.target.getId();
			
			var i:int;
			if (id < 5) {
				for (i = 0; i < 5; i++) {
					destination = 0;
					dx = 0;
					dy = 0;
					dx = _loaderArray[i].x;
					dy = _loaderArray[i].y;
					destination = dx + 350
					trace(dx);
					if (destination > 435) {
						Tweener.addTween(_loaderArray[i], { x:465, y:dy, time:2, transition:"easeOutExpo" });
						_loaderArray[i].x = 0;
						Tweener.addTween(_loaderArray[i], { x:destination - 465, y:dy, time:2, transition:"easeOutExpo" });
					}
					else {
						Tweener.addTween(_loaderArray[i], { x:destination, y:dy, time:2, transition:"easeOutExpo" });
					}
				}
			}
			else {
				for (i = 5; i < 10; i++) {
					destination = 0;
					dx = 0;
					dy = 0;
					dx = _loaderArray[i].x;
					dy = _loaderArray[i].y;
					destination = dx + 350
					trace(dx);
					if (destination > 435) {
						Tweener.addTween(_loaderArray[i], { x:465, y:dy, time:2, transition:"easeOutBounce" });
						_loaderArray[i].x = 0;
						Tweener.addTween(_loaderArray[i], { x:destination - 465, y:dy, time:2, transition:"easeOutBounce" });
					}
					else {
						Tweener.addTween(_loaderArray[i], { x:destination, y:dy, time:2, transition:"easeOutBounce" });
					}
				}
			}
		}
		
		private function showBigImage(e:MouseEvent):void
		{
			
			if (!_firstBigImage) {
				// 大きな画像が表示されている時は消す
				this.removeChildAt(numChildren - 1);
				this.removeChildAt(numChildren - 1);
				this.removeChildAt(numChildren - 1);
				this.removeChildAt(numChildren - 1);
				this.removeChildAt(numChildren - 1);
				this.removeChildAt(numChildren - 1);
			}
			
			var _date:Date = new Date();
			// 時を取得
			var hour:Number = _date.getHours();
			// 時は一桁の時は0埋め
			var hourStr:String = hour < 10 ? "0" + hour.toString() : hour.toString();
			// 分を取得
			var minute:Number = _date.getMinutes();
			// 分は一桁の時は0埋め
			var minuteStr:String = minute < 10 ? "0" + minute.toString() : minute.toString();
			
			var second:Number = _date.getSeconds();
			// 秒は一桁の時は0埋め
			var secondStr:String = second < 10 ? "0" + second.toString() : second.toString();
			
			var str1:String;
			var str2:String;
			var hourImage1:Image;
			var hourImage2:Image;
			var minuteImage1:Image;
			var minuteImage2:Image;
			var secondeImage1:Image;
			var secondeImage2:Image;
			var len:int = _loaderArray.length;
			for (var i:int = 0; i < len; i++) {
				//trace(_loaderArray[i].getId());
				str1 = hourStr.substring(0, 1);
				str2 = hourStr.substring(1, 2);
				if (str1 == _loaderArray[i].getId()) {
					hourImage1 = new Image(_loaderArray[i].getUrl(), -45, 200, 0.6, 0.6, 1.0, i);
					hourImage1.alpha = 0;
				}
				if (str2 == _loaderArray[i].getId()) {
					hourImage2 = new Image(_loaderArray[i].getUrl(), 22, 200, 0.6, 0.6, 1.0, i);
					hourImage2.alpha = 0;
				}
				
				str1 = minuteStr.substring(0, 1);
				str2 = minuteStr.substring(1, 2);
				if (str1 == _loaderArray[i].getId()) {
					minuteImage1 = new Image(_loaderArray[i].getUrl(), 119, 200, 0.6, 0.6, 1.0, i);
					minuteImage1.alpha = 0;
				}
				if (str2 == _loaderArray[i].getId()) {
					minuteImage2 = new Image(_loaderArray[i].getUrl(), 176, 200, 0.6, 0.6, 1.0, i);
					minuteImage2.alpha = 0;
				}
				
				trace(secondStr);
				str1 = secondStr.substring(0, 1);
				str2 = secondStr.substring(1, 2);
				if (str1 == _loaderArray[i].getId()) {
					secondeImage1 = new Image(_loaderArray[i].getUrl(), 273, 200, 0.6, 0.6, 1.0, i);
					secondeImage1.alpha = 0;
				}
				if (str2 == _loaderArray[i].getId()) {
					secondeImage2 = new Image(_loaderArray[i].getUrl(), 340, 200, 0.6, 0.6, 1.0, i);
					secondeImage2.alpha = 0;
				}
			}
			
			this.addChild(hourImage1);
			this.addChild(hourImage2);
			this.addChild(minuteImage1);
			this.addChild(minuteImage2);
			this.addChild(secondeImage1);
			this.addChild(secondeImage2);
			_firstBigImage = false; 

			// タイマー開始
			var timer:Timer = new Timer(0, 1);
			timer.addEventListener(TimerEvent.TIMER, function(e:TimerEvent):void {
				
				hourImage1.addEventListener(Event.ENTER_FRAME, function(e:Event):void {
					if (hourImage1.alpha <= 0.9) {
						hourImage1.alpha += 0.05;
					}
				});
				hourImage2.addEventListener(Event.ENTER_FRAME, function(e:Event):void {
					if (hourImage2.alpha <= 0.9) {
						hourImage2.alpha += 0.05;
					}
				});
				
				minuteImage1.addEventListener(Event.ENTER_FRAME, function(e:Event):void {
					if (minuteImage1.alpha <= 0.9) {
						minuteImage1.alpha += 0.05;
					}
				});
				minuteImage2.addEventListener(Event.ENTER_FRAME, function(e:Event):void {
					if (minuteImage2.alpha <= 0.9) {
						minuteImage2.alpha += 0.05;
					}
				});
				
				secondeImage1.addEventListener(Event.ENTER_FRAME, function(e:Event):void {
					if (secondeImage1.alpha <= 0.9) {
						secondeImage1.alpha += 0.05;
					}
				});
				secondeImage2.addEventListener(Event.ENTER_FRAME, function(e:Event):void {
					if (secondeImage2.alpha <= 0.9) {
						secondeImage2.alpha += 0.05;
					}
				});
			});
			timer.start();
		}
		
		private function addAlphaListener(sp:Sprite, alpha:Number):Sprite
		{
			sp.addEventListener(MouseEvent.MOUSE_OVER, function(e:MouseEvent):void {
				sp.alpha = 1.0;
			});
			sp.addEventListener(MouseEvent.MOUSE_OUT, function(e:MouseEvent):void {
				sp.alpha = alpha;
			});
			return sp;
		}
	}
}

import flash.display.Bitmap;
import flash.display.Loader;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.net.URLRequest;
import flash.system.LoaderContext;

class Image extends Sprite
{
	private var _url:String;
	
	private var _id:Number;
	
	public function Image(url:String, x:int, y:int, scaleX:Number, scaleY:Number, alpha:Number, id:Number)
	{
		this._url = url;
		this.x = x;
		this.y = y;
		this.scaleX = scaleX;
		this.scaleY = scaleY;
		this.alpha = alpha;
		this._id = id;
		var loader:Loader = new Loader();
		var uRLRequest:URLRequest = new URLRequest(url);
		// ポリシーファイルチェックをtrue
		loader.load(uRLRequest, new LoaderContext(true));
		loader.contentLoaderInfo.addEventListener(Event.COMPLETE, completeListener);
	}
	
	private function completeListener(e:Event):void
	{
		var bm:Bitmap = new Bitmap(e.target.content.bitmapData.clone());
		addChild(bm);
	}
	
	// urlを返すgetter
	public function getUrl():String
	{
		return this._url;
	}
	
	// idを返すgetter
	public function getId():Number
	{
		return this._id;
	}
}