/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vyIQ
 */

package {
    import flash.geom.Point;
    import flash.utils.Proxy;
    import flash.display.Bitmap;
    import flash.geom.Rectangle;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        public var vecMap:Vector.<int>;
        public var mwidth:int = 0;
        public var mheight:int = 0;
        
        public var vecTile:Vector.<Rectangle>;
        public var numTile:int = 0;
        public var bmTile:BitmapData;
        
        public function FlashTest() {
           
           var i:int;
           var num:int;
           
           mwidth = 64;
           mheight = 64;
           
           num = mwidth*mheight;
           
           vecMap = new Vector.<int>(num, false);
           
           
           for (i = 0; i < num; i++)
           {
               vecMap[i] = Math.random() * 4;
           }//nexti
           
           vecTile = new Vector.<Rectangle>(256, false);
           vecTile[0] = new Rectangle(0,0,8,8);
           vecTile[1] = new Rectangle(8,0,8,8);
           vecTile[2] = new Rectangle(16,0,8,8);
           vecTile[3] = new Rectangle(24,0,8,8);
           numTile = 4;
           
           bmTile = new BitmapData(32,32, false ,0);
           bmTile.fillRect(vecTile[0], 0xFF000000);
           bmTile.fillRect(vecTile[1], 0xFFff00);
           bmTile.fillRect(vecTile[2], 0x00ff00);
           bmTile.fillRect(vecTile[3], 0x0000ff);
           
           var tempt:BitmapData;
           tempt = new BitmapData(8,8, false, 0);
           tempt.noise(12);
           bmTile.copyPixels(tempt, tempt.rect, new Point(8,0) );
           
           
           
           canvas = new BitmapData(200,200, false,0);
           pic = new Bitmap(canvas);
           addChild(pic); 
            pic.scaleX = 2;
            pic.scaleY = 2;
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
        }//ctor
        
        public var pic:Bitmap;
        public var canvas:BitmapData;
        
        public var an:int = 0;
        public var dir:int = 1;
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(1, 0);
            
            //graphics.drawRect(0,0,mwidth*8,mheight*8);
            
            an += dir;
            if (an >= 8) { an =8; dir = -1; }
            if (an < 0) { an = 0; dir = 1;}
            
            var wt:Rectangle;
            wt = vecTile[2];
            wt.x = 16+an;
            
            //drawMap(graphics);
            //drawMap2(4,4, 24,24, graphics);
            //drawMap3(10,30, 0 ,0,   10, 5, graphics);
            //drawMap4(mouseX/8,mouseY/8, 100,100,graphics);
            
            canvas.lock();
                canvas.fillRect(canvas.rect,(0) );
                drawMapBmap2(mouseX/8, mouseY/8,canvas);
            canvas.unlock();
            
            
        }//onenter
        
        public var crect:Rectangle = new Rectangle(0,0,8,8);
        
        public function drawMapBmap2(cx:Number, cy:Number, bm:BitmapData):void
        {
            var sx:int;
            var sy:int;
            var ex:int;
            var ey:int;
            var w:Number;
            var h:Number;
            
            w = bm.width;
            h = bm.height;
            
            sx = Math.floor(cx/8);
            sy = Math.floor(cy/8);
            ex = sx + Math.ceil(w/8)+1;
            ey = sy + Math.ceil(h/8)+1;
            
            drawMapBmap(cx,cy,sx,sy,ex,ey, bm);
            
        }//drawbmap2
        
        public var dp:Point = new Point(0,0);
        public function drawMapBmap(cx:Number, cy:Number,
        sx:int, sy:int, ex:int, ey:int, bm:BitmapData):void
        {
            var i:int;
            var k:int;
            var yt:int;
            var t:int;
            var wt:Rectangle;
            
            if (sy < 0) { sy = 0;}
            if (sy > mheight) { return; }
            if (sx < 0) { sx = 0;}
            if (sx > mwidth) { return;}
            if (ex < 0) { return; }
            if (ex > mwidth) { ex = mwidth;}
            if (ey < 0) { return; }
            if (ey > mheight) { ey = mheight; } 
            
            for ( i = sy; i < ey; i++)
            {
                yt = i * mwidth;
                
                for (k = sx; k < ex; k++)
                {
                    t = vecMap[yt+k];
                    if (t <= 0) { continue; }
                    if ( t >= numTile) { continue;} 
                    
                        /*
                       crect.x = (k*8)-cx;
                       crect.y = (i*8)-cy;
                       bm.fillRect(crect, 0xFF0000);
                        */
                        
                       dp.x = (k*8)-cx;
                       dp.y = (i*8)-cy;
                         
                       wt = vecTile[t];
                       bm.copyPixels(bmTile, wt, dp); 
                       
                       
                    
                }//nextk
            }//nexti
            
            
        }//drawbmap
        
        
        
        public function drawMap4(cx:Number, cy:Number, w:Number, h:Number, g:Graphics):void
        {
            var sx:int;
            var sy:int;
            var ex:int;
            var ey:int;
            
            sx = Math.floor(cx/8);
            sy = Math.floor(cy/8);
            ex = sx + Math.ceil(w/8);
            ey = sy + Math.ceil(h/8);
            
            drawMap3(cx,cy,sx,sy,ex,ey,g);
            
        }//drawmap4
        
        
        public function drawMap3(cx:Number, cy:Number,
        sx:int, sy:int, ex:int, ey:int, g:Graphics):void
        {
            var i:int;
            var k:int;
            var yt:int;
            var t:int;
            
            if (sy < 0) { sy = 0;}
            if (sy > mheight) { return; }
            if (sx < 0) { sx = 0;}
            if (sx > mwidth) { return;}
            if (ex < 0) { return; }
            if (ex > mwidth) { ex = mwidth;}
            if (ey < 0) { return; }
            if (ey > mheight) { ey = mheight; } 
            
            for ( i = sy; i < ey; i++)
            {
                yt = i * mwidth;
                
                for (k = sx; k < ex; k++)
                {
                    t = vecMap[yt+k];
                    if (t > 0)
                    {
                       g.beginFill(0,1);
                       g.drawRect((k*8)-cx,(i*8)-cy,8,8);
                       g.endFill();     
                    }
                }//nextk
            }//nexti
            
        }//drawmap3
        
        
        public function drawMap2(sx:int, sy:int, ex:int, ey:int, g:Graphics):void
        {
            var i:int;
            var k:int;
            var yt:int;
            var t:int;
            
            if (sy < 0) { sy = 0;}
            if (sy > mheight) { return; }
            if (sx < 0) { sx = 0;}
            if (sx > mwidth) { return;}
            if (ex < 0) { return; }
            if (ex > mwidth) { ex = mwidth;}
            if (ey < 0) { return; }
            if (ey > mheight) { ey = mheight; } 
            
            for ( i = sy; i < ey; i++)
            {
                yt = i * mwidth;
                
                for (k = sx; k < ex; k++)
                {
                    t = vecMap[yt+k];
                    if (t > 0)
                    {
                       g.beginFill(0,1);
                       g.drawRect(k*8,i*8,8,8);
                       g.endFill();     
                    }
                }
            }//nexti
            
        }//drawmap2
        
        public function drawMap(g:Graphics):void
        {
            var i:int;
            var k:int;
            var yt:int;
            var t:int;
            
            for ( i = 0; i < mheight; i++)
            {
                yt = i * mwidth;
                
                for (k = 0; k < mwidth; k++)
                {
                    t = vecMap[yt+k];
                    if (t > 0)
                    {
                       g.beginFill(0,1);
                       g.drawRect(k*8,i*8,8,8);
                       g.endFill();     
                    }
                }
            }//nexti
            
        }//drawmap
        
        
        
    }//classend
}