/**
 * Copyright smallflowergame ( http://wonderfl.net/user/smallflowergame )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vyFK
 */

// forked from OKASUKE's Japanese Sakura  
/* @OKASUKE
*  2010/03/25 stardustを試してみた。
*  うーん、使い方がまちがってるかな・・・
*  
*  参考サイト
*  http://clockmaker.jp/blog/2010/01/stardust-01/
*  http://blog.rainyday.jp/flash/pv3d/stardust5.html
*  あとはpaqさんとcjcatさんのコードを参考にしました。
*   
* 　舞え、千本桜　JAPANESE SAKURA HANAMI
*/

package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;    
    import flash.events.TimerEvent;
    import flash.filters.GlowFilter;    
    import flash.filters.BlurFilter;    
    import flash.display.BlendMode;
    import flash.filters.ColorMatrixFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.utils.getTimer;
    import flash.utils.Timer;
    import idv.cjcat.stardust.common.clocks.SteadyClock;
    import idv.cjcat.stardust.common.emitters.Emitter;
    import idv.cjcat.stardust.twoD.renderers.DisplayObjectRenderer;    
    import net.hires.debug.Stats;

    [SWF(width=465, height=465, backgroundColor = 0x000000, frameRate = 30)]
    public class MaeSenponSakura extends Sprite
    {
        private static const ZERO_POINT:Point = new Point(0, 0);
            
        private var bmpd2:BitmapData=new BitmapData(465, 465,  true, 0x000000);
        private var bmp2:Bitmap=new Bitmap(bmpd2);
        
        private var container:Sprite = new Sprite();
        
        private var emitterL:Emitter = new SakuraEmitter(new SteadyClock(1), "L");
        private var emitterR:Emitter = new SakuraEmitter(new SteadyClock(1), "R");
        private var blur:BlurFilter = new BlurFilter(1.5, 1.5, 1);
        private var glow:GlowFilter = new GlowFilter(0xFFF0F5, 0.5, 1, 1);
        private var color:ColorMatrixFilter = new ColorMatrixFilter([
                                1, 0, 0, 0, 4,
                                            0, 0.4, 0, 0, 1,
                                            0, 0, 1, 0, 1,
                                            0, 0, 0, 0.5, 0
                                            ]);
                                            
        public function  MaeSenponSakura():void  
        {
            if (stage)
                init();
            else 
                addEventListener(Event.ADDED_TO_STAGE, init);            
        }
        private function init(e:Event = null) :void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
                        stage.addChild(new Stats());
            
                        var background:Sprite = new Sprite();
            var g:Graphics = background.graphics;                
            g.beginFill(0x000000);
            g.drawRect(0, 0, 465, 465);            
            var renderer:DisplayObjectRenderer = new DisplayObjectRenderer(container);
            renderer.addEmitter(emitterR);
            renderer.addEmitter(emitterL);
            
            addChild(background);            
            addChild(bmp2);            
            
            stage.addEventListener(Event.ENTER_FRAME, loop);        
        }
        
        private function loop(e:Event):void 
        {
            emitterR.step();
            emitterL.step();            
            bmpd2.applyFilter(bmpd2, bmpd2.rect, ZERO_POINT, color);
            bmpd2.applyFilter(bmpd2, bmpd2.rect, ZERO_POINT, blur);
            bmpd2.draw(container);            
        }
        
    
    }    
}

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.events.MouseEvent;
import frocessing.color.ColorHSV;
import idv.cjcat.stardust.common.actions.CompositeAction;
import idv.cjcat.stardust.common.actions.triggers.DeathTrigger;
import idv.cjcat.stardust.common.clocks.Clock;
import idv.cjcat.stardust.common.initializers.CollisionRadius;
import idv.cjcat.stardust.common.initializers.Mask;
import idv.cjcat.stardust.common.initializers.Mass;
import idv.cjcat.stardust.common.initializers.Scale;
import idv.cjcat.stardust.common.math.UniformRandom;
import idv.cjcat.stardust.threeD.initializers.Position3D;
import idv.cjcat.stardust.twoD.actions.DeathZone;
import idv.cjcat.stardust.twoD.actions.Deflect;
import idv.cjcat.stardust.twoD.actions.Gravity;
import idv.cjcat.stardust.twoD.actions.Move;
import idv.cjcat.stardust.twoD.actions.MutualGravity;
import idv.cjcat.stardust.twoD.actions.Oriented;
import idv.cjcat.stardust.twoD.actions.Spawn;
import idv.cjcat.stardust.twoD.actions.SpeedLimit;
import idv.cjcat.stardust.twoD.deflectors.CircleDeflector;
import idv.cjcat.stardust.twoD.emitters.Emitter2D;
import idv.cjcat.stardust.twoD.fields.BitmapField;
import idv.cjcat.stardust.twoD.fields.UniformField;
import idv.cjcat.stardust.twoD.initializers.DisplayObjectClass;
import idv.cjcat.stardust.twoD.initializers.Position;
import idv.cjcat.stardust.twoD.initializers.Velocity;
import idv.cjcat.stardust.twoD.zones.CircleZone;
import idv.cjcat.stardust.twoD.zones.LazySectorZone;
import idv.cjcat.stardust.twoD.zones.Line;
import idv.cjcat.stardust.twoD.zones.RectZone;
import idv.cjcat.stardust.twoD.zones.SinglePoint;
import idv.cjcat.stardust.common.initializers.Life;
import idv.cjcat.stardust.twoD.actions.Damping;
import idv.cjcat.stardust.common.actions.Age;
import idv.cjcat.stardust.common.actions.DeathLife;
import idv.cjcat.stardust.common.actions.AlphaCurve;

class SakuraEmitter extends Emitter2D
{    
    
    public function SakuraEmitter(clock:Clock, LorR:String) {
        super(clock);
        
        var spawn:Spawn = new Spawn(new UniformRandom(20, 20));
        var lazySector:LazySectorZone = new LazySectorZone(5, 5);
        //lazySector.direction.set(10, 1);
        //lazySector.directionVar = 80;
        spawn.addInitializer(new Mask(2));
        spawn.addInitializer(new Life(new UniformRandom(100, 100)));
        spawn.addInitializer(new Velocity(lazySector));
        spawn.addInitializer(new Position(new SinglePoint(0, 0)));    
        
        spawn.addInitializer(new DisplayObjectClass(Sakura));
        spawn.addInitializer(new Scale((new UniformRandom(0.5, 0.5))));
            
        addInitializer(new DisplayObjectClass(Sakura));
        var gravity:Gravity = new Gravity();
        var commonAction:CompositeAction = new CompositeAction();
        var deflect:Deflect = new Deflect();        
        if (LorR == "L") {            
            addInitializer(new Position(new Line(240, 0, 240, 465)));
            gravity.addField(new UniformField(-0.4, 0));
            //commonAction.addAction(new DeathZone(new RectZone(1, 0, 1, 465), false));だと跳ね返らない。    
            commonAction.addAction(new DeathZone(new RectZone(0, 0, 0, 465), false));                
        } else {            
            addInitializer(new Position(new Line(240, 0, 240, 465)));
            gravity.addField(new UniformField(0.4, 0));
            commonAction.addAction(new DeathZone(new RectZone(465, 0, 465, 465), false));
        }        
        addInitializer(new Scale(new UniformRandom(1, 1)));            
        addInitializer(new Mask(1));
        commonAction.mask = 1 | 2;        
        commonAction.addAction(gravity);    
        commonAction.addAction(deflect);
        commonAction.addAction(new Move());    
        commonAction.addAction(new DeathLife());
        commonAction.addAction(new Age());
        commonAction.addAction(new AlphaCurve(25, 40));
        commonAction.addAction(new Damping(0.1));
        //commonAction.addAction(new Oriented());        
        addAction(commonAction);    
        
        var deathTrigger:DeathTrigger = new DeathTrigger();
        deathTrigger.addAction(spawn);        
        var dripActions:CompositeAction = new CompositeAction();
        dripActions.mask = 1;
        dripActions.addAction(deathTrigger);        
        addAction(dripActions);        
    }
}

class Sakura extends Sprite {
    
    static private var col:int = 0;    
    public function Sakura():void {
        var color:ColorHSV = new ColorHSV(col + Math.random() * 20 >> 0, 0.3);
        
        graphics.beginFill(color.value);
        graphics.drawRect(0, 0, 2.5, 4)
    }
}