/**
 * Copyright foka ( http://wonderfl.net/user/foka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vy5B
 */

package {
    import flash.display.Sprite;
	import flash.events.TimerEvent;
	import flash.geom.Point;
	import flash.utils.Timer;

	
	[SWF(backgroundColor="#000000",frameRate=40)]

    public class Line extends Sprite {
		private var lineTimer:Timer = new Timer(600);

		public function Line():void {
			lineTimer.addEventListener(TimerEvent.TIMER, onLineTimer);
			lineTimer.start();
		}
		
		
		private function onLineTimer(e:TimerEvent):void 
		{
			var lineMC:BGLine = new BGLine();
			addChild(lineMC);
			var randomNum:Number = uint(Math.random() * 2);
			if (randomNum == 0) {
				lineMC.line(new Point(0, stage.stageWidth-int(Math.random()*stage.stageWidth*1.5)), new Point(stage.stageWidth, stage.stageWidth-int(Math.random()*stage.stageWidth*1.5)));
			}else {
				lineMC.line(new Point(stage.stageWidth, stage.stageWidth-int(Math.random() * stage.stageWidth*1.5)), new Point(0, stage.stageWidth-int(Math.random() * stage.stageWidth*1.5)));
			}
		}
    }
}




import flash.display.MovieClip;
import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Point;


class BGLine extends Sprite
{
	private var startPoint:Point;
	private var endPoint:Point;
	private var linePer:Number = 0;
	private var count:uint = 0;
	private var ueFlag:Boolean = false;
	private var color:uint;

	public function BGLine():void {
		if (Math.random() > 0.5) {
			ueFlag = true;
		}
		color=Math.random() * 0xFFFFFF;
	}
	

	private function onEnter(e:Event):void 
	{
		count++;
		linePer += 0.02;
		if (linePer > 1) {
			linePer = 1;
		}
		graphics.clear();
		graphics.lineStyle (1,color);
		if (linePer == 1) {
			if(ueFlag){
				startPoint.y--;
				endPoint.y++;
			}else {
				startPoint.y++;
				endPoint.y--;
			}
		}
		graphics.moveTo(startPoint.x, startPoint.y);
		graphics.lineTo((endPoint.x - startPoint.x) * linePer + startPoint.x, (endPoint.y - startPoint.y) * linePer + startPoint.y);
		if (count > 300) {
			alpha*=0.9;
			if(alpha<0){
				removeEventListener(Event.ENTER_FRAME, onEnter);
				selfRemove();
			}
		}
	}


	public function line(_startPoint:Point, _endPoint:Point):void {
		startPoint = _startPoint;
		endPoint = _endPoint;
		addEventListener(Event.ENTER_FRAME, onEnter);
	}
	
	private function selfRemove():void
	{
		Object(parent).removeChild(this);
	}
	
}
