/**
 * Copyright toilet7 ( http://wonderfl.net/user/toilet7 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vxzG
 */

package
{
    import flash.display.Sprite;
    import flash.display.MovieClip;
    import flash.events.Event;
    
    public class FlashTest extends Sprite
    {
        private const N:uint = 100;      // number of particles
        private const F:Number = 0.9;    // friction
        private const MAX_R:Number = 5   // 初期配置する円の最大半径
        private const X:Number = 2.9;    // 最大移動量
        private const W:uint = 465;      // stage width
        private const H:uint = 490;      // stage height
        private var list:Array = [];
       
        public function FlashTest()
        {
            create();
            addEventListener(Event.ENTER_FRAME, enterframeListener);
        }
        
        private function create():void
        {
            for (var i:uint=0; i<N; i++)
            {
                var mc:MovieClip = new MovieClip();
                var r:Number = Math.sqrt(Math.random()) * MAX_R;
                var angle:Number = Math.random() * (2 * Math.PI);
                
                mc.graphics.beginFill(0xFFFFFF * Math.random());
                mc.graphics.drawCircle(0, 0, 2);
                
                mc.x = W / 2 + Math.cos(angle) * r;
                mc.y = H / 2 + Math.sin(angle) * r;
                //mc.scaleX = mc.scaleY = Math.ceil(Math.random() * 0.6) + 0.4;
                //mc.alpha = Math.floor(Math.random() * 0.6) + 0.4;
                mc.vx = 0;
                mc.vy = 0;
                
                addChild(mc);
                list[i] = mc;
            }  
        }
        
        private function enterframeListener(e:Event=null):void
        {                         
             for (var i:uint=0; i<N; i++)
             {
                var mc:MovieClip = list[i];
                mc.vx += Math.random() * X * 2 - X;
                mc.vy += Math.random() * X * 2 - X;
                mc.vx *= F;
                mc.vy *= F;
                
                mc.x += mc.vx;
                mc.y += mc.vy;
                
                if (mc.x < 0)
                    mc._x = W;
                else if (mc.x > W)
                    mc.x = 0;
                    
                if (mc.y < 0)
                    mc.y = H;
                else if (mc.y > H)
                    mc.y = 0;
             }
        }
    }
}