/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vxcl
 */

/*
 * Picasa Web Albums Data API
 * http://code.google.com/intl/ja/apis/picasaweb/docs/2.0/reference.html
 * 参考
 * http://wonderfl.net/code/95d18286b23549ece13d4933dffd64a6cf550386
 * 
*/
package {
	import flash.display.Sprite;
	import flash.events.HTTPStatusEvent;
	import flash.events.IOErrorEvent;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.filters.DropShadowFilter;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Loader;
	import flash.events.Event;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.system.LoaderContext;
	import flash.system.Security;
	import flash.display.LoaderInfo;
	public class Main extends Sprite{
		public function Main() {
			Security.loadPolicyFile("http://photos.googleapis.com/data/crossdomain.xml");
			var myURLLoader:URLLoader = new URLLoader();
			myURLLoader.addEventListener(Event.COMPLETE, onCompleteRSS);
			var URLstr:String = "http://photos.googleapis.com/data/feed/base/all?alt=rss&kind=photo&access=public&filter=1&q=waterdrop&isvideo=false&imglic=commercial&max-results=3&imgmax=288";
			myURLLoader.load(new URLRequest(URLstr));
		}
		
		private function onCompleteRSS(e:Event):void {
			var myXML:XML = new XML(e.currentTarget.data);
			default xml namespace = new Namespace("http://search.yahoo.com/mrss/");
			var tf:TextField = new TextField();
			tf.text = myXML;
			tf.textColor = 0xCCCCCC;
			tf.wordWrap = true;
			tf.width = tf.height = 465;
			addChild(tf);
			
			//表示するHTMLデータ
			var htmldata:String = "Title:" + myXML.channel.item[0].title + "<br>";
			htmldata += "Credit:" + myXML.channel.item[0].group.credit + "<br>";
			htmldata += "<a href='" + myXML.channel.item[0].link + "'>" + myXML.channel.item[0].link + "</a>";
			//テキストフィールドを作ります。
			var fld:TextField=new TextField();
			fld.autoSize = TextFieldAutoSize.LEFT;
			fld.width=300;
			fld.x=50;
			fld.y=50;
			//<br>タグで改行されるようにします。
			fld.multiline = true;
			//HTMLを割り当てます。
			fld.htmlText=htmldata;
			//ドロップシャドウフィルタを作って設定します。
			var dsf:DropShadowFilter = new DropShadowFilter();
			dsf.alpha = 0.6;
			fld.filters = [dsf];
			addChild(fld);
			
			//画像をロードして配置し、ドロップシャドウフィルタを設定します。
			var myLoaderContext:LoaderContext = new LoaderContext(true);
			var myURLRequest:URLRequest = new URLRequest(String(myXML.channel.item[0].group.content.@url));
			var myLoader:Loader = new Loader();
			myLoader.load(myURLRequest,myLoaderContext);
			myLoader.contentLoaderInfo.addEventListener(Event.COMPLETE, onCompleteImg);
		}
		private function onCompleteImg(e:Event):void {
			try {
				var myBitmap:Bitmap = e.target.content;
				myBitmap.x = 50;
				myBitmap.y = 100;
				var dsf:DropShadowFilter = new DropShadowFilter();
				dsf.alpha = 0.6;
				myBitmap.filters = [dsf];
				addChild(myBitmap);
			}catch (error:*) {
				var tf:TextField = new TextField();
				tf.text = error.errorID + "\n" + error.name + "\n" + error.message;
				tf.textColor = 0xFF0000;
				tf.wordWrap = true;
				tf.width = tf.height = 465;
				tf.y = 100;
				addChild(tf);
			}
		}
	}
}
