/**
 * Copyright oreore ( http://wonderfl.net/user/oreore )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vxcW
 */

package  
{
	
	//flash
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	
	//papervision3D
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.special.CompositeMaterial;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.view.Viewport3D;
	
	//プロファイラー
	import com.flashdynamix.utils.SWFProfiler;
	
	
	
	public class Main extends Sprite
	{
		private var camera:Camera3D;
		private var viewPort:Viewport3D;
		private var scene:Scene3D;
		private var render:BasicRenderEngine;
		private var plane:Plane;
		
		public function Main() 
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			SWFProfiler.init(this);
			init();
		}
		
		private function init():void
		{
			/************************************************************************
			* 1.ビューポートの作成
			************************************************************************/
			viewPort = new Viewport3D(stage.stageWidth,stage.stageHeight,true,false);
			addChild(viewPort);
			
			/************************************************************************
			* 2.カメラの作成
			************************************************************************/
			camera = new Camera3D();
			camera.z = -1000;
			camera.y = 500;
			
			/************************************************************************
			* 3.シーンの作成
			************************************************************************/
			scene = new Scene3D();
			
			/************************************************************************
			* 4.レンダリングエンジンの生成
			************************************************************************/
			render = new BasicRenderEngine();
			
			/************************************************************************
			* 5.3Dオブジェクトを作成
			************************************************************************/
			
			//板を作成
			var wfm:WireframeMaterial = new WireframeMaterial();
			wfm.doubleSided = true;//裏も描画する
			plane = new Plane(wfm, 300, 200, 4, 4);
			scene.addChild(plane);
			
			//床を作成
			var floorMate:CompositeMaterial = new CompositeMaterial();
			floorMate.addMaterial(new WireframeMaterial(0x696969,50));
			floorMate.addMaterial(new ColorMaterial(0xdcdcdc,0.5));
			var floor:Plane = new Plane(floorMate, 1000, 1000, 12, 12);
			floor.rotationX = 90;
			scene.addChild(floor);
			
			
			/************************************************************************
			* 6.レンダリング
			************************************************************************/
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
			
		}
		
		private function onEnterFrame(e:Event):void 
		{
			
			plane.y += 1;
			plane.rotationX += 1;
			plane.rotationZ += 1;
			
			render.renderScene(scene,camera,viewPort);
		}
		
	}
	
}