/**
 * Copyright kohie_yamashima ( http://wonderfl.net/user/kohie_yamashima )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vxCx
 */

package {
   import flash.display.*;
   import flash.events.EventDispatcher;
   import flash.events.MouseEvent;
   import flash.events.TimerEvent;
   import flash.geom.*;
   
   [SWF(width=600, height=600, frameRate=30, backgroundColor=0x000000)]
  
   public class FireFlower extends MovieClip {
              
   private var drawmc:MovieClip=new MovieClip(); //花火の粒子を線（点）描するためのMCの作成  
   private var viewmc:MovieClip=new MovieClip(); //全てのBM、MCを表示するMCを作成
   private var bm:BitmapData=new BitmapData(600,600,true,0x00000000);//描画の基盤となるBMの作成
   private var bitmap:Bitmap=new Bitmap(bm); 
   private var bm2:BitmapData=new BitmapData(600,600,true,0x0B000000); //余韻を表現するための、半透明の黒いBMの作成
   private var bmp:Number=0.95;//エネルギーの減少に使用する定数を設定  
   private var count:uint=600;//一つの花火にを形作る粒子の数を設定
   private var particleList:Array=new Array;//粒子データを保管する配列の作成
   private var setX:Number;
   private var setY:Number; 
   private var particle:Object;
   private var angle:Number;
   private var velocity:Number;
   private var vx:Number;
   private var vy:Number;
   
   
   
   public function FireFlower(){  
   
   
    
   stage.addEventListener("click",MouseDownHandler);
   stage.addEventListener("enterFrame", rameHandler);
        }
        
   
   
       //花火用の粒子データを生成
   private function MouseDownHandler(event:MouseEvent):void {
	//花火を真ん中ぐらいに生成するために、X、Yの値を作成
	var setX:Number=140+Math.random()*(stage.stageWidth-280);
	var setY:Number=40+Math.random()*(stage.stageHeight-200);
	
	//粒子データを作成
	for (var i:uint=0; i<count; i++) {
		var particle:Object=new Object;
		particle.x=setX;
		particle.y=setY;
		particle.energy=5*Math.random();
		var angle:Number = Math.random()*360;
		var velocity:Number = 8*Math.random();
		particle.vx=Math.cos(angle)*velocity;
		particle.vy=Math.sin(angle)*velocity;
		particleList.push(particle);
}
}

  //粒子データにあわせて、描画を行い、BMに反映させる
  private function rameHandler():void {
      
      
      
	drawmc.graphics.clear();
	drawmc.graphics.lineStyle(3,0xFFFFFF);
	var n:uint=particleList.length;
	for (var i:uint=0; i<n; i++) {
		var particle:Object=particleList[i];
		if (particle) {
			//各粒子のエネルギー量が一定以下に鳴った場合削除する
			if (particle.energy<0.1) {
				particle=null;
				particleList.splice(i,1);
				continue;
			}
			with (particle) {
				x+=vx;
				y+=vy;
				//時間が経つごとに粒子のエネルギーを減少させる
				energy*=bmp;
				vx*=bmp;
				vy*=bmp;
				vy+=0.05;//仮想重力の入力
			}
			
			drawmc.graphics.moveTo(particle.x,particle.y);
			drawmc.graphics.lineTo(particle.x+0.5,particle.y+0.5);
		}
	}
	//半透明の黒いBMを覆いかぶせる
	bm.draw(drawmc);
	//BMに描画したデータを反映
	bm.draw(bm2);
}

 
       }
}