/**
 * Copyright Tamanegi_kenshi ( http://wonderfl.net/user/Tamanegi_kenshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vxBO
 */

// forked from Tamanegi_kenshi's flash on 2010-8-16
package {
    import flash.accessibility.Accessibility;
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.PixelSnapping;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import caurina.transitions.Tweener;
    import flash.text.TextField;
    import flash.events.*;

    //
    import flash.system.Security;
   
    public class FlashTest extends Sprite {
        
        
        private var file:String = "http://assets.wonderfl.net/images/related_images/4/46/46b4/46b43fe6e70bed538a247d1cbde929be12baac9e";
//頂点座標         
        private var _vertices:Vector.<Number> = new Vector.<Number>();
//頂点番号        
        private var _indices:Vector.<int> = new Vector.<int>();
//UV座標        
        private var _unData:Vector.<Number> = new Vector.<Number>();
        
        private var bd:BitmapData;
        private var btm:Bitmap;
        
        private var xNum:uint = 8;
        private var yNum:uint = 8;
        private var xInterval:Number;
        private var yInterval:Number;
        private var ballArr:Array = [];
        private var dragginBall:Ball;
        
//追加マウス避ける動きのための
        private var firstX:Array = [];
        private var firstY:Array = [];        

        
        public function FlashTest() {
            init();
        }//FrashTest
        
        
        private function init():void{
            Security.allowDomain("assets.wonderfl.net");
            Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
            // 
            var load:Loader = new Loader();
            var url:URLRequest = new URLRequest(file);
            load.load(url);
            load.contentLoaderInfo.addEventListener(Event.INIT, onInit);
        }
        
        private function onInit(event:Event):void{
            btm = event.target.content;
            bd = new BitmapData(300, 300, true, 0xcccccc);
            
            setVertices();
            setIndices();
          
            
            addEventListener(Event.ENTER_FRAME, onEnter);    
        }
        
        private function onEnter(event:Event):void{
            updataVertices();
　　　　　　　drawImage();
　　　　　　　ballFormM();
        }
//マウスを避ける動きこのための関数        
        private function ballFormM():void{
            for(var i:int =0; i < ballArr.length; i++){
            var ball:Ball = ballArr[i];
            var radian:Number = Math.atan2(ball.y - mouseY, ball.x - mouseX);
            var dist:Number = Math.sqrt(Math.pow(mouseX - ball.x, 2) + Math.pow(mouseY - ball.y, 2));
            var per:Number = 300 / dist;
            ball.x += per * Math.cos(radian) + (firstX[i] - ball.x) * 0.1;
            ball.y += per * Math.sin(radian) + (firstY[i] - ball.y) * 0.1;
        }
        }

       


         private function updataVertices():void{
            for(var i:int = 0; i < ballArr.length; i++){
                var ball:Ball = ballArr[i];
                _vertices[i * 2] = ball.x;
                _vertices[i * 2 + 1] = ball.y;
                ball.alpha = 1;
            }
        }
 
       private function setVertices():void{
          var bw:int = btm.width * 1.5 ;
         var bh:int = btm.height * 1.5 ;
           xInterval = bw / (xNum - 1);
            yInterval = bh / (yNum - 1);
           
           for(var i:int = 0; i < yNum; i++){
                for(var j:int = 0; j < xNum; j++){
                    var ball:Ball = new Ball(4, 0xff0000);
                    ballArr.push(ball);
                    ball.visible = false;
                    ball.x = xInterval * j - bw / 2 + 232 ;
                    ball.y = yInterval * i - bh / 2 + 232;
//追加マウス避ける動きのための設定
                    firstX.push(ball.x);
                    firstY.push(ball.y);
                    
                    addChild(ball);
                    
           //         ball.addEventListener(MouseEvent.MOUSE_DOWN, onDown);

                    _vertices.push(ball.x, ball.y);
                    _unData.push(j / (xNum -1) , i / (yNum - 1));
               }
           }
           stage.addEventListener(MouseEvent.MOUSE_UP, onUp);

/*
//頂点座標            
           _vertices.push(80, 100);
            _vertices.push(400, 100);
            _vertices.push(80, 350);
            _vertices.push(400, 350);
//頂点番号            
          _indices.push(0, 1, 2, 1, 2, 3);
//UV座標            
            _unData.push(0, 0);
            _unData.push(1, 0);
            _unData.push(0, 1);
            _unData.push(1, 1);
            
           ball.x = btm.x;
           */
        }

        
        private function onDown(event:MouseEvent):void{
            dragginBall = event.target as Ball;
            dragginBall.startDrag();
        }
        private function onUp(event:MouseEvent):void{
            if(Boolean(dragginBall)){
                dragginBall.stopDrag();
                dragginBall = null;
            }

        }


       

        
        private function drawImage():void{
            graphics.clear();
            graphics.lineStyle(1, 0xff0000, 0);
            graphics.beginBitmapFill(btm.bitmapData);
            graphics.drawTriangles(_vertices, _indices, _unData);
            graphics.endFill();
        }
        
        private function setIndices():void{
            for(var i:int = 0; i < ballArr.length; i++){
                if((i + 1) % xNum == 0 || i / xNum == yNum - 1){
                    
                } else {
                    var i1:int = i;
                    var i2:int = i + 1;
                    var i3:int = i + xNum;
                    var i4:int = i + 1;
                    var i5:int = i + xNum;
                    var i6:int = i + 1 + xNum;
                    _indices.push(i1, i2, i3, i4, i5, i6);
                }


            }

        }





    }//class
}//package
import flash.display.Sprite;

class Ball extends Sprite{
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var mass:Number;
    function Ball(radias:int, color:uint){
    graphics.beginFill(color);
    graphics.drawCircle(0,0,radias);
    graphics.endFill();
    }
}
