/**
 * Copyright CoremindJP ( http://wonderfl.net/user/CoremindJP )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vwTD
 */

package
{
    import flash.filters.BlurFilter;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.TimerEvent;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFieldType;
    import flash.text.TextFormat;
    import flash.utils.Timer;
    import flash.filters.BlurFilter;
    /**
     * 7セグメントディスプレイのシミュレーション。
     * DPと斜め変形は妥協！
     * http://ja.wikipedia.org/wiki/7%E3%82%BB%E3%82%B0%E3%83%A1%E3%83%B3%E3%83%88%E3%83%87%E3%82%A3%E3%82%B9%E3%83%97%E3%83%AC%E3%82%A4
     * @author H.Nakahara
     */
    [SWF(width="465", height="465", frameRate="60", backgroundColor="0")]
    public class Main extends Sprite
    {
        private var
            index:int,
            tf:TextField,
            str:Array,
            seg:SegmentDisplay,
            segParent:Sprite,
            segments:Vector.<SegmentDisplay>;

        public function Main():void
        {
            var tff:TextFormat = new TextFormat(null, 20, 0);
            tf = new TextField();
            tf.defaultTextFormat = tff;
            tf.text = "wonderfl";
            tf.width = 300;
            tf.height = 25;
            tf.type = TextFieldType.INPUT;
            tf.border = true;
            tf.borderColor = 0xFF8000;
            tf.background = true;
            tf.backgroundColor = 0xFFFFFF;
            tf.maxChars = 12;
            tf.addEventListener(Event.CHANGE, ch);
            tf.x = 82.5;
            tf.y = 400;
            addChild(tf);

            str = ["a", "b", "c", "d", "e", "f", "g", "h", "i", "j",
                   "k", "l", "m", "n", "o", "p", "q", "r", "s", "t",
                   "u", "v", "w", "x", "y", "z", "-", "_",
                   "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];

            seg = new SegmentDisplay();
            seg.createSegment(36, 7, 14, 1, 50, 0x0, 0x00FF80);
            seg.setValue("0");
            addChild(seg);

            var _tmpSeg:SegmentDisplay = new SegmentDisplay();
            _tmpSeg.createSegment(10, 4);
            _tmpSeg.setValue(" ")

            segParent = new Sprite();
            segments = new Vector.<SegmentDisplay>(12, true);
            for (var i:int = 0; i < 12; i++)
            {
                segments[i] = new SegmentDisplay();
                _tmpSeg.attachBMPDReference(segments[i]);
                segments[i].x = _tmpSeg.width * i;
                segParent.addChild(segments[i]);
            }
            segParent.x = (465 - segParent.width)  / 2;
            segParent.y = (465 - segParent.height) / 2;
            segParent.filters = [new BlurFilter(2,2)];
            addChild(segParent);
            ch();

            var t:Timer = new Timer(500, 0);
            t.addEventListener(TimerEvent.TIMER, th);
            t.start();
        }

        private function th(e:TimerEvent):void
        {
            seg.setValue(str[index]);
            index++;
            if (index == str.length) index = 0;
        }

        private function ch(e:Event = null):void
        {
            for (var i:int = 0; i < 12; i++)
                segments[i].setValue(tf.text.charAt(i));
        }
        
    }
    
}

{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    
    class SegmentDisplay extends Bitmap
    {
        private static const SEG_BIT:Vector.<uint> = new Vector.<uint>(7, true);
        SEG_BIT[0] = 0x1;
        SEG_BIT[1] = 0x10;
        SEG_BIT[2] = 0x100;
        SEG_BIT[3] = 0x1000;
        SEG_BIT[4] = 0x10000;
        SEG_BIT[5] = 0x100000;
        SEG_BIT[6] = 0x1000000;

        private static const SEG_TBL:Object = {};
        SEG_TBL["0"] = SEG_BIT[0] | SEG_BIT[2] | SEG_BIT[3] | SEG_BIT[4] | SEG_BIT[5] | SEG_BIT[6];
        SEG_TBL["1"] = SEG_BIT[5] | SEG_BIT[6];
        SEG_TBL["2"] = SEG_BIT[0] | SEG_BIT[1] | SEG_BIT[2] | SEG_BIT[4] | SEG_BIT[5];
        SEG_TBL["3"] = SEG_BIT[0] | SEG_BIT[1] | SEG_BIT[2] | SEG_BIT[5] | SEG_BIT[6];
        SEG_TBL["4"] = SEG_BIT[1] | SEG_BIT[3] | SEG_BIT[5] | SEG_BIT[6];
        SEG_TBL["5"] = SEG_BIT[0] | SEG_BIT[1] | SEG_BIT[2] | SEG_BIT[3] | SEG_BIT[6];
        SEG_TBL["6"] = SEG_BIT[0] | SEG_BIT[1] | SEG_BIT[2] | SEG_BIT[3] | SEG_BIT[4] | SEG_BIT[6];
        SEG_TBL["7"] = SEG_BIT[0] | SEG_BIT[5] | SEG_BIT[6];
        SEG_TBL["8"] = SEG_BIT[0] | SEG_BIT[1] | SEG_BIT[2] | SEG_BIT[3] | SEG_BIT[4] | SEG_BIT[5] | SEG_BIT[6];
        SEG_TBL["9"] = SEG_BIT[0] | SEG_BIT[1] | SEG_BIT[2] | SEG_BIT[3] | SEG_BIT[5] | SEG_BIT[6];
        SEG_TBL.hh   = SEG_BIT[1];
        SEG_TBL._    = SEG_BIT[2];
        SEG_TBL.space= 0;
        SEG_TBL.a    = SEG_BIT[0] | SEG_BIT[1] | SEG_BIT[3] | SEG_BIT[4] | SEG_BIT[5] | SEG_BIT[6];
        SEG_TBL.b    = SEG_BIT[1] | SEG_BIT[2] | SEG_BIT[3] | SEG_BIT[4] | SEG_BIT[6];
        SEG_TBL.c    = SEG_BIT[1] | SEG_BIT[2] | SEG_BIT[4];
        SEG_TBL.d    = SEG_BIT[1] | SEG_BIT[2] | SEG_BIT[4] | SEG_BIT[5] | SEG_BIT[6];
        SEG_TBL.e    = SEG_BIT[0] | SEG_BIT[1] | SEG_BIT[2] | SEG_BIT[3] | SEG_BIT[4];
        SEG_TBL.f    = SEG_BIT[0] | SEG_BIT[1] | SEG_BIT[3] | SEG_BIT[4];
        SEG_TBL.g    = SEG_BIT[0] | SEG_BIT[2] | SEG_BIT[3] | SEG_BIT[4] | SEG_BIT[6];
        SEG_TBL.h    = SEG_BIT[1] | SEG_BIT[3] | SEG_BIT[4] | SEG_BIT[6];
        SEG_TBL.i    = SEG_BIT[6];
        SEG_TBL.j    = SEG_BIT[2] | SEG_BIT[4] | SEG_BIT[5] | SEG_BIT[6];
        SEG_TBL.k    = SEG_BIT[0] | SEG_BIT[1] | SEG_BIT[3] | SEG_BIT[4] | SEG_BIT[6];
        SEG_TBL.l    = SEG_BIT[2] | SEG_BIT[3] | SEG_BIT[4];
        SEG_TBL.m    = SEG_BIT[0] | SEG_BIT[3] | SEG_BIT[4] | SEG_BIT[5] | SEG_BIT[6];
        SEG_TBL.n    = SEG_BIT[1] | SEG_BIT[4] | SEG_BIT[6];
        SEG_TBL.o    = SEG_BIT[1] | SEG_BIT[2] | SEG_BIT[4] | SEG_BIT[6];
        SEG_TBL.p    = SEG_BIT[0] | SEG_BIT[1] | SEG_BIT[3] | SEG_BIT[4] | SEG_BIT[5];
        SEG_TBL.q    = SEG_BIT[0] | SEG_BIT[1] | SEG_BIT[2] | SEG_BIT[3] | SEG_BIT[4] | SEG_BIT[5];
        SEG_TBL.r    = SEG_BIT[1] | SEG_BIT[4];
        SEG_TBL.s    = SEG_BIT[1] | SEG_BIT[2] | SEG_BIT[3] | SEG_BIT[6];
        SEG_TBL.t    = SEG_BIT[1] | SEG_BIT[2] | SEG_BIT[3] | SEG_BIT[4];
        SEG_TBL.u    = SEG_BIT[2] | SEG_BIT[4] | SEG_BIT[6];
        SEG_TBL.v    = SEG_BIT[2] | SEG_BIT[3] | SEG_BIT[4] | SEG_BIT[5] | SEG_BIT[6];
        SEG_TBL.w    = SEG_BIT[1] | SEG_BIT[2] | SEG_BIT[3] | SEG_BIT[4] | SEG_BIT[5] | SEG_BIT[6];
        SEG_TBL.x    = SEG_BIT[1] | SEG_BIT[3] | SEG_BIT[4] | SEG_BIT[5] | SEG_BIT[6];
        SEG_TBL.y    = SEG_BIT[1] | SEG_BIT[2] | SEG_BIT[3] | SEG_BIT[5] | SEG_BIT[6];
        SEG_TBL.z    = SEG_BIT[0] | SEG_BIT[2] | SEG_BIT[4] | SEG_BIT[5];

        private var m_bitmapDatas:Object;

        public function SegmentDisplay()
        {
            super(null, "auto", false);
            m_bitmapDatas = {};
        }

        public function destructThis():void
        {
            for each(var bmpd:BitmapData in m_bitmapDatas)
            {
                bmpd.dispose();
                bmpd = null;
            }
            m_bitmapDatas = null;
        }

        public function setValue(value:String):void
        {
            var _str:String = value.charAt(0).toLowerCase();
            if (_str == "-") _str = "hh"
            m_bitmapDatas[_str] !== undefined ?
                bitmapData = m_bitmapDatas[_str]:
                bitmapData = m_bitmapDatas.space;
        }

        public function attachBMPDReference(toSegmentDisplay:SegmentDisplay):void
        {
            toSegmentDisplay.m_bitmapDatas = m_bitmapDatas;
        }

        public function createSegment(
            shapeLength:int,
            shapeOffset:int,
            shapeThickness:int = 5,
            segmentOffset:int  = 2,
            margin:int = 2,
            backgroundColor:uint = 0x0,
            onColor:uint  = 0xFF0000,
            offColor:uint = 0x202020,
            bmpWidth:int  = 0,
            bmpHeight:int = 0):void
        {
            var
                _shapeWidth:int,
                _shapeHeight:int,
                _halfshapeWidth:int,
                _halfShapeHeight:int,
                _halfThickness:int,
                _pointsX:Array,
                _pointsY:Array,
                _bitmapData:BitmapData,
                _segment:Sprite = new Sprite(),
                _shape:Shape = new Shape(),
                _g:Graphics = _shape.graphics;

            //セグメント描画に必要なサイズを求める
            _shapeWidth      = shapeLength + shapeOffset * 2;
            _shapeHeight     = shapeThickness;
            _halfshapeWidth  = _shapeWidth / 2;
            _halfShapeHeight = _shapeHeight / 2;
            _halfThickness = shapeThickness / 2;

            //セグメント描画
            _g.beginFill(0xFFFFFF);
            _g.moveTo(0, _halfShapeHeight);
            _g.lineTo(shapeOffset, 0);
            _g.lineTo(shapeOffset + shapeLength, 0);
            _g.lineTo(_shapeWidth, _halfShapeHeight);
            _g.lineTo(shapeOffset + shapeLength, _shapeHeight);
            _g.lineTo(shapeOffset, _shapeHeight);
            _g.lineTo(0, _halfShapeHeight);
            _g.endFill();

            //描画データをローカル座標の中心(0, 0)にする為に親を作る
            _segment.addChild(_shape);
            _shape.x = _shape.width  / -2;
            _shape.y = _shape.height / -2;

            //セグメントの座標を求める
            _pointsX = [
                _halfThickness + _halfshapeWidth + segmentOffset + margin,
                _halfThickness + _halfshapeWidth + segmentOffset + margin,
                _halfThickness + _halfshapeWidth + segmentOffset + margin,
                _halfThickness + margin,
                _halfThickness + margin,
                _halfThickness + _shapeWidth + segmentOffset * 2 + margin,
                _halfThickness + _shapeWidth + segmentOffset * 2 + margin];
            _pointsY = [
                _halfThickness + margin,
                _halfThickness + _shapeWidth     + segmentOffset * 2 + margin,
                _halfThickness + _shapeWidth * 2 + segmentOffset * 4 + margin,
                _halfThickness + _halfshapeWidth + segmentOffset + margin,
                _halfThickness + _shapeWidth + _halfshapeWidth + segmentOffset * 3 + margin,
                _halfThickness + _halfshapeWidth + segmentOffset + margin,
                _halfThickness + _shapeWidth + _halfshapeWidth + segmentOffset * 3 + margin];

            //完成したBitmapDataを配列にキャッシュ
            for (var str:String in SEG_TBL)
            {
                _bitmapData = new BitmapData(
                    _shapeWidth     + segmentOffset * 2 + shapeThickness + margin * 2,
                    _shapeWidth * 2 + segmentOffset * 4 + shapeThickness + margin * 2,
                    false, backgroundColor);

                for (var j:int = 0; j < 7; j++)
                {
                    setColorTransform(_shape, str, j, onColor, offColor);

                    j < 3 ?
                        _bitmapData.draw(_segment, getTransformMatrix(_pointsX[j], _pointsY[j], 0)):
                        _bitmapData.draw(_segment, getTransformMatrix(_pointsX[j], _pointsY[j], Math.PI / 2));
                }

                m_bitmapDatas[str] = _bitmapData;
            }
        }

        private function getTransformPoint(b:Number, x:int, y:int):Point
        {
            return new Matrix(1, b).deltaTransformPoint(new Point(x, y));
        }

        private function getTransformMatrix(x:int, y:int, radian:Number):Matrix
        {
            var _matrix:Matrix = new Matrix();

            if (radian != 0) _matrix.rotate(radian);
            _matrix.tx = x;
            _matrix.ty = y;

            return _matrix;
        }

        private function setColorTransform(
            shape:Shape,
            str:String,
            segment:uint,
            onColor:uint,
            offColor:uint):void
        {
            var _ct:ColorTransform;

            _ct = shape.transform.colorTransform;
            SEG_TBL[str] & SEG_BIT[segment] ?
                _ct.color = onColor:
                _ct.color = offColor;
            shape.transform.colorTransform = _ct;
        }

    }

}

