/**
 * Copyright _wonder ( http://wonderfl.net/user/_wonder )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vwBJ
 */

// forked from _wonder's Tree Base
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.ui.Keyboard;
    
    [SWF(backgroundColor=0x000000)]
    public class Trees extends Sprite {
        private var trees:Array;
        private var numTrees:uint = 100;
        private var fl:Number = 250;
        private var vpX:Number = stage.stageWidth / 2;
        private var vpY:Number = stage.stageHeight / 2;
        private var floor:Number = 50;
        private var vz:Number = 0;
        private var friction:Number = 0.98;
        
        public function Trees() {
            init();
        }
        
        private function init():void {
            trees = new Array();
            for( var i:uint = 0; i < numTrees; i++ ){               
                var tree:Tree = new Tree();
                trees.push( tree );
                tree.xpos = Math.random() * 2000 - 1000;
                tree.ypos = floor;
                tree.zpos = Math.random() * 10000;
                addChild( tree );
            }
            addEventListener(Event.ENTER_FRAME, onEnterFrame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }
        
        private function onEnterFrame(e:Event):void {
            for( var i:uint = 0; i < numTrees; i++ ){
                var tree:Tree = trees[i];
                move( tree );
            }
            vz *= friction;
            sortZ();
        }
        
        private function onKeyDown(e:KeyboardEvent):void {
            if( e.keyCode == Keyboard.UP ){
                vz -= 1;
            } else if( e.keyCode == Keyboard.DOWN ){
                vz += 1;
            }
        }
        
        private function move(tree:Tree):void {
            tree.zpos += vz;
            if( tree.zpos < -fl ){
                tree.zpos += 10000;
            }

            if( tree.zpos > 10000 - fl ){
                tree.zpos -= 10000;
            }
            
            var scale:Number = fl / ( fl + tree.zpos );
            tree.scaleX = tree.scaleY = scale;
            tree.x = vpX + tree.xpos * scale;
            tree.y = vpY + tree.ypos * scale;
            tree.alpha = scale * 0.7 + 0.3;
        }
        
        private function sortZ():void {
            trees.sortOn("zpos", Array.DESCENDING | Array.NUMERIC );
            for( var i:uint = 0; i < numTrees; i++ ){
                var tree:Tree = trees[i];
                setChildIndex( tree, i );
            }
        }
    }
}

import flash.display.Sprite;

class Tree extends Sprite {
    public var xpos:Number = 0;
    public var ypos:Number = 0;
    public var zpos:Number = 0;
    
    public function Tree(){
        init();
    }
    
    private function init():void {
        graphics.lineStyle( 0, 0xffffff );
        graphics.lineTo( 0, -140 - Math.random() * 20 );
        graphics.moveTo( 0, -30 - Math.random() * 30 );
        graphics.lineTo( Math.random() * 80 - 40, -100 - Math.random() * 40 );
        graphics.moveTo( 0, -60 - Math.random() * 40 );
        graphics.lineTo( Math.random() * 60 - 30, -110 - Math.random() * 20 );
    }
}