/**
 * Copyright szbzs2004 ( http://wonderfl.net/user/szbzs2004 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vw4V
 */

// forked from shohei909's 垂直二等分線
// forked from shohei909's 垂線と鏡像
// forked from shohei909's 線分の交差判定
// forked from shohei909's Area of a Triangle(三角形の面積)
/*
緑の点はドラッグできます。
*/
package {
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.filters.GlowFilter;
    import flash.geom.Rectangle;
    import com.bit101.components.*;
    import flash.events.Event;
    import flash.display.*;
    public class FlashTest extends Sprite {
        public var dots:Array = [];
        public var r:Rectangle = new Rectangle( 10, 10, 445, 420 );
        public var canvas:Sprite = new Sprite();
        public var target:Object;
        
        public function FlashTest() {
            addChild( new Bitmap( new BitmapData(465,465,false,0x111111) ) )
            addChild( canvas );
            var dot:Dot;
            
            for( var i:int = 0; i < 3; i++ ){
                dot = new Dot( 0x0000FF );
                canvas.addChild( dot )
                dots.push( dot );
            }
            for( i = 0; i < 2; i++ ){
                dot = new Dot();
                dot.move( int( r.x + r.width* Math.random() ), int( r.y + r.height*Math.random() ) );
                dot.addEventListener( "mouseDown", start );
                dot.addEventListener( "mouseUp", stop );
                stage.addEventListener( "mouseMove", move );
                dot.buttonMode = true;
                canvas.addChild( dot );
                dots.push( dot );
            }
            
            update();
        }
        
        private function update():void{
            var g:Graphics = canvas.graphics;
            g.clear();
            var d:Dot;           

// I understand that you want to test the GeomUtil class, but there's a simpliest way
// to calculate the new coordinates, especially for the dots[1], dots[2]
/*
            var p:Point = GeomUtil.divide( 
                                            dots[3].x, dots[3].y,
                                            dots[4].x, dots[4].y);
            dots[0].move( p.x, p.y );            
            var m:Matrix = GeomUtil.rotate( dots[0].x, dots[0].y );
            d = dots[3];
            dots[1].move( m.a * d.x + m.b * d.y + m.tx, m.c * d.x + m.d * d.y + m.ty );
            d = dots[4];
            dots[2].move( m.a * d.x + m.b * d.y + m.tx, m.c * d.x + m.d * d.y + m.ty );
*/
            var dx2:Number = (dots[4].x - dots[3].x) / 2;
            var dy2:Number = (dots[4].y - dots[3].y) / 2;
            var d2:Number  = dx2 + dy2;
            dots[0].move(dots[3].x + dx2, dots[3].y + dy2);
            dots[1].move(dots[3].x + d2,  dots[4].y - d2);
            dots[2].move(dots[4].x - d2,  dots[3].y + d2);
          
            for( var i:int = 1; i < 5; i++ ){
                g.lineStyle( 3, [0x6666CC,0x66CC66][i>>1], 1 );
                d = dots[i++];
                g.moveTo( d.x, d.y );
                d = dots[i];
                g.lineTo( d.x, d.y );
            }
        }
        
        private function start(e:Event):void{ 
            target = e.target;        
        }
        private function move(e:Event):void{ 
            if( target ){
                target.move( mouseX, mouseY );
                update();
            }          
        }
        
        private function stop(e:Event):void{
            target = null;
        }
    }
}
import flash.geom.Matrix;
import flash.text.AntiAliasType;

import flash.events.Event;
import flash.geom.Point;
import flash.display.Graphics;
import flash.display.Sprite;
import com.bit101.components.*;

class Dot extends Sprite{
    private var lbl:Label;
    function Dot( color:uint = 0x00FF00){
        var g:Graphics = graphics;
        g.beginFill( color, 1 );
        g.drawRect( -5, -5, 10, 10 );
        Style.LABEL_TEXT = 0xBB6666;
        lbl = new Label( this, 0, 0, "" )
        lbl.textField.antiAliasType = AntiAliasType.ADVANCED;
        move(x,y);
    }
    public function move(x:Number,y:Number):void{
        this.x = x; this.y = y; lbl.text = "(" + x.toFixed(1) + "," + y.toFixed(1) + ")";
    }
}

class GeomUtil{
    /** 三角形の面積 */
    static public function triangleSum( 
                                            ax:Number, ay:Number,
                                            bx:Number, by:Number, 
                                            cx:Number, cy:Number ):Number{
        var s:Number = 0.5 * ((cy-ay)*(bx-ax)-(cx-ax)*(by-ay)) 
        return s>0?s:-s;
    }
    /** 線分の交差判定 */
    static public function segmentHitTest( 
                                            sx1:Number, sy1:Number,
                                            ex1:Number, ey1:Number, 
                                            sx2:Number, sy2:Number, 
                                            ex2:Number, ey2:Number ):Boolean{
        var cx:Number, cy:Number, dx:Number, dy:Number;
        var r:Number = ( cx = sx1 - ex1 ) * ( dy = sy2 - ey2 ) - ( cy = sy1 - ey1 ) * ( dx = sx2 - ex2 );
        if( r == 0 ){ return false; }
        var ax:Number = sx1 - sx2;
        var ay:Number = sy1 - sy2;
        var s:Number = (dy * ax - dx * ay ) / r
        var t:Number = (cy * ax - cx * ay ) / r
        if( 0 <= t && t < 1 && 0 <= s  && s < 1 ){ return true; }
        return false;
    }
    /** 二つの直線の交点 */
    static public function intersection( 
                                            sx1:Number, sy1:Number,
                                            ex1:Number, ey1:Number, 
                                            sx2:Number, sy2:Number, 
                                            ex2:Number, ey2:Number ):Point{
        var cx:Number, cy:Number, dx:Number, dy:Number;
        var r:Number = ( cx = sx1 - ex1 ) * ( dy = sy2 - ey2 ) - ( cy = sy1 - ey1 ) * ( dx = sx2 - ex2 );
        if( r == 0 ){ return null; }
        var ax:Number = sx1 - sx2;
        var ay:Number = sy1 - sy2;
        var s:Number = (dx * ay - dy * ax) / r;
        return new Point( sx1 + s * cx, sy1 + s * cy ) ;
    }
    
    /** 直線ABと点Cからの垂線の交点 */
    static public function perpendicular( 
                                            ax:Number, ay:Number,
                                            bx:Number, by:Number, 
                                            cx:Number, cy:Number ):Point {
        var dx:Number, dy:Number;
        var al:Number = (dx = bx - ax) * dx + (dy = by - ay) * dy;
        if( al == 0 ){ return null; }
        var k:Number = - (dx * (ax - cx) + dy * (ay - cy)) / al
        return new Point( k * dx + ax, k * dy + ay );
    }
    
    
    /** 線分ABの内分点(0<r<1)、外分点(r<0,1<r) */
    static public function divide(
                                            ax:Number, ay:Number,
                                            bx:Number, by:Number,
                                            r:Number = 0.5):Point {
        return new Point( ax + r * (bx - ax), ay + r * (by - ay) );
    }
    
    /** 点Aを中心とする回転行列を生成 */
    static public function rotate(
                                            ax:Number, ay:Number,
                                            d:Number = 90):Matrix {
        var r:Number = Math.PI * d / 180;
        var s:Number = Math.sin( r ), c:Number = Math.cos( r );
        return new Matrix( c, -s, s, c, ax - c * ax + s * ay, ay - s * ax - c * ay );
    }
}