/**
 * Copyright hacker_peg_iiap ( http://wonderfl.net/user/hacker_peg_iiap )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vvhb
 */

// forked from chomeconic's flash-study 2010-4-22
//全くの0地点からwonderfl本を見ながらお勉強はじめました。
//ここでちょこちょこ勉強日記かいてます。 
//http://d.hatena.ne.jp/chomeco/searchdiary?word=*[wonderfl]
//今日はチョコを食べながら勉強してます
package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	public class PhysBall extends Sprite 
	{
		//fail buttonMode = true
		internal var frameCount:uint = 0
		internal var mouseColor:uint = 0xFF
		
		internal var scene:PhysicsScene = new PhysicsScene()
		internal var chunk:Chunk = new Chunk()
		internal var grabbedChunk:Chunk = null
		
		public function PhysBall() 
		{ 		
			stage.addEventListener(Event.ENTER_FRAME, onEnterFrame)
			stage.addEventListener(MouseEvent.MOUSE_MOVE, onMouseMove)
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown)
			stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp)
			
			scene.xMin = 0
			scene.yMin = 0
			scene.xMax = stage.stageWidth
			scene.yMax = stage.stageHeight
			
			chunk.phyx.scene = scene
			chunk.phyx.position.x = stage.stageWidth / 2
			chunk.phyx.position.y = stage.stageHeight / 4
			addChild(chunk)
		}
		
		public function onMouseMove(e:MouseEvent):void
		{
			if (grabbedChunk)
			{
				grabbedChunk.phyx.velocity.x = (e.stageX - grabbedChunk.phyx.position.x) / 0.25
				grabbedChunk.phyx.velocity.y = (e.stageY - grabbedChunk.phyx.position.y) / 0.25
				grabbedChunk.phyx.position.x = e.stageX
				grabbedChunk.phyx.position.y = e.stageY		
			}
		}
		
		public function onMouseDown(e:MouseEvent):void
		{
			grabbedChunk = chunk
			grabbedChunk.phyx.velocity.scaleBy(0)
			grabbedChunk.phyx.position.x = e.stageX
			grabbedChunk.phyx.position.y = e.stageY
			grabbedChunk.phyx.moving = false
		}
		
		public function onMouseUp(e:MouseEvent):void
		{
			if (grabbedChunk)
			{
				//grabbedChunk.phyx.velocity.x = (e.stageX - grabbedChunk.phyx.position.x) / 0.5
				//grabbedChunk.phyx.velocity.y = (e.stageY - grabbedChunk.phyx.position.y) / 0.5
				grabbedChunk.phyx.position.x = e.stageX
				grabbedChunk.phyx.position.y = e.stageY
				grabbedChunk.phyx.moving = true
				grabbedChunk = null
			}
		}
		
		public function onEnterFrame(event:Event):void
		{
			//graphics.clear()
			
			++frameCount
			//DrawCircle(200, 40, 10, 0x0000FF)
			//DrawCircle(60, 60, 5, 0xFF0000)
			//DrawCircle(90, 80, 10, 0x00FF00)
		}
		
		protected function DrawRegularPolygon(x:int, y:int, radius:int, color:int, sides:int):void
		{
			var radperside:Number = 2 * Math.PI / sides
			graphics.beginFill(color)
			graphics.lineStyle(2, 0xfff000)
			graphics.moveTo(x + radius, y)
			for( var d:int = 0; d < sides; d++ )
			{
				var radian:Number = d * radperside
				graphics.lineTo (
					x + radius * Math.cos( radian ),
					y + radius * Math.sin( radian ) )
			}
			graphics.endFill() 		
		}
		
		protected function DrawCircle(x:int, y:int, radius:int, color:int):void
		{
			//DrawRegularPolygon(x, y, radius, color, 36)
			
			graphics.beginFill(color)
			graphics.drawCircle(x, y, radius)
			graphics.endFill()
		}
	}
}

internal class PolyDef
{
	public var radius:int
	public var x:int
	public var y:int
	public var color:int
	public var sides:uint
	
	public function PolyDef()
	{
		radius = 10
		x = 0
		y = 0
		color = 0xFF0000
		sides = 3
	}
}

////////////////////////////////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Vector3D;

	
internal class PhysicsScene
{
	public var xMin:int
	public var xMax:int
	public var yMin:int
	public var yMax:int
	
	public function PhysicsScene()
	{
	}
}

internal final class Collision
{
	public static const NONE:Collision = new Collision()
	public static const XMIN:Collision = new Collision()
	public static const XMAX:Collision = new Collision()
	public static const YMIN:Collision = new Collision()
	public static const YMAX:Collision = new Collision()
}

import flash.accessibility.Accessibility;
internal class PhysicsObject
{
	public var position:Vector3D	
	public var velocity:Vector3D
	public var elasticity:Number
	public var ifriction:Number
	public var scene:PhysicsScene
	public var t:Number
	public var moving:Boolean = true
	
	public function PhysicsObject()
	{
		position = new Vector3D()
		velocity = new Vector3D()
		elasticity = 0.9
		ifriction = 0.9
	}
	
	public function Update(time:Number, recursionCount:uint):uint
	{
		t = 1
		if (!moving)
			return recursionCount
		
		// Apply gravity.
		var newvel:Vector3D = velocity.clone()
		newvel.y += 9.8 * time 
		
		// Apply velocity.
		var delta:Vector3D = velocity.clone()
		delta.scaleBy(time)
		delta.y += 0.5 * 9.8 * time * time
		
		var newpos:Vector3D = position.add(delta)
		
		var retval:uint = recursionCount + 1
		var col:Collision = Collision.NONE
		
		// Test vs. overlap with walls.
		if (newpos.x < scene.xMin)
		{
			col = Collision.XMIN
			t = (scene.xMin - position.x) / delta.x		
		}
		if (newpos.x > scene.xMax)
		{
			col = Collision.XMAX
			t = (scene.xMax - position.x) / delta.x
		}
		if (newpos.y < scene.yMin)
		{
			col = Collision.YMIN
			t = (scene.yMin - position.y) / delta.y				
		}
		if (newpos.y > scene.yMax)
		{
			col = Collision.YMAX
			t = (scene.yMax - position.y) / delta.y
		}
		
		trace(recursionCount.toString()+" "+time.toString()+" "+t.toString())

		//if (t < 0.001)
		if (false)
		{
			moving = false
			return recursionCount
		}
		
		if (Collision.NONE != col)
		{
			//! just for breakpoint
			if (recursionCount == 40)
				moving = true
			
			// Apply gravity.
			var velatt:Vector3D = velocity.clone()
			velatt.y += 9.8 * time * t

			var newdelta:Vector3D = velocity.clone()
			newdelta.scaleBy(t * time)
			newdelta.y += 0.5 * 9.8 * (time * t) * (time * t)
			var posatt:Vector3D = position.add(newdelta)
			
			newpos = posatt.clone()
			newvel = velatt.clone()
			
			switch (col)
			{
				case Collision.XMIN:
					newpos.x = scene.xMin
					newvel.x = -newvel.x * elasticity
					newvel.y = newvel.y * ifriction
					break
				case Collision.XMAX:
					newpos.x = scene.xMax
					newvel.x = -newvel.x * elasticity
					newvel.y = newvel.y * ifriction
					break
				case Collision.YMIN:
					newpos.y = scene.yMin
					newvel.y = -newvel.y * elasticity
					newvel.x = newvel.x * ifriction
					break
				case Collision.YMAX:
					if (velocity.length < 0.1)
					{
						moving = false
						return recursionCount
					}
					
					newpos.y = scene.yMax
					newvel.y = -newvel.y * elasticity
					newvel.x = newvel.x * ifriction
					break
			}
		}
		
		position = newpos.clone()
		velocity = newvel.clone()
		
		var newTime:Number = time * (1 - t)
		if (newTime > 0.01)
		{
			retval = Update(newTime, retval)
			retval = 0x808080
		}
		
		return retval
	}
}

internal class Chunk extends Sprite
{
	public var phyx:PhysicsObject
	protected var radius:uint
	protected var color:int
	public var frameCount:uint = 0
	
	public function Chunk()
	{
		phyx = new PhysicsObject()
		phyx.position.x = 100
		phyx.position.y = 100
		phyx.velocity.x = 10
		phyx.velocity.y = 0
		radius = 20
		
		addEventListener(Event.ENTER_FRAME, onEnterFrame)
	}
	
	private function onEnterFrame(event:Event):void
	{
		++frameCount;
		//if (0 == frameCount % 10)
			Update(0.5)
	}
	
	private function Update(time:Number):void
	{
		var recursionCount:uint = phyx.Update(time, 0)
		var newColor:uint = 0xF << recursionCount
		//if (newColor > 0)
			color = newColor
		x = phyx.position.x
		y = phyx.position.y
		
		Draw()
	}
	
	private function Draw():void
	{
		graphics.clear()
		
		graphics.beginFill(color)
		graphics.drawCircle(0, 0, radius)
		graphics.endFill()
		
		DrawPhysics()
	}
	
	private function DrawPhysics():void
	{
		graphics.beginFill(0xFF0000)
		graphics.lineStyle(6, 0xFF0000)
		graphics.moveTo(0, 0)
		graphics.lineTo(phyx.velocity.x, phyx.velocity.y)
		graphics.endFill()
		
		//graphics.beginFill(0x008000)
		//graphics.drawCircle(0, phyx.t * 10, radius)
		//graphics.endFill()		
	}
}
