/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vugq
 */

package {
    import flash.events.TextEvent;
    import flash.text.TextFieldType;
    import flash.events.KeyboardEvent;
    import flash.text.TextField;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var _textField:TextField;
        private var _preventFollowingTextInput:Boolean;
        
        public function FlashTest() {
            _textField = new TextField;
            _textField.type = TextFieldType.INPUT;
            _textField.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
            _textField.addEventListener(TextEvent.TEXT_INPUT, onTextInput);
            _textField.width = _textField.height = 465;
            addChild(_textField);
        }
        
        private function onKeyDown(e:KeyboardEvent):void {
            var c:String = String.fromCharCode(e.charCode);
            var lastNumber:int = _textField.text.lastIndexOf('-') + 1;
            switch (c) {
            case '0' : 
            case '1' : 
            case '2' : 
            case '3' : 
            case '4' : 
            case '5' : 
            case '6' : 
            case '7' : 
            case '8' : 
            case '9' : 
                _preventFollowingTextInput = false;
                break;
            case '-' :
                var recentInput:String = _textField.text.substring(lastNumber, _textField.caretIndex);
                while (recentInput.length < 6) recentInput = "0" + recentInput;
                recentInput += "-";
                _textField.replaceText(lastNumber, _textField.caretIndex, recentInput);
                _textField.setSelection(lastNumber + 7, lastNumber + 7);
                _preventFollowingTextInput = true;
                break;
            default :
                _preventFollowingTextInput = true;
            }
        }
        
        private function onTextInput(e:TextEvent):void {
            if (_preventFollowingTextInput) {
                e.preventDefault();
            }
        }
    }
}