/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vueW
 */

// forked from siouxcitizen's Away3D練習3　3種類のMaterialでSphere表示
// forked from siouxcitizen's Away3D練習2　3種類のMaterialでPlane表示
// forked from siouxcitizen's Away3D練習1　Plane表示
// forked from siouxcitizen's forked from: Away3Dの練習
// forked from ser1zw's Away3Dの練習

package {
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.events.MouseEvent;
  
  import away3d.containers.View3D;
  import away3d.primitives.Cube;
  import away3d.materials.WireColorMaterial;
  import away3d.materials.ColorMaterial;
  import away3d.materials.WireframeMaterial;

  [SWF(backgroundColor="#337777")]
  public class Away3DCubeTest extends Sprite {
    private var view:View3D;
    private var cube : Cube;
    private var wireframeMaterial:WireframeMaterial;
    private var wireColorMaterial:WireColorMaterial;
    private var colorMaterial:ColorMaterial;

    public function Away3DCubeTest() {
      view = new View3D();
      view.x = stage.stageWidth >> 1;
      view.y = stage.stageHeight >> 1;
      addChild(view);

      wireframeMaterial = new WireframeMaterial(0x00ff00);

      wireColorMaterial = new WireColorMaterial(0xff0000);
      wireColorMaterial.wireColor = 0xffff00;

      colorMaterial = new ColorMaterial(0x0000ff);

      cube = new Cube({width:100, height:100, depth:100});
      cube.cubeMaterials.front = wireframeMaterial;
      cube.cubeMaterials.back = wireframeMaterial;
      cube.cubeMaterials.right = wireColorMaterial;
      cube.cubeMaterials.left = wireColorMaterial;
      cube.cubeMaterials.top = colorMaterial;
      cube.cubeMaterials.bottom = colorMaterial;

      view.scene.addChild(cube);

      addEventListener(Event.ENTER_FRAME, onEnterFrame);
    }

    private function onEnterFrame(e:Event):void {
      view.scene.rotationX = -(stage.mouseY - (stage.stageHeight >> 1));
      view.scene.rotationY = stage.mouseX - (stage.stageWidth >> 1);

      cube.rotationX += 3;
      cube.rotationY += 3;

      view.render();
    }
  }
}
