/**
 * Copyright DanYuya ( http://wonderfl.net/user/DanYuya )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vu2t
 */

package {
    import flash.display.Sprite;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.events.KeyboardEvent;
    
    public class FlashTest extends Sprite {
          public var vx:int = 5, vy:int = 5;     // ボールの速度（ｘ方向、ｙ方向）
          public var ball:Sprite;    // ボールの Sprite インスタンス
          public var bar:Sprite;    // バーの Sprite インスタンス
          public var block:Array = new Array( 24 );     // ブロックインスタンスの格納用配列
          public var flag:Array = new Array( 24 );     // ブロックの存在確認用配列
          public var timer:Timer;    // Timer 使用
          public var c:int;    // 残りブロック数
            
          public function FlashTest() {
            // コンストラクタ部でプログラム起動時に処理する内容を記述する
            c = 24;
            
            // ボールの生成
            ball = new Sprite();
            ball.graphics.beginFill( 0xFFCC33, 1 );
            ball.graphics.drawCircle( 0, 0, 25 );
            ball.x = 275;
            ball.y = 200;
            addChild( ball );

            // バーの生成
            bar = new Sprite();
            bar.graphics.beginFill( 0x996600, 1 );
            bar.graphics.drawRect( 0, 0, 100, 5 );
            bar.x = 250
            bar.y = 375;
            addChild( bar );
            
            // ブロックの生成
            for( var i:int = 0; i < 24; i++ ){
                var b:Sprite = new Sprite();
                b.graphics.beginFill( 0xCC6600, 1 );
                b.graphics.drawRect( 0, 0, 75, 25 );
                b.x = 50 + ( i % 4 ) * 100;    // ブロックのｘ位置
                b.y = 25 + int( i / 4 ) * 35;    // ブロックのｙ位置
                block[i] = b;    // 生成したインスタンスを配列に代入する
                addChild( block[i] );
                flag[i] = true;    // ブロックは存在する（=true）
            }
            
            
            // キー入力に対するイベントハンドらーの登録
            stage.addEventListener(KeyboardEvent.KEY_DOWN, fl_KeyboardDownHandler);
    
            // タイマーの設定
            timer = new Timer( 1000 / 48);
            timer.addEventListener( TimerEvent.TIMER, loop );
            timer.start();
        }
        
        public function loop( event:TimerEvent ): void{
            ball.x += vx;
            ball.y += vy;
            bar.x += ( ( ball.x - bar.width / 2 ) - bar.x ) / 15;    // 自動追尾機能
            
            // 壁との当たり判定
            if( ball.x + vx < 25 || 400 < ball.x + vx ){
                vx = -vx;
            }
            if( ball.y + vy < 25 ){
                vy = -vy;
            }
            
            // バーとの当たり判定
            if( ( bar.x - 25 == ball.x && vx > 0 || ball.x == bar.x + bar.width + 25 && vx < 0 )
                  && bar.y - 25 < ball.y + vy && ball.y + vy < bar.y + bar.height + 25 ){
                vx = -vx;
            }
            if( ( bar.y - 25 == ball.y && vy > 0 || ball.y == bar.y + bar.height + 25 && vy < 0 )
                && bar.x - 25 < ball.x + vx && ball.x + vx < bar.x + bar.width + 25 ){
                vy = -vy;
            }
            
            // 各ブロックとの当たり判定
            for( var i:int = 0; i < block.length; i++ ){
                if( !flag[i] ) continue;
                if( ( block[i].x - 25 == ball.x && vx > 0 || ball.x == block[i].x + block[i].width + 25 && vx < 0 )
                      && block[i].y - 25 < ball.y + vy && ball.y + vy < block[i].y + block[i].height + 25 ){
                    vx = -vx;
                    flag[i] = false;
                    removeChild( block[i] );    // ステージ上から消去する
                    c--;
                }
                if( ( block[i].y - 25 == ball.y && vy > 0 || ball.y == block[i].y + block[i].height + 25 && vy < 0 )
                    && block[i].x - 25 < ball.x + vx && ball.x + vx < block[i].x + block[i].width + 25 ){
                    vy = -vy;
                    flag[i] = false;
                    removeChild( block[i] );    // ステージ上から消去する
                    c--;
                }
            }
            
            // ボールが下に落ちたらタイマーを停止する
            if( 400 < ball.y + vy ){
                timer.stop();
            }
            
            // ブロックがなくなったら、再開する
            if( c <= 0 ){
                c = 24;
                for( var j:int = 0; j < 24; j++ ){
                    addChild( block[j] );
                    flag[j] = true;
                }
            }
        }

        public function fl_KeyboardDownHandler(event:KeyboardEvent): void
        {
          // 左矢印キー（←）の押下に対する処理
          if( event.keyCode == 37 ){
              bar.x -= 5;
          }

          // 右矢印キー（→）の押下に対する処理
          if( event.keyCode == 39 ){
              bar.x += 5;
          }
        }
    }
}