/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vtuF
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=84
    public class Euler84 extends Sprite {
        private var _tf : TextField;
  
        public function Euler84() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            _tf.appendText(solve().toString() + "\n");
            var g : int = getTimer();
            _tf.appendText((g - s).toString() + " ms\n");
        }
        
        private function solve() : int
        {
            /*
            var d2 : Array = [
                0.0,
                0.0,
                1.0 / 36.0,
                2.0 / 36.0,
                3.0 / 36.0,
                4.0 / 36.0,
                5.0 / 36.0,
                6.0 / 36.0,
                5.0 / 36.0,
                4.0 / 36.0,
                3.0 / 36.0,
                2.0 / 36.0,
                1.0 / 36.0
            ];
            */
            var d2 : Array = [
                0.0,
                0.0,
                0.0,
                2.0 / 30.0,
                2.0 / 30.0,
                4.0 / 30.0,
                4.0 / 30.0,
                6.0 / 30.0,
                4.0 / 30.0,
                4.0 / 30.0,
                2.0 / 30.0,
                2.0 / 30.0
            ];
            
            var cur : Vector.<Number> = new Vector.<Number>(40);
            cur[0] = 1.0;
            var i : int, j : int;
            for(i = 1;i < 40;i++)cur[i] = 0.0;
            
            var zero : Vector.<Number> = new Vector.<Number>(40);
            for(i = 0;i < 40;i++)zero[i] = 0.0;
            
            var p : Vector.<Number>;
            do {
                p = cur;
                cur = zero.concat();
                for(i = 0;i < 40;i++){
                    cur[10] += p[i] / 216; // three consecutive doubles to jail
                    var rest : Number = p[i] * 215 / 216;
                    for(j = 3;j <= 11;j++){
                        var num : int = (i + j) % 40;
                        if(num == 30)num = 10; // G2J
                        cur[num] += rest * d2[j];
                    }
                }
            
                var cha : Number = 0.0;
                for(i = 0;i < 40;i++)cha += Math.abs(p[i] - cur[i]);
            } while(cha > 0.00001);
            
            _tf.appendText(cur[10].toString() + "   " + cur[30].toString() + "\n");
            return 0;
        }
    }
}