/**
 * Copyright enecre ( http://wonderfl.net/user/enecre )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vtDL
 */

package {
    import flash.text.TextField;
    import flash.display.Sprite;
    import flash.utils.getTimer;
    public class FlashTest extends Sprite {
        private var tf:TextField;
        public function FlashTest() {
            tf = new TextField();
            tf.width = stage.stageWidth;
            tf.height = stage.stageHeight;
            addChild(tf);
            
            var start:int = getTimer();
            var res:Array = Eratosthenes.run([10]);
            tr(getTimer() - start + "ms");
            tr(res);
        }
        
        private function tr(...o:Array):void{
            tf.appendText(o + "\n");
            tf.scrollV = tf.maxScrollV;
        }

    }
}
class Eratosthenes {
    public static function run(ns:Array):Array {
        const size:int = 10000000;
        var dp:Vector.<int> = new Vector.<int>(size);
        for (var i:int = 0; i < size; i++) dp[i] = 0;
        var tmp:int = 0;
        for (i = 2; i < size; i++) {
            if (dp[i] != 0) continue;
            dp[i] = (++tmp);
            for (var j:int = i * 2; j < size; j += i) {
                dp[j] = -1;
            }
        }
        var res:Array = [];
        for (i = 0; i < ns.length; i++) {
            var n:int = ns[i];
            while (dp[n] == -1) n--;
            res[i] = dp[n];
        }
        return res;
    }
}