/**
 * Copyright sakusan393 ( http://wonderfl.net/user/sakusan393 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vsyt
 */

package {
	
	/*
	赤い四角と、青い四角がボタン
	いずれもクリックするとボタンの色と同じ画像を読み込んで表示。
	クリックするたびに、削除、再読み込み(位置を変えて表示）を繰り返す。
	画像の読み込みには、LoadBitmapData()を仕様
	赤と青の処理の違いは、LoadBitmapData.execute()の記述の位置
	赤は、COMPLETEイベント定義の前に記述
	青は、COMPLETEイベント定義の後に記述
	どちらもクリック最初の1回目は読み込み、表示可能だが、
	赤はクリック2回目以降はexecute()が実行されないみたい。
	
	イベント定義する前に実行してるから当然イベントは発生しない
	とのこと、よく考えたら当たり前か。。。
	一発目が実行されるのは、swf読み込み時にAS全部読んでる
	って感じなのかな。
	*/
	
	import flash.system.LoaderContext;
	import jp.progression.commands.display.*;
	import jp.progression.commands.lists.*;
	import jp.progression.commands.net.*;
	import jp.progression.commands.tweens.*;
	import jp.progression.commands.*;
	import jp.progression.data.getResourceById;
	import jp.progression.events.ExecuteEvent;
	import flash.system.Security;
	
	import flash.display.*;
	import flash.events.*;
	import flash.net.*;

	public class Test extends Sprite{
		
		var theme1:String="http://assets.wonderfl.net/images/related_images/3/33/3309/3309241173df33a99487a07ab3b60c5412eeb3b1";
		var theme2:String="http://assets.wonderfl.net/images/related_images/b/bd/bde7/bde7cb567201e1296a97805394aab9f6963c98ef";
		var mc:MovieClip;
		var btn1:Sprite;
		var btn2:Sprite;
		var count = 0;
		
		public function Test():void{
			Security.loadPolicyFile( "http://www.shift-style.org/crossdomain.xml" );  
			addChild(btn1 = box(0xFF0000));
			addChild(btn2 = box(0x0000FF))
			btn1.x = 10;btn1.y = 200;
			btn2.x = 300;btn2.y = 200;
			btn1.addEventListener(MouseEvent.CLICK , click);
			btn2.addEventListener(MouseEvent.CLICK , click2);
		}
		private function box(color:int = 0xFF0000):Sprite{
			var sp:Sprite = new Sprite();
			sp.graphics.beginFill(color);
			sp.graphics.drawRect(0,0,100,100);
			return sp;
		}
		//画像1の読み込み
		private function click(e:MouseEvent):void {
			trace("click1");
			var loadBitmapData:LoadBitmapData=new LoadBitmapData(new URLRequest(theme1));
			loadBitmapData.context = new LoaderContext(true);
			//Completeの前にexecuteを記述
			//この場合は、最初の1回目しかコマンドが実行されない？
			loadBitmapData.execute();
			loadBitmapData.addEventListener(ExecuteEvent.EXECUTE_COMPLETE, comp);
		}
		private function (e:ExecuteEvent):void {
			trace("complete");
			var bmp:Bitmap = new Bitmap(getResourceById(theme1).toBitmapData());
			if (!mc){
				mc = new MovieClip();
				addChild(mc);
			}
			if(mc.numChildren > 0){
				mc.removeChildAt(0);
			}
			mc.addChild(bmp);
			mc.x = count;
			count += 200;
			if(count > 400) count = 0;
		}
		//画像2の読み込み
		private function click2(e:MouseEvent):void {
			trace("click1");
			var loadBitmapData:LoadBitmapData=new LoadBitmapData(new URLRequest(theme2));
			loadBitmapData.context = new LoaderContext(true);
			loadBitmapData.addEventListener(ExecuteEvent.EXECUTE_COMPLETE, comp2);
			//Completeの後にexecuteを記述
			//この場合は、2回目以降もコマンドは実行される。
			loadBitmapData.execute();
		}
		private function comp2 (e:ExecuteEvent):void {
			trace("complete");
			var bmp:Bitmap = new Bitmap(getResourceById(theme2).toBitmapData());
			if (!mc){
				mc = new MovieClip();
				addChild(mc);
			}
			if(mc.numChildren > 0){
				mc.removeChildAt(0);
			}
			mc.addChild(bmp);
			mc.x = count;
			count += 200;
			if(count > 400) count = 0;
		}
	}
}
