/**
 * Copyright chimanaco ( http://wonderfl.net/user/chimanaco )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vse7
 */

// forked from Event's Human Clock
package {
    import com.bit101.components.*;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Loader;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.ProgressEvent;
    import flash.events.TimerEvent;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.net.URLRequest;
    import flash.utils.Timer;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.*;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.tweens.ITween;
    
    public class HumanClock extends Sprite {
        private var _progress:ProgressBar;        
        private var _loader:Loader;
        private var _sec:int;
        private var _spContainer:Sprite;
        private var _shpSec:Shape;
        private var _shpMin:Shape;
        private var _shpHour:Shape;
        private var _pathCommands:Vector.<int> = Vector.<int>([1, 2, 2, 2, 2]);
        
        private var _cnt:int = 20;
        private var _first:Boolean = true;
        private var _nosePosition:String = "left";
        private var _radius:Number = 145;
        private var _noseY:Number = 465 / 2;
        private var _nose:Nose;
        private var _hand:Hand;
        private var _noseHairs:Array = new Array();
        private var _clockHairs:Array = new Array();
        
        private var _bloodNum:int = 60;
        private var _bloodPosition:String = "left";
        private var _bloodY:Number = 29;
        private var _canvas:BitmapData;
        private var _ctf:ColorTransform = new ColorTransform(1, 1, 1, 1, 0, 0, 0, -3.5);
        private var _bloodArr:Array = new Array(); 
 
        [SWF(width = 465, height = 465, backgroundColor = 0xFFFFFF, frameRate = 30)]
        public function HumanClock() {
            //Wonderfl.disable_capture();
            Wonderfl.capture_delay(60);
            var capture:Bitmap = new Bitmap(new BitmapData(465, 465, false, 0x000000));
            addChild(capture);            
            
            initBG();
        }
        
        private function initBG():void {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            _loader = new Loader();
            var urImage:URLRequest = new URLRequest("http://lab.chimanaco.net/wonderfl/100730/w-paper.jpg");
            _loader.load(urImage);
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, addBG);
            _loader.contentLoaderInfo.addEventListener(ProgressEvent.PROGRESS, onLoadingBG);
            
            _progress = new ProgressBar(this, 182, 222);
            addChild(_progress);        
        }
        
        private function onLoadingBG(e:ProgressEvent):void 
        {
            _progress.value = e.bytesLoaded / e.bytesTotal;
        }
        
        private function addBG(e:Event):void {
            removeChild(_progress);
            _progress = null;
            
            addChild(_loader);
            
            initView();
            var timer:Timer = new Timer(100);
            timer.addEventListener(TimerEvent.TIMER, onTimer);
            timer.start();
        }
        
        
        private function initView():void {
            _spContainer = new Sprite;
                        
            _spContainer.graphics.beginFill(0x666666);
            _spContainer.graphics.moveTo(0, 6);
            _spContainer.graphics.lineTo(15, -8);
            _spContainer.graphics.lineTo(-15, -8);
            _spContainer.graphics.endFill();
            
            var gripR:Shape = new Shape();
            gripR.graphics.lineStyle(8, 0xFF6600);
            gripR.graphics.drawEllipse(11, -15, 48, 30);
            gripR.rotation = -60;
            _spContainer.addChild(gripR);
            
            var gripL:Shape = new Shape();
            gripL.graphics.lineStyle(8, 0xFF6600);
            gripL.graphics.drawEllipse(11, -15, 48, 30);
            gripL.rotation = -120;
            _spContainer.addChild(gripL);
            
            _shpHour = new Shape;
            _shpHour.graphics.beginFill(0x666666);
            drawTrapezium(_shpHour.graphics, 2, 90, 10, -5);
            _shpHour.graphics.drawCircle(0, 90, 4);
            _shpHour.graphics.endFill();
            
            _shpMin = new Shape;
            _shpMin.graphics.beginFill(0x999999);
            drawTrapezium(_shpMin.graphics, 2, 130, 8, -5);
            _shpMin.graphics.drawCircle(0, 130, 4);
            _shpMin.graphics.endFill();
            
            var dot:Shape = new Shape;
            dot.graphics.beginFill(0x666666);
            dot.graphics.drawCircle(0, 0, 4);
            dot.graphics.endFill();
            
            // nose
            _nose = new Nose();
            _nose.x = 465 / 2;
            _nose.y = 5;
            addChild(_nose);
            
            _spContainer.x = 465 >> 1;
            _spContainer.y = 260;
            addChild(_spContainer);
            _spContainer =  Sprite(_spContainer.addChild(new Sprite));
            _spContainer.addChild(_shpHour);
            _spContainer.addChild(_shpMin);
            _spContainer.addChild(dot);
            
            _spContainer.rotation = 180;
            
            // hand
            _hand = new Hand();
            _spContainer.addChild(_hand);
            
            // create first hairs
            for (var j:int = 0; j < _cnt; j++) 
            {
                createHair(_nose);
            }
            
            onTimer(null);
        }
        
        private function drawTrapezium($graphics:Graphics, $right:Number, $top:Number, $left:Number, $bottom:Number):void {
            $graphics.drawPath(_pathCommands, Vector.<Number>([
                $left, $bottom, -$left, $bottom, -$right, $top, $right, $top, $left, $bottom
            ]));
        }
        
        private function onTimer(e:TimerEvent):void {
            var time:Date = new Date;
            var sec:int = time.getSeconds();
            
            // multiply minus 1 because of _spContainer's rotation 180
            _hand.x =  -1 * _noseHairs[0].x;
            _hand.y =  _noseY - _noseHairs[0].height -10;
    
            if (_sec == sec) return;
            
            _sec = sec;
            updateView(time.getHours(), time.getMinutes(), sec);
            
        }
        
        private function updateView($hour:int, $min:int, $sec:int):void {
            _shpHour.rotation = ($hour % 12) * 30 + $min / 2;
            _shpMin.rotation = $min * 6;
            
            // first time
            if (_first) {
                for (var i:int = 1; i < _sec; i++) 
                {
                    var radian:Number = (i * 6 + 90) * Math.PI / 180;
                    var x:Number =  _radius * Math.cos(radian);
                    var y:Number =  _radius * Math.sin(radian);
                    putHair(i, x, y);
                }
                _first = !_first;
            }
            
            // if second == 0
            if (_sec == 0) {
                // canvas of blood
                if (!_canvas) {
                    _canvas = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00FFFFFF);
                    var bmp:Bitmap = new Bitmap(_canvas);
                    addChild(bmp);
                }
                
                for (var j:int = 0; j < _bloodNum; j++) {
                    createBlood();
                };
                
                addEventListener(Event.ENTER_FRAME, onBloodEnterFrame);
                
                var bTimer:Timer = new Timer(8000, 1);
                bTimer.addEventListener(TimerEvent.TIMER_COMPLETE, onBloodTimer);
                bTimer.start();
                
                // hand
                _hand.visible = false;
                
                // take hair off
                var len:int = _clockHairs.length;
                for (var k:int = 0; k < len; k++) 
                {
                    var h:NoseHair = _clockHairs[k];
                    var htw:ITween=BetweenAS3.tween(h, {
                        y : h.y - Math.random() * 30,
                        x : h.x + Math.random() * 5 - 10,
                        alpha:0
                        }, null, 4);
                    htw.play();
                    htw.addEventListener(TweenEvent.COMPLETE, onHairComplete);                                
                }
                _clockHairs = [];
                
                return;
            }
            
            // +90
            var radian:Number = (_sec * 6 + 90) * Math.PI / 180;
            
            // hand position
            _hand.x =  _radius * Math.cos(radian);
            _hand.y =  _radius * Math.sin(radian);
            _hand.visible = true;
            putHair(_sec, _hand.x, _hand.y);
        }
        
        /**
         * remove hairs
         *
         */
        private function onHairComplete(e:TweenEvent):void 
        {
            var h:NoseHair = e.target.target;
            _spContainer.removeChild(h);
            h = null;
        }
        
        /**
         * put hairs on clock
         *
         */
        private function putHair(sec:int, x:Number, y:Number):void {
            // set hair on Clock
            var h:NoseHair = _noseHairs.shift();
            _spContainer.addChild(h);
            
            h.x = x + Math.random() * 5 - 10;
            h.y = y + Math.random() * 5 - 10;
            h.rotation = sec * 6;
            
            _clockHairs.push(h);
            h = null;
            
            // create hair on nose
            createHair(_nose);
        }
        
        /**
         * 　create hairs
         *
         */
        private function createHair(target:Nose):void {
            var y:int = 15;
            var dy:int = y + 10;
            var tweenTime:Number = 1;
            var h:NoseHair = new NoseHair();
            
            // if it's first time, don't be tweened 
            if (_first) {
                y = dy;
                tweenTime = 0;
            }
            
            if (_nosePosition == "left") {
                h.x = Math.random() * 18 - 42;
                _nosePosition = "right";
            }else {
                h.x = Math.random() * 18 + 19;
                _nosePosition = "left";
            }
            
            target.addChildAt(h,0);
            _noseHairs.push(h);
            
            // hair appearance 
            BetweenAS3.tween(h, { y : dy }, { y : y }, tweenTime).play();
        }
        
        /**
         * 　onBloodEnterFrameHandler
         *
         */
        private function onBloodEnterFrame(e:Event):void 
        {
            _canvas.lock();
            _canvas.colorTransform(_canvas.rect, _ctf);
            
            for (var i:int = 0; i < _bloodNum; i++) {
                var mat:Matrix = new Matrix();
                mat.translate(_bloodArr[i].x, _bloodArr[i].y);
                _canvas.draw(_bloodArr[i], mat);
                _bloodArr[i].update();
            };    
            _canvas.unlock();
        }
        
        /**
         * blood complete
         *
         */
        private function onBloodTimer(e:TimerEvent):void 
        {
            removeEventListener(Event.ENTER_FRAME, onBloodEnterFrame);
            
            for (var i:int = 0; i < _bloodNum; i++) {
                removeChild(_bloodArr[i]);
                _bloodArr[i] = null;
            };    
            _bloodArr = [];
            //_canvas.floodFill(0, 0, 0x00FFFFFF);
        }
        
        
        /**
         * create paricle
         *
         */
        private function createBlood():void
        {
            var radian:Number = Math.random() * Math.PI * 2;
            var dx:Number = Math.cos(radian) * 0.4;
            var dy:Number = Math.abs(Math.random() * 0.4 - 0.8);
            
            // particle
            var b:Blood = new Blood();
            
            if (_nosePosition == "left") {
                b.x = 205;
                _nosePosition = "right";
            }else {
                b.x = 259;
                _nosePosition = "left";
            }
            
            b.y = _bloodY;
            addChild(b);
            
            _bloodArr.push(b);
            
            b.dx = dx;
            b.dy = dy;
        }
        
    }
}

/**
  * Nose
  *
  */
import flash.display.Shape;
import flash.display.Sprite;
internal class Nose extends Sprite
{   
   /**
    * Constructor
    * 
    */
    public function Nose() {
        var offset:int = 24;
        var r:int = 20;
        var cx:int = 30;
        var bcolor:int = 0xF6DCBE;
        
        addChild(createNose(offset, r, bcolor));
        addChild(createNose(offset * -1, r * -1, bcolor));
        
        // hide
        var hideSh:Shape = new Shape();
        hideSh.graphics.beginFill(bcolor);
        hideSh.graphics.drawCircle(0, 0, 23);
        hideSh.graphics.endFill();
        addChild(hideSh);
        
        addChild(createHall(cx));
        addChild(createHall(cx * -1));
        
        
    }
    
    private function createNose(offset:int, r:int, c:int):Shape {
        var h:int = 48;
        var w:int = 80;
        var lcolor:int = 0x999999;
        
        var n:Shape = new Shape();
        n.graphics.lineStyle(2, lcolor);
        n.graphics.beginFill(c);
        n.graphics.drawEllipse( -w / 2 + offset, -h / 2, w, h);
        n.graphics.endFill();
        n.rotation = r;
        
        return n;
    }
    
    private function createHall(cx:int):Shape {
        var cy:int = 13;
        var rx:int = 30;
        var ry:int = 25;
        
        var h:Shape = new Shape();
        h.graphics.beginFill(0x000000);
        //h.graphics.drawCircle(cx, cy, r);
        h.graphics.drawEllipse(cx - rx / 2, cy, rx, ry);
        h.graphics.endFill();
        return h;
    }
}

/**
  * NoseHair
  *
  */
internal class NoseHair extends Sprite
{
   /**
    * Constructor
    * 
    */
    public function NoseHair() {
        var h:int = Math.round(Math.random() * 10 + 15);
        var w:Number = 1;
        var cx:Number = Math.round(Math.random() * 20 - 5);
        var cy:Number = Math.round(Math.random() * 20 - 5);
        var r:Number = 1.5;
        
        graphics.lineStyle(w);
        graphics.curveTo(cx, cy, 0, h);
        graphics.endFill();
        graphics.beginFill(0x000000);
        graphics.drawCircle(w / 2, 0, r);
        graphics.endFill();
        
        rotation = Math.random() * 20 - 10;
    }
}

/**
  * Finger
  *
  */
internal class Hand extends Sprite
{   
    /**
     * Constructor
     *
     */
    public function Hand() {        
        var bColor:int = 0xF6DCBE;
        var lColor:int = 0x555555;
        
        var s:Shape = new Shape();
        s.graphics.beginFill(bColor);
        s.graphics.lineStyle(2, lColor);
        s.graphics.moveTo(0, 0);
        s.graphics.lineTo(-7, -6);
        s.graphics.curveTo( -48, -14, -28, -40);
        s.graphics.lineStyle(0, 0xFF0000, 0);
        s.graphics.endFill();

        s.graphics.beginFill(bColor);
        s.graphics.moveTo( -29, -23);
        s.graphics.lineStyle(2, lColor);
        s.graphics.curveTo( -34, -40, -24, -44);
        s.graphics.lineStyle(0, 0xFF0000, 0);
        s.graphics.endFill();

        s.graphics.beginFill(bColor);
        s.graphics.moveTo( -24, -23);
        s.graphics.lineStyle(2, lColor);
        s.graphics.curveTo( -30, -40, -17, -48);
        s.graphics.lineStyle(0, 0xFF0000, 0);
        s.graphics.endFill();

        s.graphics.beginFill(bColor);
        s.graphics.moveTo( -20, -24);
        s.graphics.lineStyle(2, lColor);
        s.graphics.curveTo( -25, -48, -7, -52);
        s.graphics.curveTo( -2, -45, -10, -42);
        s.graphics.curveTo( -22, -28, -7, -25);
        s.graphics.lineStyle(0, 0xFF0000, 0);

        s.graphics.lineStyle(2, lColor);
        s.graphics.curveTo( -1, -24, -3, -34);
        s.graphics.curveTo( -7, -60, 7, -34);
        s.graphics.lineTo(8, -18);
        s.graphics.lineTo(13, -14);
        s.graphics.lineStyle(0, 0xFF0000, 0);
        s.graphics.lineTo(0, 0);
        s.graphics.endFill();
        
        s.rotation = 180;
        s.y = s.y - s.height / 1.5;
        addChild(s);
    }
}

/**
  * Blood
  *
  */
internal class Blood extends Sprite
{
    public var dx:Number;
    public var dy:Number;
    
    /**
     * Constructor
     *
     */
    public function Blood() {
        graphics.beginFill(0xFF0000);
        graphics.drawCircle(0, 0, 10);
        graphics.endFill();
    }
    
    /**
     * update
     *
     */
    public function update():void
    {        
        x += dx * 10;
        y += dy * 10;
    }
    
}
