/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vsXe
 */



package  
{
    import flash.display.*
    import flash.events.*
    import flash.geom.*
    import flash.ui.*
        
    //[SWF(backgroundColor="0xFFFFFF",width="800",height="800",frameRate="30")]


    public class Main extends Sprite 
    {
        public  var _pp:PerspectiveProjection;
        public  var stageDepth:Number  =  30;
        private var particles:Array;
        private var numParticles:uint = 6;
        private var minDist:Number = 200;
        private var springAmount:Number =  .006;
     
        public function Main() 
        {
            init();
        }
        
     
        private function init():void 
        {
          //_pp =  
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            // ENTRY POINT:
            
            particles = new Array();
            for (var i:uint = 0; i < numParticles; i++) {
                var size:Number = Math.random() * 10 + 2;
                var particle:Ball = new Ball(size);
                particle.x = Math.random() * stage.stageWidth;
                particle.y = Math.random() * stage.stageHeight;
                particle.z = Math.random() * stageDepth;
                particle.vx = Math.random() * 2 - 1;
                particle.vy = Math.random() * 2 - 1;
                particle.vz = Math.random() * 2 - 1;
                particle.mass = size;
                addChild(particle);
                particles.push(particle);
            }

            addEventListener(Event.ENTER_FRAME, onEnterFrame);            
        }

        
        private function onEnterFrame(event:Event):void 
        {
            for (var i:uint = 0; i < numParticles; i++) 
            {
                var particle:Ball = particles[i];
                particle.x += particle.vx;
                particle.y += particle.vy;
                particle.z += particle.vz;
                border(particle);
            }
            graphics.clear();

            for (i = 0; i < numParticles - 1; i++ ) 
            {
                var partA:Ball = particles[i];
                for (var j:uint = i + 1; j < numParticles; j++ ) 
                {
                    var partB:Ball = particles[j];
                    spring(partA, partB);
                }
            }                    
        }

        
        private function spring(partA:Ball, partB:Ball):void 
        {
            var dx:Number = partB.x - partA.x;
            var dy:Number = partB.y - partA.y;
            var dz:Number = partB.z - partA.z;
            var distSQ:Number  =  dx * dx + dy * dy + dz * dz;
            var dist:Number  =  Math.sqrt( distSQ );
/*            var distSQ:Number = dx * dx + dy * dy;
            var dist:Number = Math.sqrt(distSQ);
            var distSQ3D:Number = dx * dx + dy * dy + dz * dz;
            var dist3D:Number = Math.sqrt( distSQ3D );
*/
            if (dist < minDist) 
            {
                var _microLOC_A:Vector3D = new Vector3D( partA.x,partA.y,partA.z );
                var _microLOC_B:Vector3D = new Vector3D( partB.x,partB.y,partB.z );
                var _macroLOC_A = this.local3DToGlobal(  _microLOC_A  );
                var _macroLOC_B = this.local3DToGlobal(  _microLOC_B  );
               
                graphics.lineStyle(1.5,0x0066ff,1-dist/minDist);
                graphics.moveTo(_macroLOC_A.x, _macroLOC_A.y);
                graphics.lineTo(_macroLOC_B.x, _macroLOC_B.y);
                //graphics.moveTo(partA.x, partA.y); 
                //graphics.lineTo(partB.x, partB.y);
              
                var ax:Number = dx * springAmount;
                var ay:Number = dy * springAmount;
                var az:Number = dz * springAmount; 
                partA.vx += ax / partA.mass;
                partA.vy += ay / partA.mass;
                partA.vz += az / partA.mass;
                partB.vx -= ax / partB.mass;
                partB.vy -= ay / partB.mass;
                partB.vz -= az / partB.mass;
            }
            
        }
        private function border(particle:Ball):void {
            if (particle.x > stage.stageWidth) {
                particle.x = 0;
            }else if (particle.x < 0) {
                particle.x = stage.stageWidth;    
            }
            if (particle.y > stage.stageHeight) {
                particle.y = 0;
            }else if (particle.y < 0) {
                particle.y = stage.stageHeight;    
            }
        }
        /*
        private function gravitate(partA:Ball, partB:Ball):void {
            var dx:Number = partB.x - partA.x;
            var dy:Number = partB.y - partA.y;
            var distSQ:Number = dx * dx + dy * dy;
            var dist:Number = Math.sqrt(distSQ);
            var force:Number = partA.mass * partB.mass / distSQ;
            var ax:Number = force * dx / dist;
            var ay:Number = force * dy / dist;
            partA.vx += ax / partA.mass;
            partA.vy += ay / partA.mass;
            partB.vx -= ax / partB.mass;
            partB.vy -= ay / partB.mass;
        }
        */
    }    
}






import flash.display.Sprite;

class Ball extends Sprite 
{
    public var _radius:Number;
    public var _color:uint;
    public var _alpha:Number;
    public var mass:Number = 0;    
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var vz:Number = 0;

    
    public function Ball(radius:Number = 25, color:uint = 0x0066FF, alpha:Number = .3 ) 
    {
        this._radius = radius;
        this._color = color;
        this._alpha = alpha; 
        this.mass = radius * 40;
            
        init();      
    }
      
        
    private function init():void
     {
        graphics.beginFill(_color, _alpha);
        graphics.drawCircle(0, 0, _radius);
        graphics.endFill();
        graphics.beginFill(_color, _alpha);
        graphics.drawCircle(0, 0, _radius*2);
        graphics.endFill();            
    }
}
