/**
 * Copyright buccchi ( http://wonderfl.net/user/buccchi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vrzc
 */

// forked from checkmate's Checkmate vol.5 Amateur
/*
 * マウスで蝶を操作。犬が追いかけるよ！
 *  上：蝶を奥へ
 *  下：蝶を手前へ
 *  左：蝶を左へ
 *  右：蝶を右へ
 */
package {
	import flash.display.*;
	import flash.events.Event;
	
	public class Amateur extends Sprite {
		private const FOCUS:Number = 400;
		private const WIDTH:Number = stage.stageWidth;
		private const HEIGHT:Number = stage.stageHeight;
		private const DIS_X:Number = stage.stageWidth*.5;
		private const DIS_Y:Number = 300;
		private var _butterfly:Hae;
		private var _wanco:Wanco;
		private var _shadow:Shadow;
		private var _camera:MyStatus;
		
		public function Amateur(){
			super();
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			_butterfly = new Hae(WIDTH, HEIGHT);
			addChild(_butterfly);
			
			_shadow = new Shadow(30);
			addChild(_shadow);
			
			_wanco = new Wanco(_butterfly);
			addChild(_wanco);
			
			_camera = new MyStatus(DIS_X, 50, -100);
			addChild(_camera);
			
			addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
		}
		
		private function onEnterFrameHandler(e:Event):void {
			//2.5Dに変換
			var ratio:Number;
			//蝶
			ratio = FOCUS / (_butterfly.myZ-_camera.myZ);
			_butterfly.x = (_camera.myX-_butterfly.myX) *ratio +DIS_X;
			_butterfly.y = (_camera.myY-_butterfly.myY) *ratio +DIS_Y;
			_butterfly.scaleX = _butterfly.scaleY = ratio;
			//犬
			ratio = FOCUS / (_wanco.myZ-_camera.myZ);
			_wanco.x = (_camera.myX-_wanco.myX) *ratio +DIS_X;
			_wanco.y = (_camera.myY-_wanco.myY) *ratio +DIS_Y;
			_wanco.scaleX = _wanco.scaleY = ratio;
			//影
			_shadow.x = _wanco.x;
			_shadow.y = (_camera.myY) *ratio +DIS_Y;
			_shadow.scaleX = ratio;
			_shadow.scaleY = ratio*ratio/10;
		}
	}
}

import flash.display.Sprite;
import flash.events.Event;

class MyStatus extends Sprite{
	public var myX:Number;
	public var myY:Number;
	public var myZ:Number;
	
	public function MyStatus(mX:Number=0, mY:Number=0, mZ:Number=0){
		myX = mX;
		myY = mY;
		myZ = mZ;
	}
}

//影
class Shadow extends Sprite {
	public function Shadow(r:Number){
		graphics.beginFill(0xDDDDDD, 1);
		graphics.drawCircle(0, -30, r);
	}
}

//蝶
class Hae extends MyStatus {
	private var _w:Number;
	private var _h:Number;
	private var _hane:Sprite;
	private var _rad:Number = 0;		//回転角
	private var _radius:Number = 20;	//回転半径
	private var _base:Object;			//基準位置
	
	public function Hae(w:Number, h:Number){
		super();
		_w = w;
		_h = h;
		_base = {x:0, y:110, z:0};
		myY = _base.y;
		//蝶を描画
		_hane = new Sprite();
		_hane.graphics.beginFill(0x999999, 1);
		_hane.graphics.drawCircle(-2.5, -1, 2);
		_hane.graphics.beginFill(0x999999, 1);
		_hane.graphics.drawCircle(2.5, -1, 2);
		addChild(_hane);
		graphics.beginFill(0x000000, 1);
		graphics.drawCircle(0, 0, 1.5);
		//
		addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
	}
	
	private function onEnterFrameHandler(e:Event):void {
		_base.x += (_w-stage.mouseX-myX)*.1;
		_base.z += (_h*2-stage.mouseY*2-myZ)*.1;
		_rad = (_rad <= 0)? _rad-.15+(Math.PI*2) : _rad-.15;
		myX = _base.x + Math.cos(_rad)*_radius;
		myZ = _base.z + Math.sin(_rad)*_radius;
		//はばたきアニメーション
		_hane.alpha = (_hane.alpha==1)? .4 : 1;
	}
}

import flash.display.*;
import flash.events.*;
import flash.utils.*;
import flash.net.*;
import flash.system.*;
import jp.progression.commands.*;
import jp.progression.commands.lists.*;
import jp.progression.commands.display.*;
import jp.progression.commands.net.*;
import jp.progression.commands.tweens.*;
import jp.progression.events.*;

import org.libspark.betweenas3.BetweenAS3;
import org.libspark.betweenas3.easing.*;
import org.libspark.betweenas3.tweens.ITween;
import org.libspark.betweenas3.events.TweenEvent;

class Wanco extends MyStatus {
	public static var GRAPHICS_URL:String = "http://swf.wonderfl.net/static/assets/checkmate05/wancoAmateur.swf";
	private var stayMotion:MovieClip;
	private var _mark:MyStatus;
	private var _base:Object;	//基準位置
	private var _local:Object;	//ローカル位置
	
	public function Wanco(hae:MyStatus){
		super();
		_mark = hae;
		_base = {x:0, y:0, z:0};
		_local = {x:0, y:0, z:0};
		
		var com:SerialList = new SerialList();
		com.addCommand(
			new LoadSWF( new URLRequest( GRAPHICS_URL ) ),
			function():void {
				var loader:Loader = Loader( this.latestData );
				var domain:ApplicationDomain = loader.contentLoaderInfo.applicationDomain;
				
				stayMotion = new ( domain.getDefinition( "StayMotion" ) as Class );
			}
		);
		com.addEventListener(ExecuteEvent.EXECUTE_COMPLETE,onLoadSWF);
		com.execute();
	}
	
	private function onLoadSWF(e:Event):void {
		addChild(stayMotion as MovieClip);
		addEventListener(Event.ENTER_FRAME, onEnterFrameHandler);
		//ジャンプアニメーション設定
		var t:ITween =	BetweenAS3.parallel(
							BetweenAS3.serial(
								BetweenAS3.tween(stayMotion, { scaleX:.8, scaleY:1.2 }, { scaleX:1.1, scaleY:.8 }, .25, Sine.easeOut),
								BetweenAS3.tween(stayMotion, { scaleX:1.1, scaleY:.8 }, null, .75, Sine.easeOutIn)
							),
							BetweenAS3.serial(
								BetweenAS3.tween(_local, { y:50 }, null, .5, Sine.easeOut),
								BetweenAS3.tween(_local, { y:0 }, null, .5, Sine.easeIn)
							)
						);
		t = BetweenAS3.scale(t, .8);
		t.stopOnComplete = false;
		t.play();
	}
	
	private function onEnterFrameHandler(e:Event):void {
		_base.x += (_mark.myX-_base.x)*.05;
		_base.z += (_mark.myZ-_base.z)*.05;
		myX = _base.x;
		myY = _local.y;
		myZ = _base.z;
		//向き変更
		var myRotate:Number = Math.atan2(_base.x-_mark.myX, _base.z-_mark.myZ) *180 /Math.PI + 360+30;
		var frame:Number = Math.floor(myRotate%360/18)+1;
		stayMotion.wc2.wc3..gotoAndStop(frame);
	}
}
