/**
 * Copyright arithma ( http://wonderfl.net/user/arithma )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vrAy
 */

package
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.events.KeyboardEvent;
    import flash.geom.ColorTransform;
    import flash.ui.Keyboard;
    
    public class pong extends Sprite
    {
        private var paddle1:Sprite;
        private var paddle2:Sprite;
        private var ball:Sprite;
        private var speed_x:Number;
        private var speed_y:Number;
        
        private var player1Left:Boolean;
        private var player1Right:Boolean;
        private var player2Left:Boolean;
        private var player2Right:Boolean;
        
        private var speed1:Number;
        private var speed2:Number;
        
        private var score:Sprite;
        private var val:Number;
        
        private var indicator1:Sprite;
        private var indicator2:Sprite;
        
        public function pong()
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.frameRate = 120;
            paddle1 = createPaddle();
            paddle2 = createPaddle();
            indicator1 = createIndicator();
            indicator2 = createIndicator();
            ball = createBox();
            score = new Sprite();
            score.x = stage.stageWidth - 5;
            val = 0;
            
            paddle1.y = stage.stageHeight - paddle1.height;
            indicator1.y = stage.stageHeight - indicator1.height;
            
            addChild(indicator1);
            addChild(indicator2);
            addChild(paddle1);
            addChild(paddle2);
            addChild(ball);
            addChild(score);
            set_score(0);
            
            
            speed_x = 3;
            speed_y = 5;
            
            speed1 = 0;
            speed2 = 0;
            
            addEventListener(Event.ENTER_FRAME, frame);
            stage.addEventListener(KeyboardEvent.KEY_DOWN, _keyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, _keyUp);
        }
        
        private function frame(e:Event):void{
            var fac1:Number;
            var fac2:Number;
            if(Math.abs(speed1) > 6)
                fac1 = 1;
            else
                fac1 = .1 + .9 * Math.abs(speed1) / 6;
            
            if(Math.abs(speed2) > 6)
                fac2 = 1;
            else
                fac2 = .1 + .9 * Math.abs(speed2) / 6;
            
            if(player1Right)
                speed1 += 2 * fac1;
            if(player1Left)
                speed1 -= 2 * fac1;
            if(player2Right)
                speed2 += 2 * fac2;
            if(player2Left)
                speed2 -= 2 * fac2;
            
            speed1 -= .03 * Math.abs(speed1) * speed1 + .05 * speed1;
            speed2 -= .03 * Math.abs(speed2) * speed2 + .05 * speed2;
            
            paddle1.x += speed1 * 2;
            paddle2.x += speed2 * 2;
            
            if(paddle1.x < 0){
                speed1 = 0;
                paddle1.x = 0;
            }
            if(paddle2.x < 0){
                speed2 = 0;
                paddle2.x = 0;
            }
            if(paddle1.x > stage.stageWidth - paddle1.width){
                speed1 = 0;
                paddle1.x = stage.stageWidth - paddle1.width;
            }
            if(paddle2.x > stage.stageWidth - paddle2.width){
                speed2 = 0;
                paddle2.x = stage.stageWidth - paddle2.width;
            }
                        
            if(ball.x > stage.stageWidth - ball.width && speed_x > 0){
                ball.x = stage.stageWidth - ball.width;
                speed_x = -.4*speed_x;
            }
            if(ball.x < 0 && speed_x < 0){
                ball.x = 0;
                speed_x = -.4*speed_x;
            }
            if(ball.y > stage.stageHeight - ball.height && speed_y > 0){
                ball.y = stage.stageHeight - ball.height;
                speed_y = -speed_y;
                if(ball.x < paddle1.x + paddle1.width && ball.x > paddle1.x){
                    speed_x -= (ball.x - (paddle1.x+paddle1.width*.5)) * .1;
                    speed_y -= 2.5;
                    speed_y *= .8;
                }
                else{
                    indicator1.transform.colorTransform = new ColorTransform(0, 1, 0);
                    val -= 1;
                    speed_y -= .5;
                    speed_y *= .6;
                    set_score(val);
                }
            }
            if(ball.y < 0 && speed_y < 0){
                ball.y = 0;
                speed_y = -speed_y;
                if(ball.x < paddle2.x + paddle2.width && ball.x > paddle2.x){
                    speed_x -= (ball.x - (paddle2.x+paddle2.width*.5)) * .1;
                    speed_y += 2.5;
                    speed_y *= .8;
                }
                else{
                    indicator2.transform.colorTransform = new ColorTransform(1, 0, 0);
                    val+= 1;
                    speed_y += .5;
                    speed_y *= .6;
                    set_score(val);
                }
            }
            
            ball.x += speed_x * 2;
            ball.y += speed_y * 2;
            var ct1:ColorTransform = indicator1.transform.colorTransform;
            var ct2:ColorTransform = indicator2.transform.colorTransform;
            ct1.redMultiplier = ct1.redMultiplier * .9 + .1;
            ct1.greenMultiplier = ct1.greenMultiplier * .9 + .1;
            ct1.blueMultiplier = ct1.blueMultiplier * .9 + .1;
            ct2.redMultiplier = ct2.redMultiplier * .9 + .1;
            ct2.greenMultiplier = ct2.greenMultiplier * .9 + .1;
            ct2.blueMultiplier = ct2.blueMultiplier * .9 + .1;
            indicator1.transform.colorTransform = new ColorTransform();
            indicator1.transform.colorTransform = ct1;
            indicator2.transform.colorTransform = new ColorTransform();
            indicator2.transform.colorTransform = ct2;
            
            trace(indicator1.transform.colorTransform);
        }
        
        private function set_score(value:Number):void{
            score.graphics.clear();
            score.graphics.beginFill(0xFF0000);
            score.graphics.drawRect(0, 0, 10, stage.stageHeight * .5 - value * 40);
            score.graphics.endFill();
            
            score.graphics.beginFill(0x00FF00);
            score.graphics.drawRect(0, stage.stageHeight * .5 - value * 40, 10, stage.stageHeight * .5 + value * 40);
            score.graphics.endFill();
        }
        
        private function _keyDown(e:KeyboardEvent):void{
            if(e.keyCode == "A".charCodeAt())
                player2Left = true; 
            if(e.keyCode == "D".charCodeAt())
                player2Right = true; 
            if(e.keyCode == Keyboard.RIGHT)
                player1Right = true; 
            if(e.keyCode == Keyboard.LEFT)
                player1Left = true; 
        }
        
        private function _keyUp(e:KeyboardEvent):void{
            if(e.keyCode == "A".charCodeAt())
                player2Left = false; 
            if(e.keyCode == "D".charCodeAt())
                player2Right = false; 
            if(e.keyCode == Keyboard.RIGHT)
                player1Right = false; 
            if(e.keyCode == Keyboard.LEFT)
                player1Left = false; 
        }
        
        private function createPaddle():Sprite{
            var paddle:Sprite = new Sprite();
            paddle.graphics.beginFill(0);
            paddle.graphics.drawRect(0, 0, 180, 5);
            paddle.graphics.endFill();
            
            return paddle;
        }
        
        private function createIndicator():Sprite{
            var sprite:Sprite = new Sprite();
            sprite.graphics.beginFill(0xFFFFFF);
            sprite.graphics.drawRect(0, 0, stage.stageWidth, 5);
            sprite.graphics.endFill();
            
            return sprite;
        }
        
        private function createBox():Sprite{
            var box:Sprite = new Sprite();
            box.graphics.beginFill(0);
            box.graphics.drawRect(0, 0, 5, 5);
            box.graphics.endFill();
            
            return box;
        }
    }
}