/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vr0s
 */

// forked from bongiovi015's flash on 2011-9-8
package
{
    import caurina.transitions.Tweener;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.Loader;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import flash.system.Security;
    import flash.text.TextField;
    import flash.text.TextFormat;

    public class WonderParticles0 extends Sprite {
        public const CIRCLE_SIZE : int = 4;
        public const MAX_DISPLACE : int = 800;
        public var W:int;
        public var H:int;
        public var _lc:LoaderContext = new LoaderContext(true);
        public var loaderImage : Loader = new Loader;
        private var bmpdText:BitmapData;
        private var bmpdPerlin:BitmapData;
        private var spMask:Sprite = new Sprite;
        private var particles:Array = [];
        private var isOpen:Boolean = true;
        private var bmp:Bitmap;

        public var seed:int = Math.floor(Math.random() * 0xFFFF);
        public var offset:Array = [new Point, new Point];
        public var perlinOffset : Number = MAX_DISPLACE;
        
        public function WonderParticles0(){
            var mtx:Matrix = new Matrix;
            mtx.createGradientBox(465, 465);
            graphics.beginGradientFill(GradientType.RADIAL, [0x333333, 0x111111], [1, 1], [0, 255], mtx);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            loaderImage.contentLoaderInfo.addEventListener(Event.COMPLETE, _imgLoaded);
            //"http://www.whatsonyourwall.com/abstract-art-5/abstract-gradient-colour-size-square-18751-36434_medium.jpg"
            //loaderImage.load(new URLRequest( "http://whatsonyourwall.com/abstract-art-5/abstract-gradient-colour-size-square-18751-36434_medium.jpg" ), _lc);
            loaderImage.load(new URLRequest( "http://www.bongiovi.tw/wonderfl/paintbg.jpg"), _lc);
            //loaderImage.load(new URLRequest("http://www.bongiovi.tw/wonderfl/paintbg.jpg"), new LoaderContext(true));
        }
        
        
        private function _imgLoaded(e:Event) : void {
            //var _bmd:BitmapData = new BitmapData(465,465,false,0x999999);
            //bmp = Bitmap( _bmd );
            bmp = Bitmap(loaderImage.content);
            addChild(bmp);
            _createText();
            W = bmpdText.width;
            H = bmpdText.height;
            spMask.x = (465 - W) * .5;
            spMask.y = (465 - H) * .5;
            bmpdPerlin = new BitmapData(W/2, H/2, false);
            _createParticles();
            
            addChild(spMask);
            bmp.mask = spMask;
            
            addEventListener(Event.ENTER_FRAME, render);
            stage.addEventListener(MouseEvent.CLICK, _onClick);
            _onClick();
        }
        
        
        public function render(e:Event=null) : void {
            bmpdPerlin.perlinNoise(W/2, H/2, 4, seed, false, true, 7, false, offset);
            spMask.graphics.clear();
            
            for each(var p:Particle in particles) {
                spMask.graphics.beginFill(0xFFFFFF, 1);
                var tx:Number = p.x;
                var ty:Number = p.y;
                var color:uint = bmpdPerlin.getPixel(tx/2, ty/2);
                var r:Number = ((color >> 16 & 0xFF) / 0xFF - .5) * perlinOffset;
                var g:Number = ((color >> 8 & 0xFF) / 0xFF - .5) * perlinOffset;
                var b:Number = Math.floor((color & 0xFF) / 0xFF * 100) / 100;
                b = Math.pow(b, 2);
                tx += r*2;
                ty += g*3;
                spMask.graphics.drawCircle(tx, ty, CIRCLE_SIZE * b * (1 - perlinOffset / MAX_DISPLACE) * 2);                    
                spMask.graphics.endFill();
            }
            
            
            const SPEED:int = 2;
            offset[0].x += SPEED;
            offset[1].y += SPEED;
        }
        
        
        private function _onClick(e:MouseEvent=null) : void {
            const duration : Number = 3;
            if(isOpen) Tweener.addTween(this, {time:duration, transition:"easeOutCubic", perlinOffset:1});
            else Tweener.addTween(this, {time:duration/2, transition:"easeInCubic", perlinOffset:MAX_DISPLACE});
            
            isOpen = !isOpen;
        }
        
        
        private function _createParticles():void 
        {
            var i:int;
            var j:int;
            /*var k:int;
            
            for(k=0;k<H; k+=CIRCLE_SIZE/2) 
            {*/
                for(j=0;j<H; j+=CIRCLE_SIZE/2) 
                {
                    for(i=0;i<W; i+=CIRCLE_SIZE/2) 
                    {
                        var color:uint = bmpdText.getPixel32(i, j);
                        if( (color >> 24 & 0xFF) > 0x1F) {
                            var p:Particle = new Particle;
                            p.x = i;
                            p.y = j;
                            //p.z = k;
                            particles.push(p);
                        } 
                        
                    }                
                }
          /*}*/
        }
        
        private function _createText():void {
            var tf:TextField = new TextField;
            var format:TextFormat = new TextFormat("Arial Black", 60, 0xFFFFFF);
            tf.defaultTextFormat = format;
            tf.text = "[BradSedito]";
            tf.autoSize = "left";
            bmpdText = new BitmapData(tf.width, tf.height, true, 0);
            bmpdText.draw(tf);
        }
    }
}


class Particle 
{
    public var x : Number = 0;
    public var y : Number = 0;
    public var z : Number = 0;
    
    public function Particle():void 
    { 
        
    }
}

