/**
 * Copyright cjcat2266 ( http://wonderfl.net/user/cjcat2266 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vqyP
 */

package {
    import flash.display.AVM1Movie;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;  
    import flash.events.Event;
    
    /**
     * Bresenham's line algorithm
     * http://en.wikipedia.org/wiki/Bresenham's_line_algorithm
     */
    public class Main extends Sprite {
        
        private const RADIUS:Number = 30;
        private const OMEGA:Number = 0.06;
        private const HALF_PI:Number = 0.5 * Math.PI;
        
        private var phase:Number = 0;
        
        private var bmpd:BitmapData;
        private var bmp:Bitmap;
               
        public function Main() {
            bmpd = new BitmapData(117, 117, false, 0x000000);
            bmp = new Bitmap(bmpd);
            bmp.scaleX = bmp.scaleY = 4;
            addChild(bmp);
            
            addEventListener(Event.ENTER_FRAME, mainLoop);
        }
        
        private function mainLoop(e:Event):void {
            bmpd.lock();
            
            bmpd.fillRect(bmpd.rect, 0x000000);
            
            var cx:Number = 0.25 * stage.mouseX;
            var cy:Number = 0.25 * stage.mouseY;
            var line0x0:Number = cx + RADIUS * Math.cos(phase);
            var line0y0:Number = cy + RADIUS * Math.sin(phase);
            var line0x1:Number = cx - RADIUS * Math.cos(phase);
            var line0y1:Number = cy - RADIUS * Math.sin(phase);
            var line1x0:Number = cx + RADIUS * Math.cos(phase + HALF_PI);
            var line1y0:Number = cy + RADIUS * Math.sin(phase + HALF_PI);
            var line1x1:Number = cx - RADIUS * Math.cos(phase + HALF_PI);
            var line1y1:Number = cy - RADIUS * Math.sin(phase + HALF_PI);
            
            drawLine(line0x0, line0y0, line0x1, line0y1, 0xFFFF00, false, bmpd);
            drawLine(line1x0, line1y0, line1x1, line1y1, 0xFFFF00, false, bmpd);
            drawCircle(cx, cy, RADIUS, 0xFFFF00, false, bmpd);
            
            phase += OMEGA;
            
            bmpd.unlock();
        }

                
        private function drawLine(x0:int, y0:int, x1:int, y1:int, color:uint, useAlpha:Boolean, target:BitmapData):void {
            var dx:int = x1 - x0;
            var dy:int = y1 - y0;
            var sx:int = (dx >= 0)?(1):(-1);
            var sy:int = (dy >= 0)?(1):( -1);
            dx = (dx >= 0)?(dx):(-dx);
            dy = (dy >= 0)?(dy):(-dy);
            var err:int = dx - dy, e2:int;
            
            if (!useAlpha) color |= 0xFF000000
            while (true) {
                target.setPixel32(x0, y0, color);
                
                if ((x0 == x1) && (y0 == y1)) break;
                
                e2 = err << 1;
                if (e2 > -dy) {
                    err -= dy;
                    x0 += sx;
                }
                if (e2 < dx) {
                    err += dx;
                    y0 += sy;
                }
            }
        }
        
        private function drawCircle(cx:int, cy:int, radius:Number, color:uint, useAlpha:Boolean, target:BitmapData):void {
            var r:int = int(radius + 0.5);
            var error:int = -r;
            var x:int = r;
            var y:int = 0;
            
            if (!useAlpha) color |= 0xFF000000
            while (x >= y) {
                target.setPixel32(cx + x, cy + y, color);
                if (x != 0) target.setPixel32(cx - x, cy + y, color);
                if (y != 0) target.setPixel32(cx + x, cy - y, color);
                if (x != 0 && y != 0) target.setPixel32(cx - x, cy - y, color);
                if (x != y) {
                    target.setPixel32(cx + y, cy + x, color);
                    if (y != 0) target.setPixel32(cx - y, cy + x, color);
                    if (x != 0) target.setPixel32(cx + y, cy - x, color);
                    if (y != 0 && x != 0) target.setPixel32(cx - y, cy - x, color);
                }
                
                error += y;
                ++y;
                error += y;
                if (error >= 0) {
                    --x;
                    error -= x;
                    error -= x;
                }
            }
        }
    }
}