/**
 * Copyright George.Profenza ( http://wonderfl.net/user/George.Profenza )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vqvR
 */

// forked from George.Profenza's PV3DExporterTest
package {
    import flash.net.FileReference;
    import flash.display.*;
    import flash.events.*;
    import flash.utils.ByteArray;
    import org.papervision3d.core.io.exporters.ExportCollada;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.PaperPlane;
    import org.papervision3d.objects.special.UCS;

    public class PV3DExportTest extends BasicView {
        private var container:DisplayObject3D;
        public function PV3DExportTest()  {
            super(640,480,false,false,"Debug");
            scene.addChild(new UCS(1000));
            var light:PointLight3D = scene.addChild(new PointLight3D()) as PointLight3D; light.x = light.y = light.z = 100;
            container = scene.addChild(new DisplayObject3D());
            container.rotationY = 160;
            camera.target = container;
            camera.x = 200;camera.y = 400;camera.rotationX = 38;camera.rotationY=53;
            var np:int = 12;
            var air:Number = Math.PI * 2 / np;
            var aid:Number = air * 57.2957795;
            for(var i:int = 0; i < np; i++){
                var plane:DisplayObject3D = container.addChild(new PaperPlane(new FlatShadeMaterial(light,0xFFFF00*(i+1),0xFF6600*(i+1)),1));
                plane.material.doubleSided = true;
                plane.x = Math.cos(air*i) * 200;
                plane.z = Math.sin(air*i) * 200;
                plane.rotationY = -aid*i;
                plane.rotationX = -60+10*i;
            }
            startRendering();
            stage.doubleClickEnabled = true;
            stage.addEventListener(MouseEvent.DOUBLE_CLICK,save);
        }
        override protected function onRenderTick(event:Event = null):void{
            super.onRenderTick();
            container.rotationY -= 3;
        }
        private function save(event:
        MouseEvent):void{
            var data:ByteArray = new ByteArray();
            data.writeUTFBytes(ExportCollada.export(container));
            new FileReference().save(data,'container.dae');
        }
    }
}