/**
 * Copyright kenbu ( http://wonderfl.net/user/kenbu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vqR8
 */

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.display.StageAlign;
	import flash.display.StageScaleMode;
	import flash.events.Event;
	import flash.geom.Rectangle;
         import flash.geom.Point;
	
        // [SWF(width="500", height="500", backgroundColor="0xFFFFFF", frameRate="40")] 

	public class Main extends Sprite
	{
		
		private var maze:Maze;
		private var bitmap:Bitmap;
		
		private const WIDTH:Number = 101;
		private const HEIGHT:Number = 101;
		private const SCALE:Number = 4;
		
		public function Main()
		{
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP_LEFT;
			
			var progressArray:Array = [];
			maze = new DigMaze(WIDTH,HEIGHT,progressArray);
			
			var bitmapData:BitmapData = new BitmapData(WIDTH*SCALE, HEIGHT*SCALE);
			bitmap = new Bitmap(bitmapData);
			addChild(bitmap);
			
		
			this.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		

		private var cnt:int = 0;
		private function enterFrameHandler(event:Event):void
		{
			var l:int = 50;
			for(var i:int = 0; i<l; i++)
			{
				draw();
			}
			if(cnt == maze.buildProgressArray.length)
			{
				this.removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
			}
		}
		
		
		private var rect:Rectangle = new Rectangle(0,0,0,0);
		private function draw():void
		{
			if(cnt == maze.buildProgressArray.length)
			{
				return;
			}
			
			var point:MazePoint = maze.buildProgressArray[cnt];
			var color:Number;
			if(point.value == 0)
			{
				color = 0xffffffff;
			}
			else
			{
				color = 0xff000000;
			}
			var scale:Number = 3;
			
			var bitmapData:BitmapData = bitmap.bitmapData;
			
			rect.x = point.x * SCALE;
			rect.y = point.y * SCALE;
			rect.width = SCALE;
			rect.height = SCALE;
			
			
			bitmapData.fillRect(rect, color);

			
			cnt++;


		
		}
	}
}

	class Maze
	{
		
		public var width:uint;
		public var height:uint;
		public var data:Array;
		public var buildProgressArray:Array;
		

		public function Maze(width:uint, height:uint, buildProgressArray:Array = null)
		{
			this.width = width;
			this.height = height;
			this.buildProgressArray = buildProgressArray;
			initialize();
		}
		
		protected function initialize():void
		{
			data = [];
		}
		
		
		protected function setData(x:uint, y:uint, value:uint):void
		{	
			//value : 1(壁)　, 0(道)
			data[x + width*y] = value;

			if(buildProgressArray)
			{
				buildProgressArray.push(new MazePoint(x, y, value));
			}
		}

		public function getData(x:uint, y:uint):uint
		{
			return data[x + width*y];
		}

	}



	import flash.geom.Point;
	
	class DigMaze extends Maze
	{
		
		

		public function DigMaze(width:uint, height:uint, buildProgressArray:Array = null,density:Number = 1)
		{
			super(width, height, buildProgressArray);
			
		}
		
		override protected function initialize():void
		{
			super.initialize();
			
			setDefWall();
			setWall();
			

		}
		
		private var startPointArray:Array = [];
		
		private function setDefWall():void
		{
			//まずすべてを壁でうめる
			for(var y:int = 0; y< height; y++)
			{
				for(var x:int = 0; x< width; x++)
				{
					setData(x,y,1);
					
					//起点になれる座標配列を作る。
					if(y==0 || y == height-1 || x==0 || x == width-1)
					{
						continue;
					}
					if(x%2 == 1 && y%2 == 1)
					{
						startPointArray.push(new MazePoint(x,y,1));
					}
					
				
				}	
			}
			
			//↓シャッフル・・をさせる。
			//startPointArray.
			
		}
		
		
		private function setWall():void
		{
			
			startPointArray.forEach(function(p:MazePoint,i:int, arr:Array):void
			{

				if(p.value != 0)
				{
					var loop:Boolean = true;
					
					var x:uint = p.x;
					var y:uint = p.y;
					
					while(loop)
					{
						var dir:String = checkRandomDicrectionCreate2Panel(x,y);
					

						if(dir != "")
						{
							//塗りつぶし処理をする。と。
							//setData(x,y,0);
							switch(dir)
							{
								case TOP:
									setData(x,y-1,0);
									setData(x,y-2,0);
									y -= 2;
									break;
								case RIGHT:
									setData(x+1,y,0);
									setData(x+2,y,0);
									x+=2;
									
									break;
								case BOTTOM:
									setData(x,y+1,0);
									setData(x,y+2,0);
									y +=2;
									break;
								case LEFT:
									setData(x-1,y,0);
									setData(x-2,y,0);
									x -=2;
									break;
							}
						}
						else
						{
							loop = false;
						}
					}
				}
			
			});
		}
		
		private static const TOP:String = "top";
		private static const RIGHT:String = "right";
		private static const BOTTOM:String = "bottom";
		private static const LEFT:String = "left";
		
		private function checkRandomDicrectionCreate2Panel(x:uint, y:uint):String
		{
			//生成できる方向をかえす
			var enabledArray:Array = [];
			if(getData(x-1,y) == 1 && getData(x-2,y) == 1 && x!=2)
			{
				//左は動ける。
				enabledArray.push(LEFT);
			}
			if(getData(x,y-1) == 1 && getData(x,y-2) == 1 && y!=2)
			{
				//上に動ける。
				enabledArray.push(TOP);
			}
			if(getData(x+1,y) == 1 && getData(x+2,y) == 1 && x!=width-2)
			{
				//右に動ける。
				enabledArray.push(RIGHT);
			}
			if(getData(x,y+1) == 1 && getData(x,y+2) == 1 && y!=height-2)
			{
				//下に動ける。
				enabledArray.push(BOTTOM);
			}

			if(enabledArray.length > 0)
			{
				return enabledArray[int(enabledArray.length*Math.random())];
			}
			return "";
		}
		

	}




	




	
         import flash.geom.Point;
	class MazePoint extends Point
	{
		public var value:int;
		public function MazePoint(x:Number,y:Number,value:int)
		{
			super(x,y);
			this.value = value;
		}
		
	}





