/**
 * Copyright toastie ( http://wonderfl.net/user/toastie )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vq2f
 */

// forked from Arkatufus's TIGSource Mini Game JAM
// forked from scarybug's forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked f
// http://forums.tigsource.com/index.php?topic=9549.0
// TIGSource collaborative game experiment #1

package {
	import flash.display.*;
	import flash.events.KeyboardEvent;
	import flash.events.Event;
	import flash.geom.Rectangle;
	import flash.geom.Point;
	import flash.text.TextField;
       
	[SWF(width=465, height=465, frameRate=60)]
	public class CollabGame extends Sprite {

		public var player:Player;
		public var freedom:Freedom;

		public var enemies:Array;
		public var flaggedEnemies:Array;

		private var inputArray:Array;
		public var drawing_area:Bitmap;
		private var trail_image:Shape;
		private var updateList:Array;

		private var scoreLabel:TextField;

		public var score:int=0;
		public var multiplier:int=1;

		public function CollabGame():void {
			initInput();
			initGame();
		}

		private function initInput():void {

			this.inputArray = new Array();
			for (var i:uint =0; i < 256; i++) {
				inputArray.push(false);
			}

			stage.addEventListener(KeyboardEvent.KEY_DOWN,onKeyDown);
			stage.addEventListener(KeyboardEvent.KEY_UP,onKeyUp);
			this.addEventListener(Event.ENTER_FRAME, updateGame);
		}

		public function onKeyDown(e:KeyboardEvent):void {
			inputArray[e.keyCode]=true;
		}

		public function onKeyUp(e:KeyboardEvent):void {
			inputArray[e.keyCode]=false;
		}

		public function collision():void {
			var i:int;
			var enemy:Enemy;

			for (i=enemies.length; i--; ) {
				enemy=enemies[i];
				if (enemy.hitTestPoint(player.x,player.y)) {
					enemy.flag();
				}
			}
			if (freedom.hitTestPoint(player.x,player.y))  freedom.flag();
		}

		public function updateGame(e:Event):void {

			scoreLabel.text = "LEVEL: "+multiplier+" | SCORE: "+score + " | ROPE LEFT: "+player.rope_count;
			scoreLabel.autoSize="left";

			updateGameEntities();
			updateEnemies();
			collision();

			if (inputArray[37]) player.rotation-=4;

			if (inputArray[39]) player.rotation+=4;

			if (inputArray[38]) {
				player.move();
				player.speed=Math.abs(player.speed);
			}

			if (inputArray[40]) {
				player.move();
				player.speed=-1*Math.abs(player.speed);
			}

			if (inputArray[38]||inputArray[40]) {
				trail_image.x=player.x;
				trail_image.y=player.y;
				if ((inputArray[32] || inputArray[90]) &&player.rope_count>0) {
					drawing_area.bitmapData.draw(trail_image, trail_image.transform.matrix);
					if (player.rope_count>0) {
						player.rope_count--;
					}
				}
			}
		}

		private function updateGameEntities():void {
			for (var i:uint=0; i < updateList .length; i++) {
				updateList[i].update();
			}
		}

		private function updateEnemies():void {
			if(flaggedEnemies.length == enemies.length){
				player.rope_count=Player.default_rope_count;
				multiplier++;
				unflagAll();
			}
		}

		private function unflagAll():void {
			drawing_area.bitmapData.fillRect(new Rectangle(0, 0, 465, 465), 0xFFFFFF);
			for (var i:uint=0; i < enemies.length; i++) {
				enemies[i].unflag();
			}
			flaggedEnemies.length = 0;
			score+=int(player.rope_count/10); //bonus point for each 10 extra counts of rope!
			
			freedom.spawn();
			if(updateList.indexOf(freedom) == -1) addGameEntity(freedom);
		}

		private function addGameEntity(entity:GameEntity):void {
			updateList.push(entity);
			addChild(entity);
		}

		public function removeGameEntity(entity:GameEntity):void {
			updateList.splice(updateList.indexOf(entity), 1);
			removeChild(entity);
		}

		private function initGame():void {

			updateList = new Array();

			player = new Player();
			player.speed=3;
			drawing_area=new Bitmap(new BitmapData(465,465,false));
			addChild(drawing_area);
			addGameEntity(player);

			trail_image = new Shape();
			trail_image.graphics.beginFill(0x00FF00);
			trail_image.graphics.drawCircle(0, 0, 2);
			trail_image.graphics.endFill();

			player.x=465/2;
			player.y=465/2;
			player.rotation=180;
			player.rope_count=Player.default_rope_count;
			
			flaggedEnemies = new Array();
			enemies = new Array();
			for (var i:uint=0; i < 15; i++) {
				var newEnemy:Enemy=new Enemy(this);
				enemies.push(newEnemy);
				newEnemy.x=Math.random()*465;
				newEnemy.y=Math.random()*465;
				newEnemy.rotation=Math.random()*360;
				addGameEntity(newEnemy);
			}

			freedom = new Freedom(this);
			addGameEntity(freedom);
			freedom.spawn();

			scoreLabel = new TextField();
			scoreLabel.text="SCORE: 0";
			addChild(scoreLabel);

		}
	}
}


import flash.display.Sprite;

internal class PlayerGraphic extends Sprite {
    function PlayerGraphic () {
        
	graphics.clear();
	graphics.beginFill(0xff0000);
	graphics.drawCircle(0,0,15);
	graphics.endFill();

	graphics.beginFill(0x00ff00);
	graphics.drawRect(0, -1, 10, 2);
	graphics.endFill();        
    }
    
}

import flash.display.Sprite;
import flash.geom.Point;

internal class GameEntity extends Sprite {
	//x and y velocities
	public var vec:Point;
	public var rot:Number = 0;
	public var speed:Number = 1; 
	public var is_flagged:Boolean;
  
	public function GameEntity (){}
	public function update() : void {}

	public function updateVelocities():void{
	    rot = this.rotation * 0.0174532925;
	    vec = Point.polar(speed, rot);
	}

	public function move():void{
		updateVelocities();
		x += vec.x;
		y += vec.y;
		if(y > 470) y = -10; 
		if(y < -10) y = 470;
		if(x > 470) x = -10;
		if(x < -10) x = 470;
	}
	
	public function draw(col1:uint, col2:uint):void{
		graphics.clear();
		graphics.beginFill(col1);
		graphics.drawCircle(0,0,15);
		graphics.endFill();

		graphics.beginFill(col2);
		graphics.drawRect(0, -1, 10, 2);
		graphics.endFill();
	}
}

internal class Player extends GameEntity {
	public var rope_count:int=0;
	public static var default_rope_count:int=500;

        public var graphic:Sprite;

	public function Player() {
                graphic = new PlayerGraphic();
                addChild(graphic);
		//draw(0x00ff00, 0x0000ff);
		//this.scaleX = this.scaleY = 0.75;
	}
}

internal class Enemy extends GameEntity {
	protected var wander:WanderAround;
	protected var wanderCollide:WanderAroundCollide;
    
	public var game:CollabGame;
	protected var strategy:Strategy;

	public function Enemy (cg:CollabGame){
		super();
		game = cg;
		speed =  1; 
		draw(0xff0000, 0x0000ff);
		wander = new WanderAround(this);
		wanderCollide = new WanderAroundCollide(this);
		strategy = wanderCollide;
	}

	public override function update() : void {
		strategy.update();
	}

	public function flag() : void {
		if(!is_flagged){
			game.score += game.multiplier;
			game.player.rope_count += 10;
			is_flagged = true;
			game.flaggedEnemies.push(this);
			speed = game.multiplier * 0.95;
			
			var sx:Number = this.scaleX * 0.95;
			if(sx < 0.2) sx = 0.2;
			this.scaleX = this.scaleY = sx;
			strategy = wander;
			
			draw(0x0000ff, 0x00ff00);
		}  
	}

	public function unflag() : void {
		if(is_flagged){
			speed = game.multiplier * 0.95;
			is_flagged = false;
			strategy = wanderCollide;
			
			draw(0xff0000, 0x0000ff);
		}  
	}

	public function resurrect():void{
		if(is_flagged){
			game.score -= game.multiplier;
			game.player.rope_count -= 10;
			is_flagged = false
			this.scaleX = this.scaleY *= 1.05;
			game.flaggedEnemies.splice(game.flaggedEnemies.indexOf(this), 1);
			speed = game.multiplier * 1.3;
			strategy = wanderCollide;
			
			draw(0xffff00, 0x0000ff);
		}  
	}
}

internal class Freedom extends Enemy{
	protected var runAway:RunAway;
	protected var seekBlue:SeekBlue;
	
	private var life:int;
	private var invincible:int;

	public function Freedom(cg:CollabGame) {
		super(cg);
		speed = 1.1;
		
		runAway = new RunAway(this, game.player);
		seekBlue = new SeekBlue(this, game.flaggedEnemies);
		
		draw(0xff00ff, 0x00ff00);
	}

	public function spawn():void {
		life = 3;
		speed = game.multiplier * 1.4;
		strategy = wander;
	}

	override public function flag():void {
		if (invincible>0) return;

		invincible=240;
		life--;
		if (life==0) {
			game.removeGameEntity(this);
			return;
		}
		strategy = runAway;
	}

	override public function update():void {
		if (strategy is WanderAround&&game.flaggedEnemies.length > 0) strategy = seekBlue;
		if (strategy.update())  strategy = wander;
		invincible--;
	}

	override public function move():void {
		strategy.move();
	}
}

internal class SeekBlue implements Strategy{
	private var owner:Enemy;
	private var target:Enemy;
	private var targets:Array;

	private var dx:Number;
	private var dy:Number;
	private var _distance:Number;

	public function SeekBlue(o:Enemy, t:Array):void {
		owner=o;
		targets=t;
		target=targets[0];
	}

	public function update():Boolean {
		if (_distance<2) {
			target.resurrect();
		}
		if (targets.length==0) {
			return true;
		}

		target=targets[0];

		dx=target.x-owner.x;
		dy=target.y-owner.y;
		var rot:Number=Math.atan2(dy,dx)*57.2957795131;
		owner.rotation=rot;
		move();
		return false;
	}

	public function move():void {
		_distance=Math.sqrt(dx*dx+dy*dy);
		var factor:Number=1/_distance*owner.speed;
		owner.x+=dx*factor;
		owner.y+=dy*factor;
	}
}

internal class RunAway implements Strategy{
	private var owner:Enemy;
	private var target:Player;

	private var dx:Number;
	private var dy:Number;
	private var _distance:Number;

	public function RunAway(o:Enemy, t:Player):void {
		owner=o;
		target=t;
	}

	public function update():Boolean {
		if (_distance>200) return true;
		dx=owner.x-target.x;
		dy=owner.y-target.y;
		var rot:Number=Math.atan2(dy,dx)*57.2957795131;
		owner.rotation=rot;
		move();
		return false;
	}

	public function move():void {
		_distance=Math.sqrt(dx*dx+dy*dy);
		var factor:Number=1/_distance*owner.speed;
		owner.x+=dx*factor;
		owner.y+=dy*factor;
	}
}

internal class WanderAround implements Strategy{
	private var owner:Enemy;
	
	public var turnDeviation:Number = 0;
	public var vec:Point;
	public var rot:Number = 0;

	public function WanderAround(o:Enemy):void{
		owner = o;
	}

	public function update():Boolean{
		turnDeviation += (-1 + (Math.random() * 2));
		if(turnDeviation > 4) turnDeviation = 4;
		if(turnDeviation < -4) turnDeviation = -4;
		owner.rotation += turnDeviation;
		move();
		return false;
	}

	public function move():void{
	    rot = owner.rotation * 0.0174532925;
	    vec = Point.polar(owner.speed, rot);
	    
		var x:Number = owner.x;
		var y:Number = owner.y;
		
		x += vec.x;
		y += vec.y;
		if(y > 470) y = -10; 
		if(y < -10) y = 470;
		if(x > 470) x = -10;
		if(x < -10) x = 470;
		owner.x = x;
		owner.y = y;
	}		
}

internal class WanderAroundCollide implements Strategy{
	private var owner:Enemy;
	
	public var turnDeviation:Number = 0;
	public var vec:Point;
	public var rot:Number = 0;

	public function WanderAroundCollide(o:Enemy):void{
		owner = o;
	}

	public function update():Boolean{
		turnDeviation += Math.random() * 2 - 1;
		if(turnDeviation > 4) turnDeviation = 4;
		if(turnDeviation < -4) turnDeviation = -4;
		owner.rotation += turnDeviation;
		move();  
		
		if(!owner.is_flagged && owner.game.drawing_area.bitmapData.getPixel(owner.x, owner.y)==0x00FF00){
			owner.rotation+=180;
			move();   //move again to free yourself if you're caught!
		}
		return false;
	}

	public function move():void{
	    rot = owner.rotation * 0.0174532925;
	    vec = Point.polar(owner.speed, rot);
	    
		var x:Number = owner.x;
		var y:Number = owner.y;
		
		x += vec.x;
		y += vec.y;
		if(y > 470) y = -10; 
		if(y < -10) y = 470;
		if(x > 470) x = -10;
		if(x < -10) x = 470;
		owner.x = x;
		owner.y = y;
	}		
}

internal interface Strategy{
	function update():Boolean;
	function move():void;
}