/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vpMl
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Rectangle;
    import net.hires.debug.Stats;
    import org.flintparticles.twoD.emitters.Emitter2D;
    import org.flintparticles.twoD.renderers.PixelRenderer;
    
    [SWF(width=465, height=465, backgeoundColor=0x000000, frameRate=60)]
    
    public class FlashTest extends Sprite {
        private var _emitter:Emitter2D;
        
        public function FlashTest() {
            if(stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);            
        }
        
        private function init(e:Event=null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            _emitter = new ColdSphere();
            
            var renderer:PixelRenderer = new PixelRenderer(new Rectangle(0, 0, 465, 465));
            renderer.addFilter(new BlurFilter(2, 2, 1));
            renderer.addEmitter(_emitter);
            addChild(renderer);
            
            _emitter.start();
            _emitter.runAhead(0, 60);
        }
    }
}

import flash.geom.Point;
import org.flintparticles.common.actions.Age;
import org.flintparticles.common.actions.ColorChange;
import org.flintparticles.common.counters.Steady;
import org.flintparticles.common.initializers.ColorInit;
import org.flintparticles.common.initializers.Lifetime;
import org.flintparticles.twoD.actions.CollisionZone;
import org.flintparticles.twoD.actions.Move;
import org.flintparticles.twoD.emitters.Emitter2D;
import org.flintparticles.twoD.initializers.Position;
import org.flintparticles.twoD.initializers.Velocity;
import org.flintparticles.twoD.zones.DiscZone;
import org.flintparticles.twoD.zones.LineZone;

class ColdSphere extends Emitter2D
{
    public function ColdSphere():void
    {
        counter = new Steady(500);
        addInitializer(new Position(new LineZone(new Point(233, 0), new Point(233, 465))));
        addInitializer(new Velocity(new DiscZone(new Point(0, 100), 100)));
        addInitializer(new Lifetime(1, 8));
        addAction(new CollisionZone(new DiscZone(new Point(233, 233), 100), 0.3));
        addAction(new Age());
        addAction(new Move());
        addAction(new ColorChange(0xffffffff, 0xff0000ff));
    }

}
