/**
 * Copyright hacker_szoe51ih ( http://wonderfl.net/user/hacker_szoe51ih )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vo58
 */

// forked from HaraMakoto's Electrogram clock 
package {
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;

	[SWF(width="465", height="465", backgroundColor="0x0", frameRate="90")]
	public class ElectrogramClock extends Sprite
	{
		//線を引くためのクラス
		private var _line:DrawLine = new DrawLine();
		//各数字の座標配列
		private var _line0:Array=[{x:-4.14,y:51.775},{x:4.735,y:51.837},{x:9.86,y:47.775},{x:14.11,y:30.15},{x:24.36,y:8.775},{x:39.423,y:-0.413},{x:47.36,y:-1.725},{x:49.63,y:-1.474},{x:50.383,y:2.419},{x:42.321,y:3.258},{x:26.198,y:13.166},{x:15.197,y:42.389},{x:14.776,y:71.612},{x:27.206,y:94.284},{x:57.772,y:105.872},{x:85.483,y:94.537},{x:96.064,y:71.612},{x:96.735,y:42.306},{x:87.33,y:16.527},{x:67.932,y:4.77},{x:55.084,y:3.09},{x:53.284,y:0.932},{x:57.86,y:-1.225},{x:70.548,y:0.962},{x:81.36,y:5.775},{x:90.61,y:15.087},{x:96.86,y:26.275},{x:99.86,y:35.337},{x:101.36,y:43.275},{x:101.11,y:49.462},{x:103.86,y:52.275},{x:108.36,y:52.275},{x:109.86,y:52.275}];
		private var _line1:Array=[{x:-5.916,y:50.071},{x:-2.446,y:50.337},{x:5.827,y:50.603},{x:14.368,y:45.733},{x:18.104,y:38.861},{x:17.914,y:30.099},{x:25.207,y:21.299},{x:32.261,y:19.198},{x:43.346,y:14.579},{x:53.422,y:6.267},{x:59.468,y:0.472},{x:59.468,y:51.193},{x:59.468,y:101.913},{x:64.073,y:103.348},{x:74.684,y:95.975},{x:83.091,y:68.885},{x:92.298,y:50.603},{x:103.441,y:50.603},{x:107.778,y:50.603}];
		private var _line2:Array=[{x:-5.013,y:45.603},{x:-0.142,y:45.603},{x:9.933,y:44.002},{x:14.989,y:36.404},{x:14.842,y:30.406},{x:15.346,y:22.932},{x:18.872,y:8.907},{x:29.789,y:-1.42},{x:45.744,y:-5.199},{x:66.402,y:-1.925},{x:82.021,y:14.954},{x:79.838,y:35.529},{x:70.601,y:46.529},{x:55.485,y:56.606},{x:38.355,y:66.682},{x:23.743,y:76.339},{x:12.155,y:95.569},{x:49.774,y:95.569},{x:87.394,y:95.569},{x:92.434,y:93.272},{x:97.473,y:86.17},{x:97.272,y:63.218},{x:100.674,y:45.071},{x:106.212,y:45.071},{x:108.146,y:45.071}];
		private var _line3:Array=[{x:0.491,y:46.071},{x:5.162,y:46.604},{x:13.836,y:45.536},{x:20.273,y:41.428},{x:22.707,y:28.717},{x:24.89,y:17.046},{x:38.159,y:-0.169},{x:66.961,y:-4.117},{x:91.229,y:8.564},{x:93.161,y:28.718},{x:86.527,y:38.794},{x:71.831,y:42.322},{x:53.608,y:44.84},{x:65.785,y:45.68},{x:84.513,y:49.544},{x:94.336,y:59.621},{x:96.604,y:75.743},{x:86.694,y:90.943},{x:67.717,y:98.584},{x:46.892,y:98.752},{x:30.098,y:91.866},{x:22.036,y:78.095},{x:20.021,y:64.323},{x:18.062,y:63.737},{x:16.505,y:67.954},{x:18.974,y:79.831},{x:23.444,y:89.305},{x:29.782,y:95.777},{x:46.93,y:101.048},{x:66.479,y:101.983},{x:83.227,y:97.312},{x:97.172,y:89.172},{x:101.908,y:78.63},{x:102.175,y:63.418},{x:102.442,y:51.407},{x:106.846,y:46.937},{x:113.652,y:46.071}];
		private var _line4:Array=[{x:-6.916,y:36.091},{x:1.521,y:38.716},{x:3.584,y:46.591},{x:3.834,y:70.716},{x:11.584,y:89.591},{x:42.461,y:89.588},{x:65.839,y:89.584},{x:65.839,y:39.536},{x:65.839,y:-10.512},{x:36.616,y:25.093},{x:7.393,y:60.698},{x:48.037,y:60.698},{x:88.681,y:60.698},{x:91.383,y:58.832},{x:94.084,y:52.091},{x:92.646,y:41.654},{x:97.584,y:36.091},{x:105.021,y:36.091},{x:106.084,y:36.091}];
		private var _line5:Array=[{x:-14.916,y:49.091},{x:-3.604,y:49.466},{x:0.584,y:55.091},{x:1.146,y:62.466},{x:5.084,y:64.591},{x:8.482,y:68.136},{x:8.506,y:71.682},{x:12.536,y:87.888},{x:24.629,y:98.553},{x:43.438,y:102.836},{x:66.277,y:98.553},{x:82.401,y:80.667},{x:82.401,y:56.231},{x:68.919,y:40.137},{x:44.109,y:35.406},{x:20.093,y:43.468},{x:11.192,y:51.529},{x:17.574,y:26.672},{x:23.956,y:1.816},{x:52.171,y:1.816},{x:80.386,y:1.816},{x:83.485,y:2.703},{x:86.584,y:12.591},{x:86.834,y:30.904},{x:87.084,y:43.591},{x:88.209,y:48.029},{x:91.584,y:49.091},{x:96.209,y:49.341},{x:98.584,y:49.591}];
		private var _line6:Array=[{x:-1.416,y:45.091},{x:7.959,y:46.966},{x:12.084,y:54.091},{x:14.879,y:58.473},{x:17.675,y:57.606},{x:31.698,y:36.613},{x:55.294,y:30.733},{x:80.738,y:41.146},{x:91.57,y:65.667},{x:79.227,y:91.699},{x:49.248,y:100.599},{x:23.132,y:86.323},{x:15.659,y:67.01},{x:14.735,y:43.077},{x:20.361,y:14.611},{x:39.423,y:-1.932},{x:66.044,y:-2.856},{x:84.854,y:11.001},{x:89.555,y:21.329},{x:90.507,y:33.46},{x:95.584,y:45.591},{x:105.646,y:45.591},{x:111.584,y:45.591}];
		private var _line7:Array=[{x:-5.416,y:43.591},{x:5.084,y:34.216},{x:8.084,y:18.091},{x:11.319,y:5.002},{x:22.067,y:-1.338},{x:57.336,y:-1.338},{x:92.604,y:-1.338},{x:77.91,y:14.785},{x:57.672,y:40.985},{x:47.175,y:69.368},{x:42.22,y:96.743},{x:48.277,y:99.355},{x:59.584,y:92.591},{x:72.459,y:63.654},{x:90.584,y:44.091},{x:104.334,y:44.091},{x:107.584,y:44.091}];
		private var _line8:Array=[{x:-3.916,y:52.091},{x:26.446,y:52.082},{x:60.569,y:50.366},{x:70.479,y:48.939},{x:85.426,y:40.962},{x:88.953,y:24.083},{x:77.365,y:8.716},{x:49.989,y:4.685},{x:25.638,y:12.745},{x:20.011,y:28.45},{x:22.951,y:39.619},{x:29.836,y:46.421},{x:45.791,y:51.711},{x:68.043,y:52.55},{x:86.769,y:60.444},{x:94.495,y:79.841},{x:88.113,y:96.72},{x:72.411,y:105.789},{x:51.166,y:108.812},{x:30.339,y:104.448},{x:17.576,y:94.033},{x:14.469,y:77.994},{x:18.92,y:64.474},{x:27.149,y:57.337},{x:36.385,y:53.726},{x:61.484,y:52.908},{x:92.584,y:52.091},{x:103.584,y:52.341},{x:108.584,y:52.591}];
		private var _line9:Array=[{x:-9.416,y:46.591},{x:4.084,y:48.966},{x:11.584,y:56.591},{x:12.34,y:68.304},{x:13.096,y:74.767},{x:25.775,y:95.087},{x:48.027,y:100.295},{x:69.357,y:93.661},{x:85.648,y:67.376},{x:86.992,y:32.36},{x:80.273,y:10.947},{x:65.242,y:-0.39},{x:42.654,y:-3.161},{x:21.577,y:4.733},{x:11.08,y:25.727},{x:15.446,y:49.323},{x:29.889,y:61.33},{x:52.31,y:63.934},{x:74.228,y:55.957},{x:84.473,y:38.742},{x:85.648,y:29.084},{x:86.929,y:25.588},{x:91.584,y:22.091},{x:97.021,y:26.654},{x:99.084,y:34.591},{x:99.084,y:42.779},{x:103.584,y:47.591}];
		//全部入り配列
		private var _allTimeList:Array;
		//現在表示の時間の座標配列
		private var _displayTimeList:Array = new Array();
		//時計クラス
		private var _clock:clockMaster = new clockMaster();
		//残像表示のためのbitmap
		private var _bmp:Bitmap = new Bitmap();
		private var _bmd:BitmapData = new BitmapData(465, 465,true,0);
		private var Mtx:Matrix = new Matrix();
		
		public function ElectrogramClock()
		{
			_step1_setDisplay();
			_step2_setClock();
			_step3_setBmpEffect();
		}
		//step1 表示オブジェクトの配置と配列の設定
		private function _step1_setDisplay():void
		{
			_allTimeList = [
				_line0,_line1,_line2,_line3,_line4,_line5,_line6,_line7,_line8,_line9
			];
			addChild(_bmp);
			addChild(_line);
		}
		//step2 時計を設定する
		private function _step2_setClock():void
		{
			_refleshDisplay(); //時間を時計に反映
			_clock.addEventListener(ClockEvent.SECONDS_CHANGED, _secHandler);
			_clock.addEventListener(ClockEvent.MINUTES_CHANGED, _minHandler);
		}
		private function _secHandler(e:ClockEvent):void
		{
			_line.getListAndDraw(_displayTimeList);
		}
		private function _minHandler(e:ClockEvent):void
		{
			_refleshDisplay();
		}
		
		//step3　残像効果を設定する
		private function _step3_setBmpEffect():void
		{
			_bmp.bitmapData = _bmd;
			addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
		}
		private function _enterFrameHandler(e:Event):void
		{
			_bmd.draw(_line);
			_bmd.applyFilter(_bmd,_bmd.rect,new Point(0,0),new BlurFilter(4,4));
		}
		
		//分が変わるごとに時計の表示をリフレッシュ
		private function _refleshDisplay():void
		{
			_displayTimeList = new Array();
			var i:uint=0;
			var _xUnit:Number = 107;
			var len:int = _allTimeList[_clock.hoursUpper].length;
			for(i=0; i<len; i++) {
				_displayTimeList.push(new Point(_allTimeList[_clock.hoursUpper][i].x, _allTimeList[_clock.hoursUpper][i].y) );
			}
			len = _allTimeList[_clock.hoursLower].length;
			for(i=0; i<len; i++) {
				_displayTimeList.push(new Point(_allTimeList[_clock.hoursLower][i].x+_xUnit, _allTimeList[_clock.hoursLower][i].y) );
			}
			len = _allTimeList[_clock.minutesUpper].length;
			for(i=0; i<len; i++) {
				_displayTimeList.push(new Point(_allTimeList[_clock.minutesUpper][i].x+_xUnit*2, _allTimeList[_clock.minutesUpper][i].y) );
			}
			len = _allTimeList[_clock.minutesLower].length;
			for(i=0; i<len; i++) {
				_displayTimeList.push(new Point(_allTimeList[_clock.minutesLower][i].x+_xUnit*3, _allTimeList[_clock.minutesLower][i].y) );
			}
			_displayTimeList.push(new Point(470,47));
			_displayTimeList.push(new Point(490,47+10));
			_displayTimeList.push(new Point(520,47-10));
			
		}
	
	}
}
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.display.DisplayObject;
	import flash.events.EventDispatcher;
	
/**
 *指定の座標を配列で受け取って、順番に移動するクラス
*/
class DrawLine extends Sprite {
	private var _listLength:int;
	private var _counter:int = 0;
	private var _pointer:Sprite = new Sprite();
	private var _positionList:Array; //座標の入った配列
	private var lineBase:Sprite = new Sprite(); //線を描くレイヤー
	//尻尾を入れる配列
	private var _tailList:Array = [
		new Point(0,0), new Point(0,0), new Point(0,0), new Point(0,0), new Point(0,0)
	];
	private var tailLen:int = 5;
	public function DrawLine() {
		//表示オブジェクト設定
		addChild(lineBase);
		addChild(_pointer);
		lineBase.y = 150;
		//先導ポインタの表示
		_pointer.graphics.beginFill(0xFF0000,0); _pointer.graphics.drawCircle(0,0,2);
		_pointer.graphics.endFill();
	}
	
	//配列を受け取って、配列内容を描画する
	public function getListAndDraw(arr:Array):void
	{
		_counter = 0; //カウンターを戻す
		//尻尾配列もリセット
		for(var i:int=0; i<tailLen; i++) {
			_tailList[i].x = 0;
			_tailList[i].y = 0;
		}
		_listLength = arr.length; //配列の長さを取得
		_positionList = arr; //受け取った配列を取得
		//二重起動防止用
		if(hasEventListener(Event.ENTER_FRAME)) {
			removeEventListener(Event.ENTER_FRAME, _enterFrameHadler);
		}
		//毎フレームハンドラ実行
		addEventListener(Event.ENTER_FRAME, _enterFrameHadler);
	}
	//毎フレーム実行関数
	private function _enterFrameHadler(e:Event):void
	{
		_drawNext();
		_drawNext();
		_drawNext();
	}
	//配列に入った座標に順番に移動していく。
	private function _drawNext():void
	{
		if(_counter == _listLength) {
			removeEventListener(Event.ENTER_FRAME, _drawNext);
			lineBase.graphics.clear();
		} else {
			_pointer.x = _positionList[_counter].x;
			_pointer.y = _positionList[_counter].y;
			_chase();
			_drawLine();
			_counter++;
		}
	}
	//尻尾の配列の中身を順番にスライドさせる。
	private function _chase():void
	{
		for(var i:int=0; i<tailLen-1; i++) {
			_tailList[i].x = _tailList[i+1].x;
			_tailList[i].y = _tailList[i+1].y;
		}
		_tailList[tailLen-1].x = _pointer.x;
		_tailList[tailLen-1].y = _pointer.y;
	}
	//尻尾の配列の座標を線でつなぐ。
	private function _drawLine():void
	{
		lineBase.graphics.clear();
		lineBase.graphics.lineStyle(1,0xFFFFFF);
		lineBase.graphics.moveTo(_tailList[0].x, _tailList[0].y);
		for(var i:int=0; i<tailLen; i++) {
			lineBase.graphics.lineTo(_tailList[i].x, _tailList[i].y);
		}
	}
}


/**
 *時計を管理するクラス。
 */
class clockMaster extends EventDispatcher {
	private var _hours:int;
	private var _minutes:int;
	private var _seconds:int;
	private var preSeconds:int;
	private var _dispatcer:DisplayObject;
	public function clockMaster():void
	{
		_dispatcer = new Sprite();
		enterFrameHandler(null);
		_dispatcer.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
	}
	private function enterFrameHandler(e:Event):void
	{
		var _date:Date = new Date();
		//_hours = (24+(_date.getUTCHours() + _gmt)) % 24;
		_hours = (_date.getHours());
		_minutes = _date.getMinutes();
		_seconds = _date.getSeconds();
		if (_seconds != preSeconds) { 
			dispatchEvent(new ClockEvent(ClockEvent.SECONDS_CHANGED));
			if (_seconds == 0) { 
				dispatchEvent(new ClockEvent(ClockEvent.MINUTES_CHANGED));
				if (_minutes == 0) {
					dispatchEvent(new ClockEvent(ClockEvent.HOURS_CHANGED));
				}
			}
		}
		preSeconds = _seconds;
	}
	// 時間を返す
	public function get hours():int { return _hours; } 
	public function get minutes():int { return _minutes; }
	public function get seconds():int { return _seconds; }
	// 上位1桁返す
	public function get hoursUpper():int { return _hours / 10; }
	public function get minutesUpper():int { return _minutes / 10; }
	public function get secondsUpper():int { return _seconds / 10; }
	// 下位1桁返す
	public function get hoursLower():int { return _hours % 10; }
	public function get minutesLower():int { return _minutes % 10; }
	public function get secondsLower():int { return _seconds % 10; } 
	//アナログ時計にした時の針の角度を返す。
	public function get hoursDegree():Number {
		return ((_hours % 12) * 30) + (_minutes / 2) + (_seconds/120);
	}
	public function get minutesDegree():Number {
		return (_minutes * 6) + (_seconds / 10);
	}
	public function get secondsDegree():Number {
		return _seconds * 6;
	}
}

 /**
 *時計イベントクラス
 */
 class ClockEvent extends Event {
 	public static const HOURS_CHANGED:String = "hoursChanged";
 	public static const MINUTES_CHANGED:String = "minutesChanged";
 	public static const SECONDS_CHANGED:String = "secondsChanged";
 	public function ClockEvent(type:String, bubbles:Boolean=false, cancelable:Boolean=false){
 		super(type, bubbles, cancelable);
 	}
 	public override function clone():Event { 
 		return new ClockEvent(type, bubbles, cancelable);
 	}
 	public override function toString():String{ 
 		return formatToString("ClockEvent", "type", "bubbles", "cancelable", "eventPhase");
 	} 
 }