/**
 * Copyright yun ( http://wonderfl.net/user/yun )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vnrE
 */

// forked from yun's ロールオーバーで文字色と背景色を切り替える
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.events.MouseEvent;
    
    public class MyTextField extends Sprite {
        
        public var fld:TextField;
        public var tf:TextFormat;
        public var msg:String = "It is a practice of the text animation.\nIt discolors in the rollover."
        public var charPos:uint;
        public var counter:uint;
        public var currentMsg:String;
        public var timer:Timer;
        public var offset:int = Math.floor(30 * Math.random()) + 5;
        
        public function MyTextField() {
            tf = makeTextFormat("_sans", 18, 0x000000);
            // Text field.
            fld = new TextField();
            fld.x = 50;
            fld.y = 50;
            fld.background = true;
            fld.backgroundColor = 0xFFFFFF;
            fld.autoSize = TextFieldAutoSize.LEFT;
            // default of text format.
            fld.defaultTextFormat = tf;
            addChild(fld);
            // The text cannot be selected with the mouse.
            fld.selectable = false;
            // Setting of rollover event.
            fld.addEventListener(MouseEvent.ROLL_OVER, rollOverHandler);
            fld.addEventListener(MouseEvent.ROLL_OUT, rollOutHandler);
            // Timer that does loop for animation.
            timer = new Timer(10);
            timer.addEventListener(TimerEvent.TIMER, timerHandler);
            timer.start();
        }
        
        // Text format.
        public function makeTextFormat(font:String, size:uint, color:uint):TextFormat {
            var tf:TextFormat = new TextFormat();
            tf.font = font;
            tf.size = size;
            tf.color = color;
            return tf;
        }
        
        // Rollover.
        public function rollOverHandler(event:MouseEvent):void {
            // Setting of text color and background color
            fld.textColor = 0xFFFFFF;
            fld.backgroundColor = 0x000000;
        }
        
        // Rollout.
        public function rollOutHandler(event:MouseEvent):void {
            // Setting of text color and background color
            fld.textColor = 0x000000;
            fld.backgroundColor = 0xFFFFFF;
        }
        
        // One character is added while searching for the character-code. 
        public function timerHandler(event:TimerEvent):void {
            // Character-code whose only offset is smaller than character-code to be displayed.
            var startCharCode:uint = msg.charCodeAt(charPos) - offset;
            // The character-code is converted into the character. 
            var char:String = String.fromCharCode(startCharCode + counter);
            // New character and "_" are connected and displayed in the displayed text. 
            fld.text = msg.substring(0, charPos) + char + "_";
            // Character and comparison to be displayed.
            if (msg.charAt(charPos) == char) {
                // Whether it finished displaying all messages or not?
                    if(charPos == msg.length - 1) {
                    // End.
                    timer.stop();
                    fld.text = msg;    // To remove "_"of the end of sentence, msg is put again. 
                } else {
                    // Next, it moves to the displayed character. 
                    offset = Math.floor(30 * Math.random()) + 5;
                    charPos ++ ;
                    counter = 0;
                }
            } else {
                // It advances it to the following character-code. 
                counter ++ ;
            }
        }
    }
}