/**
 * Copyright Nyarineko ( http://wonderfl.net/user/Nyarineko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vndp
 */

//オーバーで単体のアニメーション
//クリックすると配置変更
package 
{
	import flash.events.*;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.*;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.events.InteractiveScene3DEvent;
	import org.libspark.betweenas3.BetweenAS3;
	import org.libspark.betweenas3.easing.*;
	import org.libspark.betweenas3.events.TweenEvent;
	import org.libspark.betweenas3.tweens.ITween;

    [SWF(width = "465", height = "465", backgroundColor = "0x121212")]
	
	public class Main extends BasicView
	{
		static public const OBJ_MAX:int = 60;
		static public const OBJ_CUT:int = 6;
		public var _list:Vector.<DisplayObject3D>;
		public var _posArray:Array;
		
		public function Main():void 
		{
			super(0, 0, true, true);
			stage.frameRate = 60; 
			camera.z = -500;   
			viewport.buttonMode = true;

			var light:PointLight3D = new PointLight3D();
			var material:FlatShadeMaterial = new FlatShadeMaterial(light, 0xFFFFFF, 0x000000);
			material.doubleSided = true;
			material.interactive = true;

			_list = new Vector.<DisplayObject3D>(OBJ_MAX, true);
			_posArray = new Array();
			
			for (var i:int = 0; i < OBJ_MAX; i++) 
			{
				var plane:Plane = new Plane(material, 50, 50, 1, 1);
				for each(var obj:* in plane.geometry.vertices){
				  obj.z-=200;
				}
				plane.rotationX = 57 - i % OBJ_CUT * (140 / OBJ_CUT);
				plane.rotationY = (360 / (OBJ_MAX / OBJ_CUT)) * Math.floor(i / OBJ_CUT);
				_list[i] = scene.addChild(plane);
				_list[i].addEventListener(InteractiveScene3DEvent.OBJECT_OVER, onOverPlane(i));
				
				_posArray[i] = new Array();
			}
			
			setPos();
			startRendering();
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, onChange2);
			stage.addEventListener(Event.ENTER_FRAME, onFrame1);
		}
		override protected function onRenderTick(event:Event=null):void
		{
			renderer.renderScene(scene, camera, viewport);
		}
		//くるくるプルプル
		private function onFrame1(e:Event):void
		{
			for (var i:int = 0; i < OBJ_MAX; i++) 
			{
				_posArray[i][1] += 0.2;
				_posArray[i][4] += 0.2;
				_list[i].rotationY +=0.2;
				
				var s:uint = 10;
				var m:uint = 8;
				if(_posArray[i][6] > 0){
					_posArray[i][6]--;
					_list[i].rotationX = _list[i].rotationX + (_posArray[i][3] - _list[i].rotationX) / s;
					if(_list[i].rotationX > _posArray[i][3] - 0.05) _posArray[i][3] = _posArray[i][0] + Math.random()*m-(m/2);
					else if(_list[i].rotationX > _posArray[i][3] + 0.05) _posArray[i][3] = _posArray[i][0] + Math.random()*m-(m/2);
					
					_list[i].rotationY = _list[i].rotationY + (_posArray[i][4] - _list[i].rotationY) / s;
					if(_list[i].rotationY > _posArray[i][4] - 0.05) _posArray[i][4] = _posArray[i][1] + Math.random()*m-(m/2);
					else if(_list[i].rotationY > _posArray[i][4] + 0.05) _posArray[i][4] = _posArray[i][1] + Math.random()*m-(m/2);
					
					_list[i].rotationZ = _list[i].rotationZ + (_posArray[i][5] - _list[i].rotationZ) / s;
					if(_list[i].rotationZ > _posArray[i][5] - 0.05) _posArray[i][5] = _posArray[i][2] + Math.random()*m-(m/2);
					else if(_list[i].rotationZ > _posArray[i][5] + 0.05) _posArray[i][5] = _posArray[i][2] + Math.random()*m-(m/2);
				}else{
					_list[i].rotationX = _list[i].rotationX + (_posArray[i][3] - _list[i].rotationX) / s;
					if(_list[i].rotationX > _posArray[i][3] - 0.05) _posArray[i][3] = _posArray[i][0];
					else if(_list[i].rotationX > _posArray[i][3] + 0.05) _posArray[i][3] = _posArray[i][0];
					
					_list[i].rotationY = _list[i].rotationY + (_posArray[i][4] - _list[i].rotationY) / s;
					if(_list[i].rotationY > _posArray[i][4] - 0.05) _posArray[i][4] = _posArray[i][1];
					else if(_list[i].rotationY > _posArray[i][4] + 0.05) _posArray[i][4] = _posArray[i][1];
					
					_list[i].rotationZ = _list[i].rotationZ + (_posArray[i][5] - _list[i].rotationZ) / s;
					if(_list[i].rotationZ > _posArray[i][5] - 0.05) _posArray[i][5] = _posArray[i][2];
					else if(_list[i].rotationZ > _posArray[i][5] + 0.05) _posArray[i][5] = _posArray[i][2];
				}
			}
		}
		private function onOverPlane(i:int):Function
        {
			return function (e:InteractiveScene3DEvent):void{;
				trace(i);
				_posArray[i][6] = 100;
			};
        }
		//球形配置
		private function onChange1(e:MouseEvent = null):void
		{
			stage.removeEventListener(Event.ENTER_FRAME, onFrame1);
			stage.removeEventListener(MouseEvent.MOUSE_DOWN, onChange1);
			for (var i:int = 0; i < OBJ_MAX; i++) 
			{
				var tw:ITween;
				tw = BetweenAS3.delay(
					BetweenAS3.parallel(
					BetweenAS3.tween(_list[i],{y:0},{y:_list[i].y},2,Elastic.easeOut),
					BetweenAS3.tween(_list[i],{z:0},{z:_list[i].z},2,Elastic.easeOut),
					BetweenAS3.tween(_list[i],{rotationX:57 - i % OBJ_CUT * (140 / OBJ_CUT)},{rotationX:_list[i].rotationX},2,Elastic.easeOut),
					BetweenAS3.tween(_list[i],{rotationY:(360 / (OBJ_MAX / OBJ_CUT)) * Math.floor(i / OBJ_CUT)},{rotationY:_list[i].rotationY},2,Elastic.easeOut),
					BetweenAS3.tween(_list[i],{rotationZ:0},{rotationZ:_list[i].rotationZ},2,Elastic.easeOut)
					),i*0.01);
				//開始
				if(i == OBJ_MAX-1) tw.addEventListener(TweenEvent.COMPLETE, function(e:TweenEvent):void
				{
					stage.addEventListener(MouseEvent.MOUSE_DOWN, onChange2);
					stage.addEventListener(Event.ENTER_FRAME, onFrame1);
					setPos();
				});
				tw.play();
			}
		}
		//螺旋形配置
		private function onChange2(e:MouseEvent = null):void
		{
			
			stage.removeEventListener(Event.ENTER_FRAME, onFrame1);
			stage.removeEventListener(MouseEvent.MOUSE_DOWN, onChange2);
			for (var i:int = 0; i < OBJ_MAX; i++) 
			{
				var tw:ITween;
				tw = BetweenAS3.delay(
					BetweenAS3.parallel(
					BetweenAS3.tween(_list[i],{y:i*5-150},{y:_list[i].y},2,Elastic.easeOut),
					BetweenAS3.tween(_list[i],{z:200-i*3},{z:_list[i].z},2,Elastic.easeOut),
					BetweenAS3.tween(_list[i],{rotationX:0},{rotationX:_list[i].rotationX},2,Elastic.easeOut),
					BetweenAS3.tween(_list[i],{rotationY:i*20},{rotationY:_list[i].rotationY},2,Elastic.easeOut),
					BetweenAS3.tween(_list[i],{rotationZ:0},{rotationZ:_list[i].rotationZ},2,Elastic.easeOut)
					),i*0.01);
				if(i == OBJ_MAX-1) tw.addEventListener(TweenEvent.COMPLETE, function(e:TweenEvent):void
				{
					stage.addEventListener(MouseEvent.MOUSE_DOWN, onChange3);
					stage.addEventListener(Event.ENTER_FRAME, onFrame1);
					setPos();
				});
				//開始
				tw.play();
			}
		}
		//ランダム配置
		private function onChange3(e:MouseEvent = null):void
		{
			stage.removeEventListener(Event.ENTER_FRAME, onFrame1);
			stage.removeEventListener(MouseEvent.MOUSE_DOWN, onChange3);
			for (var i:int = 0; i < OBJ_MAX; i++) 
			{
				var tw:ITween;
				tw = BetweenAS3.delay(
					BetweenAS3.parallel(
					BetweenAS3.tween(_list[i],{y:Math.random()*200-100},{y:_list[i].y},2,Elastic.easeOut),
					BetweenAS3.tween(_list[i],{z:Math.random()*360-180},{z:_list[i].z},2,Elastic.easeOut),
					BetweenAS3.tween(_list[i],{rotationX:Math.random()*360},{rotationX:_list[i].rotationX},2,Elastic.easeOut),
					BetweenAS3.tween(_list[i],{rotationY:Math.random()*360},{rotationY:_list[i].rotationY},2,Elastic.easeOut),
					BetweenAS3.tween(_list[i],{rotationZ:0},{rotationZ:_list[i].rotationZ},2,Elastic.easeOut)
					),i*0.01);
				if(i == OBJ_MAX-1) tw.addEventListener(TweenEvent.COMPLETE, function(e:TweenEvent):void
				{
					stage.addEventListener(MouseEvent.MOUSE_DOWN, onChange1);
					stage.addEventListener(Event.ENTER_FRAME, onFrame1);
					setPos();
				});
				//開始
				tw.play();
			}
		}
		//位置情報保存
		private function setPos():void
		{
			for (var i:int = 0; i < OBJ_MAX; i++) 
			{
				_posArray[i][0] = _list[i].rotationX;
				_posArray[i][1] = _list[i].rotationY;
				_posArray[i][2] = _list[i].rotationZ;
				_posArray[i][3] = _posArray[i][0] + Math.random()*2-1;
				_posArray[i][4] = _posArray[i][1] + Math.random()*2-1;
				_posArray[i][5] = _posArray[i][2] + Math.random()*2-1;
				_posArray[i][6] = 0;
			}
		}
	}
}