/**
 * Copyright sugyan ( http://wonderfl.net/user/sugyan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vm7U
 */

// forked from nengafl's nengafl
/*
 クリックするとランダムな色・形の円がランダムな方向に動いていくサンプル
*/
package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;

    public class Sample extends Sprite {
        public function Sample() {
            // クリックの検出
            // マウス座標を中心に円を出現させる
            stage.addEventListener(MouseEvent.CLICK, function(event:MouseEvent):void {
                    var circle:Circle = new Circle(event.stageX, event.stageY);
                    addChild(circle);
                }
            );
            // 出現させた円をそれぞれ動かす
            stage.addEventListener(Event.ENTER_FRAME, function():void {
            	        // すべてのchildに対しmove()を呼ぶ
                    for (var i:int = 0; i < numChildren; i++) {
                        var circle:Circle = getChildAt(i) as Circle;
                        circle.move();
                    }
                }
            );
        }
    }
}


import flash.display.Sprite;

class Circle extends Sprite {
	// 移動する速度
    private var vx:Number;
    private var vy:Number;

    public function Circle(x:Number, y:Number) {
        // 半径を10〜40でランダムに決定
        var r:Number = 10.0 + Math.random() * 30.0;
        // x, y 方向の移動速度を-5〜+5で指定
        vx = Math.random() * 10.0 - 5.0;
        vy = Math.random() * 10.0 - 5.0;
        // 塗りつぶしの色もランダムに
        var color:uint = Math.floor(Math.random() * 0xFFFFFF);
        
        graphics.beginFill(color);
        graphics.drawCircle(x, y, r);
    }

    // 生成時に指定した速度で移動させる
    public function move():void {
        x += vx;
        y += vy;
    }
}