/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/vm0P
 */

package  
{
    import flash.display.Shape;
    import flash.display.Sprite;
    
    /**
     * ...
     * @author umhr
     */
    public class Main2 extends Sprite 
    {
        
        public function Main2() 
        {
            setGradation(0xFF0000);
        }
        
        private function setGradation(rgb:uint):void {
            
            var colors:Array = [0xFF0000, 0x00FF00, 0x0000FF];
            var alphas:Array = [1, 1, 1];
            var rations:Array = [0, 200, 255];
            
            var shape:Shape = new Shape();
            Gradation.drawGradientRoundRect(shape, 0, 20, 80, 200, 8, colors, alphas, rations);
            shape.graphics.endFill();
            this.addChild(shape);
            
            var shape2:Shape = new Shape();
            Gradation.drawGradientRoundRect(shape2, 300, 200, 100, 60, 32, colors, alphas, rations);
            shape2.graphics.endFill();
            this.addChild(shape2);
            
            
            var shapeCircle:Shape = new Shape();
            Gradation.drawGradientCircle(shapeCircle, 200, 60, 50, colors, alphas, rations);
            this.addChild(shapeCircle);
            
            colors[0] = Gradation.rgbBrightness(rgb, 1);
            colors[1] = Gradation.rgbBrightness(rgb, 1.3);
            colors[2] = Gradation.rgbBrightness(rgb, 0.7);
            rations = [0, 90, 255];
            var shapeCircle2:Shape = new Shape();
            Gradation.drawGradientCircle(shapeCircle2, 100, 300, 60, colors, alphas, rations);
            this.addChild(shapeCircle2);
            
        }
        
    }

}

import flash.display.GradientType;
import flash.geom.Matrix;
class Gradation {
    public function Gradation() { };
    
    /**
     * RoundRectのグラデーションを設定します。
     * @param    target
     * @param    x
     * @param    y
     * @param    width
     * @param    height
     * @param    r
     * @param    colors
     * @param    alphas
     * @param    rations
     */
    static public function drawGradientRoundRect(target:*, x:Number, y:Number, width:Number, height:Number, r:Number, colors:Array, alphas:Array, rations:Array):void {
        target.graphics.beginGradientFill.apply(null, gradientFill(y, height, colors, alphas, rations));
        target.graphics.drawRoundRect(x, y, width, height, r, r);
        target.graphics.endFill();
    }
    /**
     * Circleのグラデーションを設定します。
     * @param    target
     * @param    x
     * @param    y
     * @param    r
     * @param    colors
     * @param    alphas
     * @param    rations
     */
    static public function drawGradientCircle(target:*,x:Number, y:Number, r:int, colors:Array, alphas:Array, rations:Array):void {
        target.graphics.beginGradientFill.apply(null, gradientFill(y-r,r+r, colors, alphas, rations));
        target.graphics.drawCircle(x, y, r);
        target.graphics.endFill();
    }
    
    static private function gradientFill(y:Number, height:int, colors:Array, alphas:Array, rations:Array):Array {
        var result:Array = [GradientType.LINEAR, colors, alphas, rations];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(1, height, Math.PI * 0.5, 0, y);
        result.push(matrix);
        return result;
    }
    
    /**
     * 色の明度を相対的に変えます。
     * rgb値と割合を与えて、結果を返す。
     * rgbは、0xffffff段階の値。
     * ratioが0の時に0x000000に、1の時にそのまま、2の時には0xffffffになる。
     * 相対的に、ちょっと暗くしたい時には、ratioを0.8に、
     * ちょっと明るくしたい時にはratioを1.2などに設定する。
     * @param    rgb
     * @param    ratio
     * @return
     */
    static public function rgbBrightness(rgb:int, ratio:Number):int {
        if(ratio < 0 || 2 < ratio){ratio = 1;trace("function colorBrightness 範囲外")}
        var _r:int = rgb >> 16;//16bit右にずらす。
        var _g:int = rgb >> 8 & 0xff;//8bit右にずらして、下位8bitのみを取り出す。
        var _b:int = rgb & 0xff;//下位8bitのみを取り出す。
        if(ratio <= 1){
            _r *= ratio;
            _g *= ratio;
            _b *= ratio;
        }else{
            _r = (255 - _r)*(ratio-1)+_r;
            _g = (255 - _g)*(ratio-1)+_g;
            _b = (255 - _b)*(ratio-1)+_b;
        }
        return _r<<16 | _g<<8 | _b;
    }
    
}